/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.train.basic;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.CalculateScore;
import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.train.basic.BasicEA;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;
import org.encog.neural.networks.training.TrainingSetScore;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class TrainEA
extends BasicEA
implements MLTrain {
    private static final long serialVersionUID = 1L;
    private final List<Strategy> strategies = new ArrayList<Strategy>();

    public TrainEA(Population thePopulation, CalculateScore theScoreFunction) {
        super(thePopulation, theScoreFunction);
    }

    public TrainEA(Population thePopulation, MLDataSet trainingData) {
        super(thePopulation, new TrainingSetScore(trainingData));
    }

    @Override
    public void setError(double error) {
    }

    @Override
    public boolean isTrainingDone() {
        for (Strategy strategy : this.strategies) {
            EndTrainingStrategy end;
            if (!(strategy instanceof EndTrainingStrategy) || !(end = (EndTrainingStrategy)strategy).shouldStop()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TrainingImplementationType getImplementationType() {
        return TrainingImplementationType.Iterative;
    }

    @Override
    public void iteration(int count) {
        int i = 0;
        while (i < count) {
            this.iteration();
            ++i;
        }
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }

    @Override
    public void addStrategy(Strategy strategy) {
        strategy.init(this);
        this.strategies.add(strategy);
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    @Override
    public void finishTraining() {
        super.finishTraining();
        this.getPopulation().setBestGenome(this.getBestGenome());
    }

    @Override
    public MLMethod getMethod() {
        return this.getPopulation();
    }

    @Override
    public MLDataSet getTraining() {
        return null;
    }

    @Override
    public List<Strategy> getStrategies() {
        return this.strategies;
    }

    @Override
    public void iteration() {
        this.preIteration();
        super.iteration();
        this.postIteration();
    }

    public void postIteration() {
        for (Strategy strategy : this.strategies) {
            strategy.postIteration();
        }
    }

    public void preIteration() {
        for (Strategy strategy : this.strategies) {
            strategy.preIteration();
        }
    }
}

