/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.versatile.normalizers;

import org.encog.EncogError;
import org.encog.ml.data.MLData;
import org.encog.ml.data.versatile.columns.ColumnDefinition;
import org.encog.ml.data.versatile.normalizers.Normalizer;

public class IndexedNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;

    public boolean equals(Object obj) {
        return obj instanceof IndexedNormalizer;
    }

    @Override
    public int outputSize(ColumnDefinition colDef) {
        return 1;
    }

    @Override
    public int normalizeColumn(ColumnDefinition colDef, String value, double[] outputData, int outputColumn) {
        if (!colDef.getClasses().contains(value)) {
            throw new EncogError("Undefined value: " + value);
        }
        outputData[outputColumn] = colDef.getClasses().indexOf(value);
        return outputColumn + 1;
    }

    @Override
    public String denormalizeColumn(ColumnDefinition colDef, MLData data, int dataColumn) {
        return colDef.getClasses().get((int)data.getData(dataColumn));
    }

    @Override
    public int normalizeColumn(ColumnDefinition colDef, double value, double[] outputData, int outputColumn) {
        throw new EncogError("Can't use an indexed normalizer on a continuous value: " + value);
    }
}

