/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.encog.ml.data.buffer.BufferedDataError;

public class EncogEGBFile {
    public static final int DOUBLE_SIZE = 8;
    public static final int HEADER_SIZE = 24;
    private final File file;
    private int inputCount;
    private int idealCount;
    private RandomAccessFile raf;
    private FileChannel fc;
    private final ByteBuffer headerBuffer;
    private ByteBuffer recordBuffer;
    private int recordCount;
    private int recordSize;
    private int numberOfRecords;

    public EncogEGBFile(File theFile) {
        this.file = theFile;
        this.headerBuffer = ByteBuffer.allocate(24);
    }

    public void addColumn(int col, boolean isInput) {
        try {
            ByteBuffer readBuffer = ByteBuffer.allocate(8192);
            ByteBuffer writeBuffer = ByteBuffer.allocate(8192);
            readBuffer.clear();
            writeBuffer.clear();
            readBuffer.order(ByteOrder.LITTLE_ENDIAN);
            writeBuffer.order(ByteOrder.LITTLE_ENDIAN);
            long readLocation = 24L;
            long writeLocation = 24L;
            int recordOffset = 0;
            this.fc.position(readLocation);
            this.fc.read(readBuffer);
            readLocation = this.fc.position();
            readBuffer.rewind();
            boolean done = false;
            int count = 0;
            do {
                if (readBuffer.hasRemaining()) {
                    double d = readBuffer.getDouble();
                    if (recordOffset == col) {
                        writeLocation = this.checkWrite(writeBuffer, writeLocation);
                        writeBuffer.putDouble(0.0);
                    }
                    writeLocation = this.checkWrite(writeBuffer, writeLocation);
                    writeBuffer.putDouble(d);
                    if (++recordOffset < this.recordCount) continue;
                    recordOffset = 0;
                    if (++count < this.numberOfRecords) continue;
                    done = true;
                    continue;
                }
                readBuffer.clear();
                readBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.fc.position(readLocation);
                this.fc.read(readBuffer);
                readLocation = this.fc.position();
                readBuffer.rewind();
            } while (!done);
            if (writeBuffer.position() > 0) {
                writeBuffer.flip();
                this.fc.write(writeBuffer, writeLocation);
            }
            if (isInput) {
                ++this.inputCount;
                ++this.recordCount;
            } else {
                ++this.idealCount;
                ++this.recordCount;
            }
            this.recordCount = this.inputCount + this.idealCount + 1;
            this.recordSize = this.recordCount * 8;
            this.raf.setLength(this.numberOfRecords * this.recordSize + 24);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void addRow(int row) {
        try {
            ++this.numberOfRecords;
            this.raf.setLength(this.numberOfRecords * this.recordSize + 24);
            int i = this.numberOfRecords - 1;
            while (i >= row) {
                int s = 24 + this.recordSize * i;
                int t = 24 + this.recordSize * i + this.recordSize;
                this.clear();
                this.fc.read(this.recordBuffer, s);
                this.recordBuffer.flip();
                this.fc.write(this.recordBuffer, t);
                --i;
            }
            this.clear();
            i = 0;
            while (i < this.recordCount - 1) {
                this.recordBuffer.putDouble(0.0);
                ++i;
            }
            this.recordBuffer.putDouble(1.0);
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer, 24 + this.recordSize * row);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    private long calculateIndex(long row) {
        return 24L + row * (long)this.recordSize;
    }

    private int calculateIndex(int row, int col) {
        return 24 + row * this.recordSize + col * 8;
    }

    private long checkWrite(ByteBuffer writeBuffer, long inWriteLocation) throws IOException {
        long writeLocation = inWriteLocation;
        if (!writeBuffer.hasRemaining()) {
            this.fc.position(writeLocation);
            writeBuffer.flip();
            this.fc.write(writeBuffer);
            writeLocation = this.fc.position();
            writeBuffer.clear();
            writeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return writeLocation;
    }

    private void clear() {
        this.recordBuffer.clear();
        this.recordBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void close() {
        try {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            if (this.fc != null) {
                this.fc.close();
                this.fc = null;
            }
            System.gc();
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void create(int theInputCount, int theIdealCount) {
        try {
            this.inputCount = theInputCount;
            this.idealCount = theIdealCount;
            double[] input = new double[this.inputCount];
            double[] ideal = new double[this.idealCount];
            this.file.delete();
            this.raf = new RandomAccessFile(this.file, "rw");
            this.raf.setLength(0L);
            this.fc = this.raf.getChannel();
            this.headerBuffer.clear();
            this.headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.headerBuffer.put((byte)69);
            this.headerBuffer.put((byte)78);
            this.headerBuffer.put((byte)67);
            this.headerBuffer.put((byte)79);
            this.headerBuffer.put((byte)71);
            this.headerBuffer.put((byte)45);
            this.headerBuffer.put((byte)48);
            this.headerBuffer.put((byte)48);
            this.headerBuffer.putDouble(input.length);
            this.headerBuffer.putDouble(ideal.length);
            this.numberOfRecords = 0;
            this.recordCount = this.inputCount + this.idealCount + 1;
            this.recordSize = this.recordCount * 8;
            this.recordBuffer = ByteBuffer.allocate(this.recordSize);
            this.headerBuffer.flip();
            this.fc.write(this.headerBuffer);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void deleteCol(int col) {
        try {
            ByteBuffer readBuffer = ByteBuffer.allocate(8192);
            ByteBuffer writeBuffer = ByteBuffer.allocate(8192);
            readBuffer.clear();
            writeBuffer.clear();
            readBuffer.order(ByteOrder.LITTLE_ENDIAN);
            writeBuffer.order(ByteOrder.LITTLE_ENDIAN);
            long readLocation = 24L;
            long writeLocation = 24L;
            int recordOffset = 0;
            this.fc.position(readLocation);
            this.fc.read(readBuffer);
            readLocation = this.fc.position();
            readBuffer.rewind();
            boolean done = false;
            int count = 0;
            do {
                if (readBuffer.hasRemaining()) {
                    double d = readBuffer.getDouble();
                    if (recordOffset != col) {
                        writeLocation = this.checkWrite(writeBuffer, writeLocation);
                        writeBuffer.putDouble(d);
                    }
                    if (++recordOffset < this.recordCount) continue;
                    recordOffset = 0;
                    if (++count < this.numberOfRecords) continue;
                    done = true;
                    continue;
                }
                readBuffer.clear();
                readBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.fc.position(readLocation);
                this.fc.read(readBuffer);
                readLocation = this.fc.position();
                readBuffer.rewind();
            } while (!done);
            if (writeBuffer.position() > 0) {
                writeBuffer.flip();
                this.fc.write(writeBuffer, writeLocation);
            }
            if (col < this.inputCount) {
                --this.inputCount;
                --this.recordCount;
            } else {
                --this.idealCount;
                --this.recordCount;
            }
            this.recordCount = this.inputCount + this.idealCount + 1;
            this.recordSize = this.recordCount * 8;
            this.raf.setLength(this.numberOfRecords * this.recordSize + 24);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void deleteRow(int row) {
        try {
            int i = row;
            while (i < this.numberOfRecords - 1) {
                int s = 24 + this.recordSize * i + this.recordSize;
                int t = 24 + this.recordSize * i;
                this.clear();
                this.fc.read(this.recordBuffer, s);
                this.recordBuffer.flip();
                this.fc.write(this.recordBuffer, t);
                ++i;
            }
            --this.numberOfRecords;
            this.raf.setLength(this.numberOfRecords * this.recordSize + 24);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public FileChannel getFc() {
        return this.fc;
    }

    public File getFile() {
        return this.file;
    }

    public ByteBuffer getHeaderBuffer() {
        return this.headerBuffer;
    }

    public int getIdealCount() {
        return this.idealCount;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    public ByteBuffer getRecordBuffer() {
        return this.recordBuffer;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public void open() {
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
            this.fc = this.raf.getChannel();
            this.headerBuffer.clear();
            this.headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
            boolean isEncogFile = true;
            this.fc.read(this.headerBuffer);
            this.headerBuffer.position(0);
            boolean bl = isEncogFile ? this.headerBuffer.get() == 69 : (isEncogFile = false);
            boolean bl2 = isEncogFile ? this.headerBuffer.get() == 78 : (isEncogFile = false);
            boolean bl3 = isEncogFile ? this.headerBuffer.get() == 67 : (isEncogFile = false);
            boolean bl4 = isEncogFile ? this.headerBuffer.get() == 79 : (isEncogFile = false);
            boolean bl5 = isEncogFile ? this.headerBuffer.get() == 71 : (isEncogFile = false);
            boolean bl6 = isEncogFile ? this.headerBuffer.get() == 45 : (isEncogFile = false);
            if (!isEncogFile) {
                throw new BufferedDataError("File is not a valid Encog binary file:" + this.file.toString());
            }
            char v1 = (char)this.headerBuffer.get();
            char v2 = (char)this.headerBuffer.get();
            String versionStr = "" + v1 + v2;
            try {
                int version = Integer.parseInt(versionStr);
                if (version > 0) {
                    throw new BufferedDataError("File is from a newer version of Encog than is currently in use.");
                }
            }
            catch (NumberFormatException ex) {
                throw new BufferedDataError("File has invalid version number.");
            }
            this.inputCount = (int)this.headerBuffer.getDouble();
            this.idealCount = (int)this.headerBuffer.getDouble();
            this.recordCount = this.inputCount + this.idealCount + 1;
            this.recordSize = this.recordCount * 8;
            this.numberOfRecords = this.recordSize == 0 ? 0 : (int)((this.file.length() - 24L) / (long)this.recordSize);
            this.recordBuffer = ByteBuffer.allocate(this.recordSize);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public double read() {
        try {
            this.clear();
            this.recordBuffer.limit(8);
            this.fc.read(this.recordBuffer);
            this.recordBuffer.position(0);
            return this.recordBuffer.getDouble();
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void read(double[] d) {
        try {
            this.clear();
            this.recordBuffer.limit(8 * d.length);
            this.fc.read(this.recordBuffer);
            this.recordBuffer.position(0);
            int i = 0;
            while (i < d.length) {
                d[i] = this.recordBuffer.getDouble();
                ++i;
            }
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void read(int row, double[] d) {
        try {
            this.clear();
            this.recordBuffer.limit(8 * d.length);
            this.fc.read(this.recordBuffer, this.calculateIndex(row));
            this.recordBuffer.position(0);
            int i = 0;
            while (i < this.recordCount) {
                d[i] = this.recordBuffer.getDouble();
                ++i;
            }
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public double read(int row, int col) {
        try {
            this.clear();
            this.recordBuffer.limit(8);
            this.fc.read(this.recordBuffer, this.calculateIndex(row, col));
            this.recordBuffer.position(0);
            return this.recordBuffer.getDouble(0);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void setLocation(int row) {
        try {
            this.fc.position(this.calculateIndex(row));
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void write(byte b) {
        try {
            this.clear();
            this.recordBuffer.put(b);
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void write(double[] v) {
        try {
            this.clear();
            double[] dArray = v;
            int n = v.length;
            int n2 = 0;
            while (n2 < n) {
                double element = dArray[n2];
                this.recordBuffer.putDouble(element);
                ++n2;
            }
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void write(int row, double[] v) {
        try {
            this.clear();
            double[] dArray = v;
            int n = v.length;
            int n2 = 0;
            while (n2 < n) {
                double element = dArray[n2];
                this.recordBuffer.putDouble(element);
                ++n2;
            }
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void write(int row, int col, double v) {
        try {
            this.clear();
            this.recordBuffer.putDouble(v);
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer, this.calculateIndex(row, col));
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    public void write(double d) {
        try {
            this.clear();
            this.recordBuffer.putDouble(d);
            this.recordBuffer.flip();
            this.fc.write(this.recordBuffer);
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }
}

