/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer;

import java.io.File;
import org.encog.NullStatusReportable;
import org.encog.StatusReportable;
import org.encog.ml.data.buffer.EncogEGBFile;
import org.encog.ml.data.buffer.codec.DataSetCODEC;

public class BinaryDataLoader {
    private DataSetCODEC codec;
    private StatusReportable status = new NullStatusReportable();

    public BinaryDataLoader(DataSetCODEC theCodec) {
        this.codec = theCodec;
    }

    public void external2Binary(File binaryFile) {
        this.status.report(0, 0, "Importing to binary file: " + binaryFile.toString());
        EncogEGBFile egb = new EncogEGBFile(binaryFile);
        egb.create(this.codec.getInputSize(), this.codec.getIdealSize());
        double[] input = new double[this.codec.getInputSize()];
        double[] ideal = new double[this.codec.getIdealSize()];
        this.codec.prepareRead();
        int index = 3;
        int currentRecord = 0;
        int lastUpdate = 0;
        double[] significance = new double[1];
        while (this.codec.read(input, ideal, significance)) {
            egb.write(input);
            egb.write(ideal);
            index += input.length;
            index += ideal.length;
            ++currentRecord;
            if (++lastUpdate >= 10000) {
                lastUpdate = 0;
                this.status.report(0, currentRecord, "Importing...");
            }
            egb.write(significance[0]);
        }
        egb.close();
        this.codec.close();
        this.status.report(0, 0, "Done importing to binary file: " + binaryFile.toString());
    }

    public void binary2External(File binaryFile) {
        this.status.report(0, 0, "Exporting binary file: " + binaryFile.toString());
        EncogEGBFile egb = new EncogEGBFile(binaryFile);
        egb.open();
        this.codec.prepareWrite(egb.getNumberOfRecords(), egb.getInputCount(), egb.getIdealCount());
        int inputCount = egb.getInputCount();
        int idealCount = egb.getIdealCount();
        double[] input = new double[inputCount];
        double[] ideal = new double[idealCount];
        int currentRecord = 0;
        int lastUpdate = 0;
        int i = 0;
        while (i < egb.getNumberOfRecords()) {
            int j = 0;
            while (j < inputCount) {
                input[j] = egb.read();
                ++j;
            }
            j = 0;
            while (j < idealCount) {
                ideal[j] = egb.read();
                ++j;
            }
            double significance = egb.read();
            this.codec.write(input, ideal, significance);
            ++currentRecord;
            if (++lastUpdate >= 10000) {
                lastUpdate = 0;
                this.status.report(egb.getNumberOfRecords(), currentRecord, "Exporting...");
            }
            ++i;
        }
        egb.close();
        this.codec.close();
        this.status.report(0, 0, "Done exporting binary file: " + binaryFile.toString());
    }

    public StatusReportable getStatus() {
        return this.status;
    }

    public void setStatus(StatusReportable theStatus) {
        this.status = theStatus;
    }

    public DataSetCODEC getCodec() {
        return this.codec;
    }
}

