/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.table;

import java.io.Serializable;
import org.encog.util.EngineArray;
import org.encog.util.Format;

public class TableLine
implements Serializable {
    private double probability;
    private final int result;
    private final int[] arguments;

    public TableLine(double prob, int result, int[] args) {
        this.probability = prob;
        this.result = result;
        this.arguments = EngineArray.arrayCopy(args);
    }

    public double getProbability() {
        return this.probability;
    }

    public int[] getArguments() {
        return this.arguments;
    }

    public int getResult() {
        return this.result;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("result=");
        r.append(this.result);
        r.append(",probability=");
        r.append(Format.formatDouble(this.probability, 2));
        r.append("|");
        int i = 0;
        while (i < this.arguments.length) {
            r.append(Format.formatDouble(this.arguments[i], 2));
            r.append(" ");
            ++i;
        }
        return r.toString();
    }

    public boolean compareArgs(int[] args) {
        if (args.length != this.arguments.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if ((double)Math.abs(this.arguments[i] - args[i]) > 1.0E-13) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }
}

