/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize.generate;

import org.encog.mathutil.randomize.generate.AbstractBoxMuller;

public class LinearCongruentialRandom
extends AbstractBoxMuller {
    public static final long DEFAULT_MOD1 = 2L;
    public static final long DEFAULT_MOD2 = 32L;
    public static final long DEFAULT_MULT = 1103515245L;
    public static final long DEFAULT_INC = 12345L;
    private final long modulus;
    private final long multiplier;
    private final long increment;
    private long seed;
    public static final long MAX_RAND = 0xFFFFFFFFL;

    public LinearCongruentialRandom(long theSeed) {
        this((long)Math.pow(2.0, 32.0), 1103515245L, 12345L, theSeed);
    }

    public LinearCongruentialRandom() {
        this(System.currentTimeMillis());
    }

    public LinearCongruentialRandom(long theModulus, long theMultiplier, long theIncrement, long theSeed) {
        this.modulus = theModulus;
        this.multiplier = theMultiplier;
        this.increment = theIncrement;
        this.seed = theSeed % 0xFFFFFFFFL;
    }

    public final long getIncrement() {
        return this.increment;
    }

    public final long getModulus() {
        return this.modulus;
    }

    public final long getMultiplier() {
        return this.multiplier;
    }

    public final long getSeed() {
        return this.seed;
    }

    @Override
    public final double nextDouble() {
        return (double)this.nextLong() / 4.294967295E9;
    }

    @Override
    public final long nextLong() {
        this.seed = (this.multiplier * this.seed + this.increment) % this.modulus;
        return this.seed;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextDouble() > 0.5;
    }

    @Override
    public float nextFloat() {
        return (float)this.nextDouble();
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }
}

