/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.hessian;

import org.encog.mathutil.EncogMath;
import org.encog.mathutil.error.ErrorCalculation;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.hessian.BasicHessian;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.util.EngineArray;

public class HessianFD
extends BasicHessian {
    public final double INITIAL_STEP = 0.001;
    private double[] dStep;
    private double[] dCoeff;
    private int center;
    private int pointsPerSide = 5;
    private int pointCount;
    private int weightCount;

    @Override
    public void init(BasicNetwork theNetwork, MLDataSet theTraining) {
        super.init(theNetwork, theTraining);
        this.weightCount = theNetwork.getStructure().getFlat().getWeights().length;
        this.center = this.pointsPerSide + 1;
        this.pointCount = this.pointsPerSide * 2 + 1;
        this.dCoeff = this.createCoefficients();
        this.dStep = new double[this.weightCount];
        int i = 0;
        while (i < this.weightCount) {
            this.dStep[i] = 0.001;
            ++i;
        }
    }

    @Override
    public void compute() {
        this.sse = 0.0;
        int i = 0;
        while (i < this.network.getOutputCount()) {
            this.internalCompute(i);
            ++i;
        }
    }

    private void internalCompute(int outputNeuron) {
        int row = 0;
        ErrorCalculation error = new ErrorCalculation();
        double[] derivative = new double[this.weightCount];
        for (MLDataPair pair : this.training) {
            EngineArray.fill(derivative, 0.0);
            MLData networkOutput = this.network.compute(pair.getInput());
            double e = pair.getIdeal().getData(outputNeuron) - networkOutput.getData(outputNeuron);
            error.updateError(networkOutput.getData(outputNeuron), pair.getIdeal().getData(outputNeuron));
            int currentWeight = 0;
            int outputFeedCount = this.network.getLayerTotalNeuronCount(this.network.getLayerCount() - 2);
            int i = 0;
            while (i < this.network.getOutputCount()) {
                int j = 0;
                while (j < outputFeedCount) {
                    double jc = i == outputNeuron ? this.computeDerivative(pair.getInput(), outputNeuron, currentWeight, this.dStep, networkOutput.getData(outputNeuron), row) : 0.0;
                    int n = currentWeight;
                    this.gradients[n] = this.gradients[n] + jc * e;
                    derivative[currentWeight] = jc;
                    ++currentWeight;
                    ++j;
                }
                ++i;
            }
            while (currentWeight < this.network.getFlat().getWeights().length) {
                double jc;
                derivative[currentWeight] = jc = this.computeDerivative(pair.getInput(), outputNeuron, currentWeight, this.dStep, networkOutput.getData(outputNeuron), row);
                int n = currentWeight++;
                this.gradients[n] = this.gradients[n] + jc * e;
            }
            ++row;
            this.updateHessian(derivative);
        }
        this.sse += error.calculateESS();
    }

    private double computeDerivative(MLData inputData, int outputNeuron, int weight, double[] stepSize, double networkOutput, int row) {
        double temp = this.network.getFlat().getWeights()[weight];
        double[] points = new double[this.dCoeff.length];
        stepSize[row] = Math.max(0.001 * Math.abs(temp), 0.001);
        points[this.center] = networkOutput;
        int i = 0;
        while (i < this.dCoeff.length) {
            if (i != this.center) {
                double newWeight;
                this.network.getFlat().getWeights()[weight] = newWeight = temp + (double)(i - this.center) * stepSize[row];
                MLData output = this.network.compute(inputData);
                points[i] = output.getData(outputNeuron);
            }
            ++i;
        }
        double result = 0.0;
        int i2 = 0;
        while (i2 < this.dCoeff.length) {
            result += this.dCoeff[i2] * points[i2];
            ++i2;
        }
        this.network.getFlat().getWeights()[weight] = temp;
        return result /= Math.pow(stepSize[row], 1.0);
    }

    public double[] createCoefficients() {
        double[] result = new double[this.pointCount];
        Matrix delts = new Matrix(this.pointCount, this.pointCount);
        double[][] t = delts.getData();
        int j = 0;
        while (j < this.pointCount) {
            double delt = j - this.center;
            double x = 1.0;
            int k = 0;
            while (k < this.pointCount) {
                t[j][k] = x / EncogMath.factorial(k);
                x *= delt;
                ++k;
            }
            ++j;
        }
        Matrix invMatrix = delts.inverse();
        double f = EncogMath.factorial(this.pointCount);
        int k = 0;
        while (k < this.pointCount) {
            result[k] = (double)Math.round(invMatrix.getData()[1][k] * f) / f;
            ++k;
        }
        return result;
    }

    public int getPointsPerSide() {
        return this.pointsPerSide;
    }

    public void setPointsPerSide(int pointsPerSide) {
        this.pointsPerSide = pointsPerSide;
    }
}

