/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.decomposition;

import java.util.Arrays;
import org.encog.mathutil.EncogMath;
import org.encog.mathutil.matrices.Matrix;

public class EigenvalueDecomposition {
    private final int n;
    private final boolean issymmetric;
    private final double[] d;
    private final double[] e;
    private final double[][] v;
    private double cdivr;
    private double cdivi;
    private double[][] h;
    private double[] ort;

    public EigenvalueDecomposition(Matrix matrix) {
        double[][] a = matrix.getData();
        this.n = matrix.getCols();
        this.v = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = EigenvalueDecomposition.isSymmetric(a);
        if (this.issymmetric) {
            int i = 0;
            while (i < this.n) {
                System.arraycopy(a[i], 0, this.v[i], 0, this.n);
                ++i;
            }
            this.tred2();
            this.tql2();
        } else {
            this.h = new double[this.n][this.n];
            this.ort = new double[this.n];
            int j = 0;
            while (j < this.n) {
                System.arraycopy(a, 0, this.h, 0, this.n);
                ++j;
            }
            this.orthes();
            this.hqr2();
        }
    }

    static boolean isSymmetric(double[][] a) {
        int len = a.length;
        if (len == 0) {
            return true;
        }
        if (a[0].length != len) {
            return false;
        }
        int j = 1;
        while (j < len) {
            if (a[j].length != len) {
                return false;
            }
            int i = 0;
            while (i < j) {
                if (a[i][j] != a[j][i]) {
                    return false;
                }
                ++i;
            }
            ++j;
        }
        return true;
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    public Matrix getD() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] D = X.getData();
        int i = 0;
        while (i < this.n) {
            Arrays.fill(D[i], 0.0);
            D[i][i] = this.d[i];
            if (this.e[i] > 0.0) {
                D[i][i + 1] = this.e[i];
            } else if (this.e[i] < 0.0) {
                D[i][i - 1] = this.e[i];
            }
            ++i;
        }
        return X;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public Matrix getV() {
        return new Matrix(this.v);
    }

    private void hqr2() {
        double y;
        int i;
        double x;
        double w;
        int l;
        int j;
        int nn = this.n;
        int n = nn - 1;
        boolean low = false;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = 0.0;
        int i2 = 0;
        while (i2 < nn) {
            if (i2 < 0 | i2 > high) {
                this.d[i2] = this.h[i2][i2];
                this.e[i2] = 0.0;
            }
            j = Math.max(i2 - 1, 0);
            while (j < nn) {
                norm += Math.abs(this.h[i2][j]);
                ++j;
            }
            ++i2;
        }
        int iter = 0;
        block2: while (n >= 0) {
            l = n;
            while (l > 0) {
                s = Math.abs(this.h[l - 1][l - 1]) + Math.abs(this.h[l][l]);
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(this.h[l][l - 1]) < eps * s) break;
                --l;
            }
            if (l == n) {
                this.h[n][n] = this.h[n][n] + exshift;
                this.d[n] = this.h[n][n];
                this.e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.h[n][n - 1] * this.h[n - 1][n];
                p = (this.h[n - 1][n - 1] - this.h[n][n]) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                this.h[n][n] = this.h[n][n] + exshift;
                this.h[n - 1][n - 1] = this.h[n - 1][n - 1] + exshift;
                x = this.h[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != 0.0) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = 0.0;
                    this.e[n] = 0.0;
                    x = this.h[n][n - 1];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    int j2 = n - 1;
                    while (j2 < nn) {
                        z = this.h[n - 1][j2];
                        this.h[n - 1][j2] = q * z + p * this.h[n][j2];
                        this.h[n][j2] = q * this.h[n][j2] - p * z;
                        ++j2;
                    }
                    i = 0;
                    while (i <= n) {
                        z = this.h[i][n - 1];
                        this.h[i][n - 1] = q * z + p * this.h[i][n];
                        this.h[i][n] = q * this.h[i][n] - p * z;
                        ++i;
                    }
                    i = 0;
                    while (i <= high) {
                        z = this.v[i][n - 1];
                        this.v[i][n - 1] = q * z + p * this.v[i][n];
                        this.v[i][n] = q * this.v[i][n] - p * z;
                        ++i;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.h[n][n];
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = this.h[n - 1][n - 1];
                w = this.h[n][n - 1] * this.h[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i = 0;
                while (i <= n) {
                    double[] dArray = this.h[i];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] - x;
                }
                s = Math.abs(this.h[n][n - 1]) + Math.abs(this.h[n - 1][n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    i = 0;
                    while (i <= n) {
                        double[] dArray = this.h[i];
                        int n3 = i++;
                        dArray[n3] = dArray[n3] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            int m = n - 2;
            while (m >= l) {
                z = this.h[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.h[m + 1][m] + this.h[m][m + 1];
                q = this.h[m + 1][m + 1] - z - r - s;
                r = this.h[m + 2][m + 1];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.h[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.h[m - 1][m - 1]) + Math.abs(z) + Math.abs(this.h[m + 1][m + 1])))) break;
                --m;
            }
            int i3 = m + 2;
            while (i3 <= n) {
                this.h[i3][i3 - 2] = 0.0;
                if (i3 > m + 2) {
                    this.h[i3][i3 - 3] = 0.0;
                }
                ++i3;
            }
            int k = m;
            while (k <= n - 1) {
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.h[k][k - 1];
                    q = this.h[k + 1][k - 1];
                    r = notlast ? this.h[k + 2][k - 1] : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block2;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s != 0.0) {
                    if (k != m) {
                        this.h[k][k - 1] = -s * x;
                    } else if (l != m) {
                        this.h[k][k - 1] = -this.h[k][k - 1];
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    int j3 = k;
                    while (j3 < nn) {
                        p = this.h[k][j3] + q * this.h[k + 1][j3];
                        if (notlast) {
                            this.h[k + 2][j3] = this.h[k + 2][j3] - (p += r * this.h[k + 2][j3]) * z;
                        }
                        this.h[k][j3] = this.h[k][j3] - p * x;
                        this.h[k + 1][j3] = this.h[k + 1][j3] - p * y;
                        ++j3;
                    }
                    int i4 = 0;
                    while (i4 <= Math.min(n, k + 3)) {
                        p = x * this.h[i4][k] + y * this.h[i4][k + 1];
                        if (notlast) {
                            this.h[i4][k + 2] = this.h[i4][k + 2] - (p += z * this.h[i4][k + 2]) * r;
                        }
                        this.h[i4][k] = this.h[i4][k] - p;
                        this.h[i4][k + 1] = this.h[i4][k + 1] - p * q;
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 <= high) {
                        p = x * this.v[i4][k] + y * this.v[i4][k + 1];
                        if (notlast) {
                            this.v[i4][k + 2] = this.v[i4][k + 2] - (p += z * this.v[i4][k + 2]) * r;
                        }
                        this.v[i4][k] = this.v[i4][k] - p;
                        this.v[i4][k + 1] = this.v[i4][k + 1] - p * q;
                        ++i4;
                    }
                }
                ++k;
            }
        }
        if (norm == 0.0) {
            return;
        }
        n = nn - 1;
        while (n >= 0) {
            double t;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0) {
                l = n;
                this.h[n][n] = 1.0;
                i = n - 1;
                while (i >= 0) {
                    w = this.h[i][i] - p;
                    r = 0.0;
                    int j4 = l;
                    while (j4 <= n) {
                        r += this.h[i][j4] * this.h[j4][n];
                        ++j4;
                    }
                    if (this.e[i] < 0.0) {
                        z = w;
                        s = r;
                    } else {
                        l = i;
                        if (this.e[i] == 0.0) {
                            this.h[i][n] = w != 0.0 ? -r / w : -r / (eps * norm);
                        } else {
                            x = this.h[i][i + 1];
                            y = this.h[i + 1][i];
                            q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                            this.h[i][n] = t = (x * s - z * r) / q;
                            this.h[i + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                        }
                        t = Math.abs(this.h[i][n]);
                        if (eps * t * t > 1.0) {
                            j4 = i;
                            while (j4 <= n) {
                                this.h[j4][n] = this.h[j4][n] / t;
                                ++j4;
                            }
                        }
                    }
                    --i;
                }
            } else if (q < 0.0) {
                l = n - 1;
                if (Math.abs(this.h[n][n - 1]) > Math.abs(this.h[n - 1][n])) {
                    this.h[n - 1][n - 1] = q / this.h[n][n - 1];
                    this.h[n - 1][n] = -(this.h[n][n] - p) / this.h[n][n - 1];
                } else {
                    this.cdiv(0.0, -this.h[n - 1][n], this.h[n - 1][n - 1] - p, q);
                    this.h[n - 1][n - 1] = this.cdivr;
                    this.h[n - 1][n] = this.cdivi;
                }
                this.h[n][n - 1] = 0.0;
                this.h[n][n] = 1.0;
                i = n - 2;
                while (i >= 0) {
                    double ra = 0.0;
                    double sa = 0.0;
                    int j5 = l;
                    while (j5 <= n) {
                        ra += this.h[i][j5] * this.h[j5][n - 1];
                        sa += this.h[i][j5] * this.h[j5][n];
                        ++j5;
                    }
                    w = this.h[i][i] - p;
                    if (this.e[i] < 0.0) {
                        z = w;
                        r = ra;
                        s = sa;
                    } else {
                        l = i;
                        if (this.e[i] == 0.0) {
                            this.cdiv(-ra, -sa, w, q);
                            this.h[i][n - 1] = this.cdivr;
                            this.h[i][n] = this.cdivi;
                        } else {
                            double vi;
                            x = this.h[i][i + 1];
                            y = this.h[i + 1][i];
                            double vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
                            if (vr == 0.0 & (vi = (this.d[i] - p) * 2.0 * q) == 0.0) {
                                vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                            }
                            this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                            this.h[i][n - 1] = this.cdivr;
                            this.h[i][n] = this.cdivi;
                            if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                                this.h[i + 1][n - 1] = (-ra - w * this.h[i][n - 1] + q * this.h[i][n]) / x;
                                this.h[i + 1][n] = (-sa - w * this.h[i][n] - q * this.h[i][n - 1]) / x;
                            } else {
                                this.cdiv(-r - y * this.h[i][n - 1], -s - y * this.h[i][n], z, q);
                                this.h[i + 1][n - 1] = this.cdivr;
                                this.h[i + 1][n] = this.cdivi;
                            }
                        }
                        t = Math.max(Math.abs(this.h[i][n - 1]), Math.abs(this.h[i][n]));
                        if (eps * t * t > 1.0) {
                            j5 = i;
                            while (j5 <= n) {
                                this.h[j5][n - 1] = this.h[j5][n - 1] / t;
                                this.h[j5][n] = this.h[j5][n] / t;
                                ++j5;
                            }
                        }
                    }
                    --i;
                }
            }
            --n;
        }
        int i5 = 0;
        while (i5 < nn) {
            if (i5 < 0 | i5 > high) {
                System.arraycopy(this.h, i5, this.v, i5, nn - i5);
            }
            ++i5;
        }
        j = nn - 1;
        while (j >= 0) {
            i = 0;
            while (i <= high) {
                z = 0.0;
                int k = 0;
                while (k <= Math.min(j, high)) {
                    z += this.v[i][k] * this.h[k][j];
                    ++k;
                }
                this.v[i][j] = z;
                ++i;
            }
            --j;
        }
    }

    private void orthes() {
        boolean low = false;
        int high = this.n - 1;
        int m = 1;
        while (m <= high - 1) {
            double scale = 0.0;
            int i = m;
            while (i <= high) {
                scale += Math.abs(this.h[i][m - 1]);
                ++i;
            }
            if (scale != 0.0) {
                double f;
                double lh = 0.0;
                int i2 = high;
                while (i2 >= m) {
                    this.ort[i2] = this.h[i2][m - 1] / scale;
                    lh += this.ort[i2] * this.ort[i2];
                    --i2;
                }
                double g = Math.sqrt(lh);
                if (this.ort[m] > 0.0) {
                    g = -g;
                }
                lh -= this.ort[m] * g;
                this.ort[m] = this.ort[m] - g;
                int j = m;
                while (j < this.n) {
                    f = 0.0;
                    int i3 = high;
                    while (i3 >= m) {
                        f += this.ort[i3] * this.h[i3][j];
                        --i3;
                    }
                    f /= lh;
                    i3 = m;
                    while (i3 <= high) {
                        double[] dArray = this.h[i3];
                        int n = j;
                        dArray[n] = dArray[n] - f * this.ort[i3];
                        ++i3;
                    }
                    ++j;
                }
                int i4 = 0;
                while (i4 <= high) {
                    f = 0.0;
                    int j2 = high;
                    while (j2 >= m) {
                        f += this.ort[j2] * this.h[i4][j2];
                        --j2;
                    }
                    f /= lh;
                    j2 = m;
                    while (j2 <= high) {
                        double[] dArray = this.h[i4];
                        int n = j2;
                        dArray[n] = dArray[n] - f * this.ort[j2];
                        ++j2;
                    }
                    ++i4;
                }
                this.ort[m] = scale * this.ort[m];
                this.h[m][m - 1] = scale * g;
            }
            ++m;
        }
        int i = 0;
        while (i < this.n) {
            Arrays.fill(this.v[i], 0.0);
            this.v[i][i] = 1.0;
            ++i;
        }
        m = high - 1;
        while (m >= 1) {
            if (this.h[m][m - 1] != 0.0) {
                int i5 = m + 1;
                while (i5 <= high) {
                    this.ort[i5] = this.h[i5][m - 1];
                    ++i5;
                }
                int j = m;
                while (j <= high) {
                    double g = 0.0;
                    int i6 = m;
                    while (i6 <= high) {
                        g += this.ort[i6] * this.v[i6][j];
                        ++i6;
                    }
                    g = g / this.ort[m] / this.h[m][m - 1];
                    i6 = m;
                    while (i6 <= high) {
                        double[] dArray = this.v[i6];
                        int n = j;
                        dArray[n] = dArray[n] + g * this.ort[i6];
                        ++i6;
                    }
                    ++j;
                }
            }
            --m;
        }
    }

    private void tql2() {
        int i = 1;
        while (i < this.n) {
            this.e[i - 1] = this.e[i];
            ++i;
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        int l = 0;
        while (l < this.n) {
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            int m = l;
            while (m < this.n) {
                if (Math.abs(this.e[m]) <= eps * tst1) break;
                ++m;
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = EncogMath.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i2 = l + 2;
                    while (i2 < this.n) {
                        int n = i2++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    int i3 = m - 1;
                    while (i3 >= l) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i3];
                        h = c * p;
                        r = EncogMath.hypot(p, this.e[i3]);
                        this.e[i3 + 1] = s * r;
                        s = this.e[i3] / r;
                        c = p / r;
                        p = c * this.d[i3] - s * g;
                        this.d[i3 + 1] = h + s * (c * g + s * this.d[i3]);
                        int k = 0;
                        while (k < this.n) {
                            h = this.v[k][i3 + 1];
                            this.v[k][i3 + 1] = s * this.v[k][i3] + c * h;
                            this.v[k][i3] = c * this.v[k][i3] - s * h;
                            ++k;
                        }
                        --i3;
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0;
            ++l;
        }
        int i4 = 0;
        while (i4 < this.n - 1) {
            int k = i4;
            double p = this.d[i4];
            int j = i4 + 1;
            while (j < this.n) {
                if (this.d[j] < p) {
                    k = j;
                    p = this.d[j];
                }
                ++j;
            }
            if (k != i4) {
                this.d[k] = this.d[i4];
                this.d[i4] = p;
                j = 0;
                while (j < this.n) {
                    p = this.v[j][i4];
                    this.v[j][i4] = this.v[j][k];
                    this.v[j][k] = p;
                    ++j;
                }
            }
            ++i4;
        }
    }

    private void tred2() {
        System.arraycopy(this.v[this.n - 1], 0, this.d, 0, this.n);
        int i = this.n - 1;
        while (i > 0) {
            double scale = 0.0;
            double h = 0.0;
            int k = 0;
            while (k < i) {
                scale += Math.abs(this.d[k]);
                ++k;
            }
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                int j = 0;
                while (j < i) {
                    this.d[j] = this.v[i - 1][j];
                    this.v[i][j] = 0.0;
                    this.v[j][i] = 0.0;
                    ++j;
                }
            } else {
                k = 0;
                while (k < i) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                    ++k;
                }
                double f = this.d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                Arrays.fill(this.e, 0, i, 0.0);
                int j = 0;
                while (j < i) {
                    this.v[j][i] = f = this.d[j];
                    g = this.e[j] + this.v[j][j] * f;
                    int k2 = j + 1;
                    while (k2 <= i - 1) {
                        g += this.v[k2][j] * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.v[k2][j] * f;
                        ++k2;
                    }
                    this.e[j] = g;
                    ++j;
                }
                f = 0.0;
                j = 0;
                while (j < i) {
                    int n = j;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j] * this.d[j];
                    ++j;
                }
                double hh = f / (h + h);
                int j2 = 0;
                while (j2 < i) {
                    int n = j2;
                    this.e[n] = this.e[n] - hh * this.d[j2];
                    ++j2;
                }
                j2 = 0;
                while (j2 < i) {
                    f = this.d[j2];
                    g = this.e[j2];
                    int k3 = j2;
                    while (k3 <= i - 1) {
                        double[] dArray = this.v[k3];
                        int n = j2;
                        dArray[n] = dArray[n] - (f * this.e[k3] + g * this.d[k3]);
                        ++k3;
                    }
                    this.d[j2] = this.v[i - 1][j2];
                    this.v[i][j2] = 0.0;
                    ++j2;
                }
            }
            this.d[i] = h;
            --i;
        }
        i = 0;
        while (i < this.n - 1) {
            this.v[this.n - 1][i] = this.v[i][i];
            this.v[i][i] = 1.0;
            double h = this.d[i + 1];
            if (h != 0.0) {
                int k = 0;
                while (k <= i) {
                    this.d[k] = this.v[k][i + 1] / h;
                    ++k;
                }
                int j = 0;
                while (j <= i) {
                    double g = 0.0;
                    int k4 = 0;
                    while (k4 <= i) {
                        g += this.v[k4][i + 1] * this.v[k4][j];
                        ++k4;
                    }
                    k4 = 0;
                    while (k4 <= i) {
                        double[] dArray = this.v[k4];
                        int n = j;
                        dArray[n] = dArray[n] - g * this.d[k4];
                        ++k4;
                    }
                    ++j;
                }
            }
            int k = 0;
            while (k <= i) {
                this.v[k][i + 1] = 0.0;
                ++k;
            }
            ++i;
        }
        System.arraycopy(this.v[this.n - 1], 0, this.d, 0, this.n);
        Arrays.fill(this.v[this.n - 1], 0.0);
        this.v[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }
}

