/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

public final class BiPolarUtil {
    public static double bipolar2double(boolean b) {
        if (b) {
            return 1.0;
        }
        return -1.0;
    }

    public static double[] bipolar2double(boolean[] b) {
        double[] result = new double[b.length];
        int i = 0;
        while (i < b.length) {
            result[i] = BiPolarUtil.bipolar2double(b[i]);
            ++i;
        }
        return result;
    }

    public static double[][] bipolar2double(boolean[][] b) {
        double[][] result = new double[b.length][b[0].length];
        int row = 0;
        while (row < b.length) {
            int col = 0;
            while (col < b[0].length) {
                result[row][col] = BiPolarUtil.bipolar2double(b[row][col]);
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static boolean double2bipolar(double d) {
        return d > 0.0;
    }

    public static boolean[] double2bipolar(double[] d) {
        boolean[] result = new boolean[d.length];
        int i = 0;
        while (i < d.length) {
            result[i] = BiPolarUtil.double2bipolar(d[i]);
            ++i;
        }
        return result;
    }

    public static boolean[][] double2bipolar(double[][] d) {
        boolean[][] result = new boolean[d.length][d[0].length];
        int row = 0;
        while (row < d.length) {
            int col = 0;
            while (col < d[0].length) {
                result[row][col] = BiPolarUtil.double2bipolar(d[row][col]);
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static double normalizeBinary(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double toBinary(double d) {
        return (d + 1.0) / 2.0;
    }

    public static double toBiPolar(double d) {
        return 2.0 * BiPolarUtil.normalizeBinary(d) - 1.0;
    }

    public static double toNormalizedBinary(double d) {
        return BiPolarUtil.normalizeBinary(BiPolarUtil.toBinary(d));
    }

    private BiPolarUtil() {
    }
}

