/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.libsvm;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import org.encog.mathutil.libsvm.Kernel;
import org.encog.mathutil.libsvm.ONE_CLASS_Q;
import org.encog.mathutil.libsvm.SVC_Q;
import org.encog.mathutil.libsvm.SVR_Q;
import org.encog.mathutil.libsvm.Solver;
import org.encog.mathutil.libsvm.Solver_NU;
import org.encog.mathutil.libsvm.svm_model;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_parameter;
import org.encog.mathutil.libsvm.svm_print_interface;
import org.encog.mathutil.libsvm.svm_problem;
import org.encog.util.arrayutil.Array;
import org.encog.util.csv.CSVFormat;

public class svm {
    public static final int LIBSVM_VERSION = 311;
    public static final Random rand = new Random();
    private static svm_print_interface svm_print_stdout;
    private static svm_print_interface svm_print_string;
    static final String[] svm_type_table;
    static final String[] kernel_type_table;

    static {
        svm_print_string = svm_print_stdout = new svm_print_interface(){

            @Override
            public void print(String s) {
            }
        };
        svm_type_table = new String[]{"c_svc", "nu_svc", "one_class", "epsilon_svr", "nu_svr"};
        kernel_type_table = new String[]{"linear", "polynomial", "rbf", "sigmoid", "precomputed"};
    }

    static void info(String s) {
        svm_print_string.print(s);
    }

    private static void solve_c_svc(svm_problem prob, svm_parameter param, double[] alpha, Solver.SolutionInfo si, double Cp, double Cn) {
        int l = prob.l;
        double[] minus_ones = new double[l];
        byte[] y = new byte[l];
        int i = 0;
        while (i < l) {
            alpha[i] = 0.0;
            minus_ones[i] = -1.0;
            y[i] = prob.y[i] > 0.0 ? 1 : -1;
            ++i;
        }
        Solver s = new Solver();
        s.Solve(l, new SVC_Q(prob, param, y), minus_ones, y, alpha, Cp, Cn, param.eps, si, param.shrinking);
        double sum_alpha = 0.0;
        i = 0;
        while (i < l) {
            sum_alpha += alpha[i];
            ++i;
        }
        if (Cp == Cn) {
            svm.info("nu = " + sum_alpha / (Cp * (double)prob.l) + "\n");
        }
        i = 0;
        while (i < l) {
            int n = i;
            alpha[n] = alpha[n] * (double)y[i];
            ++i;
        }
    }

    private static void solve_nu_svc(svm_problem prob, svm_parameter param, double[] alpha, Solver.SolutionInfo si) {
        int l = prob.l;
        double nu = param.nu;
        byte[] y = new byte[l];
        int i = 0;
        while (i < l) {
            y[i] = prob.y[i] > 0.0 ? 1 : -1;
            ++i;
        }
        double sum_pos = nu * (double)l / 2.0;
        double sum_neg = nu * (double)l / 2.0;
        i = 0;
        while (i < l) {
            if (y[i] == 1) {
                alpha[i] = Math.min(1.0, sum_pos);
                sum_pos -= alpha[i];
            } else {
                alpha[i] = Math.min(1.0, sum_neg);
                sum_neg -= alpha[i];
            }
            ++i;
        }
        double[] zeros = new double[l];
        i = 0;
        while (i < l) {
            zeros[i] = 0.0;
            ++i;
        }
        Solver_NU s = new Solver_NU();
        s.Solve(l, new SVC_Q(prob, param, y), zeros, y, alpha, 1.0, 1.0, param.eps, si, param.shrinking);
        double r = si.r;
        svm.info("C = " + 1.0 / r + "\n");
        i = 0;
        while (i < l) {
            int n = i;
            alpha[n] = alpha[n] * ((double)y[i] / r);
            ++i;
        }
        si.rho /= r;
        si.obj /= r * r;
        si.upper_bound_p = 1.0 / r;
        si.upper_bound_n = 1.0 / r;
    }

    private static void solve_one_class(svm_problem prob, svm_parameter param, double[] alpha, Solver.SolutionInfo si) {
        int l = prob.l;
        double[] zeros = new double[l];
        byte[] ones = new byte[l];
        int n = (int)(param.nu * (double)prob.l);
        int i = 0;
        while (i < n) {
            alpha[i] = 1.0;
            ++i;
        }
        if (n < prob.l) {
            alpha[n] = param.nu * (double)prob.l - (double)n;
        }
        i = n + 1;
        while (i < l) {
            alpha[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < l) {
            zeros[i] = 0.0;
            ones[i] = 1;
            ++i;
        }
        Solver s = new Solver();
        s.Solve(l, new ONE_CLASS_Q(prob, param), zeros, ones, alpha, 1.0, 1.0, param.eps, si, param.shrinking);
    }

    private static void solve_epsilon_svr(svm_problem prob, svm_parameter param, double[] alpha, Solver.SolutionInfo si) {
        int l = prob.l;
        double[] alpha2 = new double[2 * l];
        double[] linear_term = new double[2 * l];
        byte[] y = new byte[2 * l];
        int i = 0;
        while (i < l) {
            alpha2[i] = 0.0;
            linear_term[i] = param.p - prob.y[i];
            y[i] = 1;
            alpha2[i + l] = 0.0;
            linear_term[i + l] = param.p + prob.y[i];
            y[i + l] = -1;
            ++i;
        }
        Solver s = new Solver();
        s.Solve(2 * l, new SVR_Q(prob, param), linear_term, y, alpha2, param.C, param.C, param.eps, si, param.shrinking);
        double sum_alpha = 0.0;
        i = 0;
        while (i < l) {
            alpha[i] = alpha2[i] - alpha2[i + l];
            sum_alpha += Math.abs(alpha[i]);
            ++i;
        }
        svm.info("nu = " + sum_alpha / (param.C * (double)l) + "\n");
    }

    private static void solve_nu_svr(svm_problem prob, svm_parameter param, double[] alpha, Solver.SolutionInfo si) {
        int l = prob.l;
        double C = param.C;
        double[] alpha2 = new double[2 * l];
        double[] linear_term = new double[2 * l];
        byte[] y = new byte[2 * l];
        double sum = C * param.nu * (double)l / 2.0;
        int i = 0;
        while (i < l) {
            double d = Math.min(sum, C);
            alpha2[i + l] = d;
            alpha2[i] = d;
            sum -= alpha2[i];
            linear_term[i] = -prob.y[i];
            y[i] = 1;
            linear_term[i + l] = prob.y[i];
            y[i + l] = -1;
            ++i;
        }
        Solver_NU s = new Solver_NU();
        s.Solve(2 * l, new SVR_Q(prob, param), linear_term, y, alpha2, C, C, param.eps, si, param.shrinking);
        svm.info("epsilon = " + -si.r + "\n");
        i = 0;
        while (i < l) {
            alpha[i] = alpha2[i] - alpha2[i + l];
            ++i;
        }
    }

    static decision_function svm_train_one(svm_problem prob, svm_parameter param, double Cp, double Cn) {
        double[] alpha = new double[prob.l];
        Solver.SolutionInfo si = new Solver.SolutionInfo();
        switch (param.svm_type) {
            case 0: {
                svm.solve_c_svc(prob, param, alpha, si, Cp, Cn);
                break;
            }
            case 1: {
                svm.solve_nu_svc(prob, param, alpha, si);
                break;
            }
            case 2: {
                svm.solve_one_class(prob, param, alpha, si);
                break;
            }
            case 3: {
                svm.solve_epsilon_svr(prob, param, alpha, si);
                break;
            }
            case 4: {
                svm.solve_nu_svr(prob, param, alpha, si);
            }
        }
        svm.info("obj = " + si.obj + ", rho = " + si.rho + "\n");
        int nSV = 0;
        int nBSV = 0;
        int i = 0;
        while (i < prob.l) {
            if (Math.abs(alpha[i]) > 0.0) {
                ++nSV;
                if (prob.y[i] > 0.0) {
                    if (Math.abs(alpha[i]) >= si.upper_bound_p) {
                        ++nBSV;
                    }
                } else if (Math.abs(alpha[i]) >= si.upper_bound_n) {
                    ++nBSV;
                }
            }
            ++i;
        }
        svm.info("nSV = " + nSV + ", nBSV = " + nBSV + "\n");
        decision_function f = new decision_function();
        f.alpha = alpha;
        f.rho = si.rho;
        return f;
    }

    private static void sigmoid_train(int l, double[] dec_values, double[] labels, double[] probAB) {
        double fApB;
        double prior1 = 0.0;
        double prior0 = 0.0;
        int i = 0;
        while (i < l) {
            if (labels[i] > 0.0) {
                prior1 += 1.0;
            } else {
                prior0 += 1.0;
            }
            ++i;
        }
        int max_iter = 100;
        double min_step = 1.0E-10;
        double sigma = 1.0E-12;
        double eps = 1.0E-5;
        double hiTarget = (prior1 + 1.0) / (prior1 + 2.0);
        double loTarget = 1.0 / (prior0 + 2.0);
        double[] t = new double[l];
        double A = 0.0;
        double B = Math.log((prior0 + 1.0) / (prior1 + 1.0));
        double fval = 0.0;
        i = 0;
        while (i < l) {
            t[i] = labels[i] > 0.0 ? hiTarget : loTarget;
            fApB = dec_values[i] * A + B;
            fval = fApB >= 0.0 ? (fval += t[i] * fApB + Math.log(1.0 + Math.exp(-fApB))) : (fval += (t[i] - 1.0) * fApB + Math.log(1.0 + Math.exp(fApB)));
            ++i;
        }
        int iter = 0;
        while (iter < max_iter) {
            double h11 = sigma;
            double h22 = sigma;
            double h21 = 0.0;
            double g1 = 0.0;
            double g2 = 0.0;
            i = 0;
            while (i < l) {
                double q;
                double p;
                fApB = dec_values[i] * A + B;
                if (fApB >= 0.0) {
                    p = Math.exp(-fApB) / (1.0 + Math.exp(-fApB));
                    q = 1.0 / (1.0 + Math.exp(-fApB));
                } else {
                    p = 1.0 / (1.0 + Math.exp(fApB));
                    q = Math.exp(fApB) / (1.0 + Math.exp(fApB));
                }
                double d2 = p * q;
                h11 += dec_values[i] * dec_values[i] * d2;
                h22 += d2;
                h21 += dec_values[i] * d2;
                double d1 = t[i] - p;
                g1 += dec_values[i] * d1;
                g2 += d1;
                ++i;
            }
            if (Math.abs(g1) < eps && Math.abs(g2) < eps) break;
            double det = h11 * h22 - h21 * h21;
            double dA = -(h22 * g1 - h21 * g2) / det;
            double dB = -(-h21 * g1 + h11 * g2) / det;
            double gd = g1 * dA + g2 * dB;
            double stepsize = 1.0;
            while (stepsize >= min_step) {
                double newA = A + stepsize * dA;
                double newB = B + stepsize * dB;
                double newf = 0.0;
                i = 0;
                while (i < l) {
                    fApB = dec_values[i] * newA + newB;
                    newf = fApB >= 0.0 ? (newf += t[i] * fApB + Math.log(1.0 + Math.exp(-fApB))) : (newf += (t[i] - 1.0) * fApB + Math.log(1.0 + Math.exp(fApB)));
                    ++i;
                }
                if (newf < fval + 1.0E-4 * stepsize * gd) {
                    A = newA;
                    B = newB;
                    fval = newf;
                    break;
                }
                stepsize /= 2.0;
            }
            if (stepsize < min_step) {
                svm.info("Line search fails in two-class probability estimates\n");
                break;
            }
            ++iter;
        }
        if (iter >= max_iter) {
            svm.info("Reaching maximal iterations in two-class probability estimates\n");
        }
        probAB[0] = A;
        probAB[1] = B;
    }

    private static double sigmoid_predict(double decision_value, double A, double B) {
        double fApB = decision_value * A + B;
        if (fApB >= 0.0) {
            return Math.exp(-fApB) / (1.0 + Math.exp(-fApB));
        }
        return 1.0 / (1.0 + Math.exp(fApB));
    }

    private static void multiclass_probability(int k, double[][] r, double[] p) {
        int j;
        int iter = 0;
        int max_iter = Math.max(100, k);
        double[][] Q = new double[k][k];
        double[] Qp = new double[k];
        double eps = 0.005 / (double)k;
        int t = 0;
        while (t < k) {
            p[t] = 1.0 / (double)k;
            Q[t][t] = 0.0;
            j = 0;
            while (j < t) {
                double[] dArray = Q[t];
                int n = t;
                dArray[n] = dArray[n] + r[j][t] * r[j][t];
                Q[t][j] = Q[j][t];
                ++j;
            }
            j = t + 1;
            while (j < k) {
                double[] dArray = Q[t];
                int n = t;
                dArray[n] = dArray[n] + r[j][t] * r[j][t];
                Q[t][j] = -r[j][t] * r[t][j];
                ++j;
            }
            ++t;
        }
        iter = 0;
        while (iter < max_iter) {
            double pQp = 0.0;
            t = 0;
            while (t < k) {
                Qp[t] = 0.0;
                j = 0;
                while (j < k) {
                    int n = t;
                    Qp[n] = Qp[n] + Q[t][j] * p[j];
                    ++j;
                }
                pQp += p[t] * Qp[t];
                ++t;
            }
            double max_error = 0.0;
            t = 0;
            while (t < k) {
                double error = Math.abs(Qp[t] - pQp);
                if (error > max_error) {
                    max_error = error;
                }
                ++t;
            }
            if (max_error < eps) break;
            t = 0;
            while (t < k) {
                double diff = (-Qp[t] + pQp) / Q[t][t];
                int n = t;
                p[n] = p[n] + diff;
                pQp = (pQp + diff * (diff * Q[t][t] + 2.0 * Qp[t])) / (1.0 + diff) / (1.0 + diff);
                j = 0;
                while (j < k) {
                    Qp[j] = (Qp[j] + diff * Q[t][j]) / (1.0 + diff);
                    int n2 = j++;
                    p[n2] = p[n2] / (1.0 + diff);
                }
                ++t;
            }
            ++iter;
        }
        if (iter >= max_iter) {
            svm.info("Exceeds max_iter in multiclass_prob\n");
        }
    }

    private static void svm_binary_svc_probability(svm_problem prob, svm_parameter param, double Cp, double Cn, double[] probAB) {
        int nr_fold = 5;
        int[] perm = new int[prob.l];
        double[] dec_values = new double[prob.l];
        int i = 0;
        while (i < prob.l) {
            perm[i] = i;
            ++i;
        }
        i = 0;
        while (i < prob.l) {
            int j = i + rand.nextInt(prob.l - i);
            Array.swap(perm, i, j);
            ++i;
        }
        i = 0;
        while (i < nr_fold) {
            int begin = i * prob.l / nr_fold;
            int end = (i + 1) * prob.l / nr_fold;
            svm_problem subprob = new svm_problem();
            subprob.l = prob.l - (end - begin);
            subprob.x = new svm_node[subprob.l][];
            subprob.y = new double[subprob.l];
            int k = 0;
            int j = 0;
            while (j < begin) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
                ++j;
            }
            j = end;
            while (j < prob.l) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
                ++j;
            }
            int p_count = 0;
            int n_count = 0;
            j = 0;
            while (j < k) {
                if (subprob.y[j] > 0.0) {
                    ++p_count;
                } else {
                    ++n_count;
                }
                ++j;
            }
            if (p_count == 0 && n_count == 0) {
                j = begin;
                while (j < end) {
                    dec_values[perm[j]] = 0.0;
                    ++j;
                }
            } else if (p_count > 0 && n_count == 0) {
                j = begin;
                while (j < end) {
                    dec_values[perm[j]] = 1.0;
                    ++j;
                }
            } else if (p_count == 0 && n_count > 0) {
                j = begin;
                while (j < end) {
                    dec_values[perm[j]] = -1.0;
                    ++j;
                }
            } else {
                svm_parameter subparam = (svm_parameter)param.clone();
                subparam.probability = 0;
                subparam.C = 1.0;
                subparam.nr_weight = 2;
                subparam.weight_label = new int[2];
                subparam.weight = new double[2];
                subparam.weight_label[0] = 1;
                subparam.weight_label[1] = -1;
                subparam.weight[0] = Cp;
                subparam.weight[1] = Cn;
                svm_model submodel = svm.svm_train(subprob, subparam);
                j = begin;
                while (j < end) {
                    double[] dec_value = new double[1];
                    svm.svm_predict_values(submodel, prob.x[perm[j]], dec_value);
                    dec_values[perm[j]] = dec_value[0];
                    int n = perm[j];
                    dec_values[n] = dec_values[n] * (double)submodel.label[0];
                    ++j;
                }
            }
            ++i;
        }
        svm.sigmoid_train(prob.l, dec_values, prob.y, probAB);
    }

    private static double svm_svr_probability(svm_problem prob, svm_parameter param) {
        int nr_fold = 5;
        double[] ymv = new double[prob.l];
        double mae = 0.0;
        svm_parameter newparam = (svm_parameter)param.clone();
        newparam.probability = 0;
        svm.svm_cross_validation(prob, newparam, nr_fold, ymv);
        int i = 0;
        while (i < prob.l) {
            ymv[i] = prob.y[i] - ymv[i];
            mae += Math.abs(ymv[i]);
            ++i;
        }
        double std = Math.sqrt(2.0 * (mae /= (double)prob.l) * mae);
        int count = 0;
        mae = 0.0;
        i = 0;
        while (i < prob.l) {
            if (Math.abs(ymv[i]) > 5.0 * std) {
                ++count;
            } else {
                mae += Math.abs(ymv[i]);
            }
            ++i;
        }
        svm.info("Prob. model for test data: target value = predicted value + z,\nz: Laplace distribution e^(-|z|/sigma)/(2sigma),sigma=" + (mae /= (double)(prob.l - count)) + "\n");
        return mae;
    }

    private static void svm_group_classes(svm_problem prob, int[] nr_class_ret, int[][] label_ret, int[][] start_ret, int[][] count_ret, int[] perm) {
        int l = prob.l;
        int max_nr_class = 16;
        int nr_class = 0;
        int[] label = new int[max_nr_class];
        int[] count = new int[max_nr_class];
        int[] data_label = new int[l];
        int i = 0;
        while (i < l) {
            int this_label = (int)prob.y[i];
            int j = 0;
            while (j < nr_class) {
                if (this_label == label[j]) {
                    int n = j;
                    count[n] = count[n] + 1;
                    break;
                }
                ++j;
            }
            data_label[i] = j;
            if (j == nr_class) {
                if (nr_class == max_nr_class) {
                    int[] new_data = new int[max_nr_class *= 2];
                    System.arraycopy(label, 0, new_data, 0, label.length);
                    label = new_data;
                    new_data = new int[max_nr_class];
                    System.arraycopy(count, 0, new_data, 0, count.length);
                    count = new_data;
                }
                label[nr_class] = this_label;
                count[nr_class] = 1;
                ++nr_class;
            }
            ++i;
        }
        int[] start = new int[nr_class];
        start[0] = 0;
        i = 1;
        while (i < nr_class) {
            start[i] = start[i - 1] + count[i - 1];
            ++i;
        }
        i = 0;
        while (i < l) {
            perm[start[data_label[i]]] = i;
            int n = data_label[i];
            start[n] = start[n] + 1;
            ++i;
        }
        start[0] = 0;
        i = 1;
        while (i < nr_class) {
            start[i] = start[i - 1] + count[i - 1];
            ++i;
        }
        nr_class_ret[0] = nr_class;
        label_ret[0] = label;
        start_ret[0] = start;
        count_ret[0] = count;
    }

    public static svm_model svm_train(svm_problem prob, svm_parameter param) {
        svm_model model = new svm_model();
        model.param = param;
        if (param.svm_type == 2 || param.svm_type == 3 || param.svm_type == 4) {
            model.nr_class = 2;
            model.label = null;
            model.nSV = null;
            model.probA = null;
            model.probB = null;
            model.sv_coef = new double[1][];
            if (param.probability == 1 && (param.svm_type == 3 || param.svm_type == 4)) {
                model.probA = new double[1];
                model.probA[0] = svm.svm_svr_probability(prob, param);
            }
            decision_function f = svm.svm_train_one(prob, param, 0.0, 0.0);
            model.rho = new double[1];
            model.rho[0] = f.rho;
            int nSV = 0;
            int i = 0;
            while (i < prob.l) {
                if (Math.abs(f.alpha[i]) > 0.0) {
                    ++nSV;
                }
                ++i;
            }
            model.l = nSV;
            model.SV = new svm_node[nSV][];
            model.sv_coef[0] = new double[nSV];
            int j = 0;
            i = 0;
            while (i < prob.l) {
                if (Math.abs(f.alpha[i]) > 0.0) {
                    model.SV[j] = prob.x[i];
                    model.sv_coef[0][j] = f.alpha[i];
                    ++j;
                }
                ++i;
            }
        } else {
            int j;
            int l = prob.l;
            int[] tmp_nr_class = new int[1];
            int[][] tmp_label = new int[1][];
            int[][] tmp_start = new int[1][];
            int[][] tmp_count = new int[1][];
            int[] perm = new int[l];
            svm.svm_group_classes(prob, tmp_nr_class, tmp_label, tmp_start, tmp_count, perm);
            int nr_class = tmp_nr_class[0];
            int[] label = tmp_label[0];
            int[] start = tmp_start[0];
            int[] count = tmp_count[0];
            if (nr_class == 1) {
                svm.info("WARNING: training data in only one class. See README for details.\n");
            }
            svm_node[][] x = new svm_node[l][];
            int i = 0;
            while (i < l) {
                x[i] = prob.x[perm[i]];
                ++i;
            }
            double[] weighted_C = new double[nr_class];
            i = 0;
            while (i < nr_class) {
                weighted_C[i] = param.C;
                ++i;
            }
            i = 0;
            while (i < param.nr_weight) {
                int j2 = 0;
                while (j2 < nr_class) {
                    if (param.weight_label[i] == label[j2]) break;
                    ++j2;
                }
                if (j2 == nr_class) {
                    System.err.print("WARNING: class label " + param.weight_label[i] + " specified in weight is not found\n");
                } else {
                    int n = j2;
                    weighted_C[n] = weighted_C[n] * param.weight[i];
                }
                ++i;
            }
            boolean[] nonzero = new boolean[l];
            i = 0;
            while (i < l) {
                nonzero[i] = false;
                ++i;
            }
            decision_function[] f = new decision_function[nr_class * (nr_class - 1) / 2];
            double[] probA = null;
            double[] probB = null;
            if (param.probability == 1) {
                probA = new double[nr_class * (nr_class - 1) / 2];
                probB = new double[nr_class * (nr_class - 1) / 2];
            }
            int p = 0;
            i = 0;
            while (i < nr_class) {
                int j3 = i + 1;
                while (j3 < nr_class) {
                    svm_problem sub_prob = new svm_problem();
                    int si = start[i];
                    int sj = start[j3];
                    int ci = count[i];
                    int cj = count[j3];
                    sub_prob.l = ci + cj;
                    sub_prob.x = new svm_node[sub_prob.l][];
                    sub_prob.y = new double[sub_prob.l];
                    int k = 0;
                    while (k < ci) {
                        sub_prob.x[k] = x[si + k];
                        sub_prob.y[k] = 1.0;
                        ++k;
                    }
                    k = 0;
                    while (k < cj) {
                        sub_prob.x[ci + k] = x[sj + k];
                        sub_prob.y[ci + k] = -1.0;
                        ++k;
                    }
                    if (param.probability == 1) {
                        double[] probAB = new double[2];
                        svm.svm_binary_svc_probability(sub_prob, param, weighted_C[i], weighted_C[j3], probAB);
                        probA[p] = probAB[0];
                        probB[p] = probAB[1];
                    }
                    f[p] = svm.svm_train_one(sub_prob, param, weighted_C[i], weighted_C[j3]);
                    k = 0;
                    while (k < ci) {
                        if (!nonzero[si + k] && Math.abs(f[p].alpha[k]) > 0.0) {
                            nonzero[si + k] = true;
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < cj) {
                        if (!nonzero[sj + k] && Math.abs(f[p].alpha[ci + k]) > 0.0) {
                            nonzero[sj + k] = true;
                        }
                        ++k;
                    }
                    ++p;
                    ++j3;
                }
                ++i;
            }
            model.nr_class = nr_class;
            model.label = new int[nr_class];
            i = 0;
            while (i < nr_class) {
                model.label[i] = label[i];
                ++i;
            }
            model.rho = new double[nr_class * (nr_class - 1) / 2];
            i = 0;
            while (i < nr_class * (nr_class - 1) / 2) {
                model.rho[i] = f[i].rho;
                ++i;
            }
            if (param.probability == 1) {
                model.probA = new double[nr_class * (nr_class - 1) / 2];
                model.probB = new double[nr_class * (nr_class - 1) / 2];
                i = 0;
                while (i < nr_class * (nr_class - 1) / 2) {
                    model.probA[i] = probA[i];
                    model.probB[i] = probB[i];
                    ++i;
                }
            } else {
                model.probA = null;
                model.probB = null;
            }
            int nnz = 0;
            int[] nz_count = new int[nr_class];
            model.nSV = new int[nr_class];
            i = 0;
            while (i < nr_class) {
                int nSV = 0;
                j = 0;
                while (j < count[i]) {
                    if (nonzero[start[i] + j]) {
                        ++nSV;
                        ++nnz;
                    }
                    ++j;
                }
                model.nSV[i] = nSV;
                nz_count[i] = nSV;
                ++i;
            }
            svm.info("Total nSV = " + nnz + "\n");
            model.l = nnz;
            model.SV = new svm_node[nnz][];
            p = 0;
            i = 0;
            while (i < l) {
                if (nonzero[i]) {
                    model.SV[p++] = x[i];
                }
                ++i;
            }
            int[] nz_start = new int[nr_class];
            nz_start[0] = 0;
            i = 1;
            while (i < nr_class) {
                nz_start[i] = nz_start[i - 1] + nz_count[i - 1];
                ++i;
            }
            model.sv_coef = new double[nr_class - 1][];
            i = 0;
            while (i < nr_class - 1) {
                model.sv_coef[i] = new double[nnz];
                ++i;
            }
            p = 0;
            i = 0;
            while (i < nr_class) {
                j = i + 1;
                while (j < nr_class) {
                    int si = start[i];
                    int sj = start[j];
                    int ci = count[i];
                    int cj = count[j];
                    int q = nz_start[i];
                    int k = 0;
                    while (k < ci) {
                        if (nonzero[si + k]) {
                            model.sv_coef[j - 1][q++] = f[p].alpha[k];
                        }
                        ++k;
                    }
                    q = nz_start[j];
                    k = 0;
                    while (k < cj) {
                        if (nonzero[sj + k]) {
                            model.sv_coef[i][q++] = f[p].alpha[ci + k];
                        }
                        ++k;
                    }
                    ++p;
                    ++j;
                }
                ++i;
            }
        }
        return model;
    }

    public static void svm_cross_validation(svm_problem prob, svm_parameter param, int nr_fold, double[] target) {
        int i;
        int[] fold_start = new int[nr_fold + 1];
        int l = prob.l;
        int[] perm = new int[l];
        if ((param.svm_type == 0 || param.svm_type == 1) && nr_fold < l) {
            int[] tmp_nr_class = new int[1];
            int[][] tmp_label = new int[1][];
            int[][] tmp_start = new int[1][];
            int[][] tmp_count = new int[1][];
            svm.svm_group_classes(prob, tmp_nr_class, tmp_label, tmp_start, tmp_count, perm);
            int nr_class = tmp_nr_class[0];
            int[] start = tmp_start[0];
            int[] count = tmp_count[0];
            int[] fold_count = new int[nr_fold];
            int[] index = new int[l];
            i = 0;
            while (i < l) {
                index[i] = perm[i];
                ++i;
            }
            int c = 0;
            while (c < nr_class) {
                i = 0;
                while (i < count[c]) {
                    int j = i + rand.nextInt(count[c] - i);
                    Array.swap(index, start[c] + j, start[c] + i);
                    ++i;
                }
                ++c;
            }
            i = 0;
            while (i < nr_fold) {
                fold_count[i] = 0;
                c = 0;
                while (c < nr_class) {
                    int n = i;
                    fold_count[n] = fold_count[n] + ((i + 1) * count[c] / nr_fold - i * count[c] / nr_fold);
                    ++c;
                }
                ++i;
            }
            fold_start[0] = 0;
            i = 1;
            while (i <= nr_fold) {
                fold_start[i] = fold_start[i - 1] + fold_count[i - 1];
                ++i;
            }
            c = 0;
            while (c < nr_class) {
                i = 0;
                while (i < nr_fold) {
                    int begin = start[c] + i * count[c] / nr_fold;
                    int end = start[c] + (i + 1) * count[c] / nr_fold;
                    int j = begin;
                    while (j < end) {
                        perm[fold_start[i]] = index[j];
                        int n = i;
                        fold_start[n] = fold_start[n] + 1;
                        ++j;
                    }
                    ++i;
                }
                ++c;
            }
            fold_start[0] = 0;
            i = 1;
            while (i <= nr_fold) {
                fold_start[i] = fold_start[i - 1] + fold_count[i - 1];
                ++i;
            }
        } else {
            i = 0;
            while (i < l) {
                perm[i] = i;
                ++i;
            }
            i = 0;
            while (i < l) {
                int j = i + rand.nextInt(l - i);
                Array.swap(perm, i, j);
                ++i;
            }
            i = 0;
            while (i <= nr_fold) {
                fold_start[i] = i * l / nr_fold;
                ++i;
            }
        }
        i = 0;
        while (i < nr_fold) {
            int begin = fold_start[i];
            int end = fold_start[i + 1];
            svm_problem subprob = new svm_problem();
            subprob.l = l - (end - begin);
            subprob.x = new svm_node[subprob.l][];
            subprob.y = new double[subprob.l];
            int k = 0;
            int j = 0;
            while (j < begin) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
                ++j;
            }
            j = end;
            while (j < l) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
                ++j;
            }
            svm_model submodel = svm.svm_train(subprob, param);
            if (param.probability == 1 && (param.svm_type == 0 || param.svm_type == 1)) {
                double[] prob_estimates = new double[svm.svm_get_nr_class(submodel)];
                j = begin;
                while (j < end) {
                    target[perm[j]] = svm.svm_predict_probability(submodel, prob.x[perm[j]], prob_estimates);
                    ++j;
                }
            } else {
                j = begin;
                while (j < end) {
                    target[perm[j]] = svm.svm_predict(submodel, prob.x[perm[j]]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public static int svm_get_svm_type(svm_model model) {
        return model.param.svm_type;
    }

    public static int svm_get_nr_class(svm_model model) {
        return model.nr_class;
    }

    public static void svm_get_labels(svm_model model, int[] label) {
        if (model.label != null) {
            int i = 0;
            while (i < model.nr_class) {
                label[i] = model.label[i];
                ++i;
            }
        }
    }

    public static double svm_get_svr_probability(svm_model model) {
        if ((model.param.svm_type == 3 || model.param.svm_type == 4) && model.probA != null) {
            return model.probA[0];
        }
        System.err.print("Model doesn't contain information for SVR probability inference\n");
        return 0.0;
    }

    public static double svm_predict_values(svm_model model, svm_node[] x, double[] dec_values) {
        if (model.param.svm_type == 2 || model.param.svm_type == 3 || model.param.svm_type == 4) {
            double[] sv_coef = model.sv_coef[0];
            double sum = 0.0;
            int i = 0;
            while (i < model.l) {
                sum += sv_coef[i] * Kernel.k_function(x, model.SV[i], model.param);
                ++i;
            }
            dec_values[0] = sum -= model.rho[0];
            if (model.param.svm_type == 2) {
                return sum > 0.0 ? 1 : -1;
            }
            return sum;
        }
        int nr_class = model.nr_class;
        int l = model.l;
        double[] kvalue = new double[l];
        int i = 0;
        while (i < l) {
            kvalue[i] = Kernel.k_function(x, model.SV[i], model.param);
            ++i;
        }
        int[] start = new int[nr_class];
        start[0] = 0;
        i = 1;
        while (i < nr_class) {
            start[i] = start[i - 1] + model.nSV[i - 1];
            ++i;
        }
        int[] vote = new int[nr_class];
        i = 0;
        while (i < nr_class) {
            vote[i] = 0;
            ++i;
        }
        int p = 0;
        i = 0;
        while (i < nr_class) {
            int j = i + 1;
            while (j < nr_class) {
                double sum = 0.0;
                int si = start[i];
                int sj = start[j];
                int ci = model.nSV[i];
                int cj = model.nSV[j];
                double[] coef1 = model.sv_coef[j - 1];
                double[] coef2 = model.sv_coef[i];
                int k = 0;
                while (k < ci) {
                    sum += coef1[si + k] * kvalue[si + k];
                    ++k;
                }
                k = 0;
                while (k < cj) {
                    sum += coef2[sj + k] * kvalue[sj + k];
                    ++k;
                }
                dec_values[p] = sum -= model.rho[p];
                if (dec_values[p] > 0.0) {
                    int n = i;
                    vote[n] = vote[n] + 1;
                } else {
                    int n = j;
                    vote[n] = vote[n] + 1;
                }
                ++p;
                ++j;
            }
            ++i;
        }
        int vote_max_idx = 0;
        i = 1;
        while (i < nr_class) {
            if (vote[i] > vote[vote_max_idx]) {
                vote_max_idx = i;
            }
            ++i;
        }
        return model.label[vote_max_idx];
    }

    public static double svm_predict(svm_model model, svm_node[] x) {
        int nr_class = model.nr_class;
        double[] dec_values = model.param.svm_type == 2 || model.param.svm_type == 3 || model.param.svm_type == 4 ? new double[1] : new double[nr_class * (nr_class - 1) / 2];
        double pred_result = svm.svm_predict_values(model, x, dec_values);
        return pred_result;
    }

    public static double svm_predict_probability(svm_model model, svm_node[] x, double[] prob_estimates) {
        if ((model.param.svm_type == 0 || model.param.svm_type == 1) && model.probA != null && model.probB != null) {
            int nr_class = model.nr_class;
            double[] dec_values = new double[nr_class * (nr_class - 1) / 2];
            svm.svm_predict_values(model, x, dec_values);
            double min_prob = 1.0E-7;
            double[][] pairwise_prob = new double[nr_class][nr_class];
            int k = 0;
            int i = 0;
            while (i < nr_class) {
                int j = i + 1;
                while (j < nr_class) {
                    pairwise_prob[i][j] = Math.min(Math.max(svm.sigmoid_predict(dec_values[k], model.probA[k], model.probB[k]), min_prob), 1.0 - min_prob);
                    pairwise_prob[j][i] = 1.0 - pairwise_prob[i][j];
                    ++k;
                    ++j;
                }
                ++i;
            }
            svm.multiclass_probability(nr_class, pairwise_prob, prob_estimates);
            int prob_max_idx = 0;
            i = 1;
            while (i < nr_class) {
                if (prob_estimates[i] > prob_estimates[prob_max_idx]) {
                    prob_max_idx = i;
                }
                ++i;
            }
            return model.label[prob_max_idx];
        }
        return svm.svm_predict(model, x);
    }

    public static void svm_save_model(String model_file_name, svm_model model) throws IOException {
        DataOutputStream fp = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(model_file_name)));
        svm_parameter param = model.param;
        fp.writeBytes("svm_type " + svm_type_table[param.svm_type] + "\n");
        fp.writeBytes("kernel_type " + kernel_type_table[param.kernel_type] + "\n");
        if (param.kernel_type == 1) {
            fp.writeBytes("degree " + param.degree + "\n");
        }
        if (param.kernel_type == 1 || param.kernel_type == 2 || param.kernel_type == 3) {
            fp.writeBytes("gamma " + param.gamma + "\n");
        }
        if (param.kernel_type == 1 || param.kernel_type == 3) {
            fp.writeBytes("coef0 " + param.coef0 + "\n");
        }
        int nr_class = model.nr_class;
        int l = model.l;
        fp.writeBytes("nr_class " + nr_class + "\n");
        fp.writeBytes("total_sv " + l + "\n");
        fp.writeBytes("rho");
        int i = 0;
        while (i < nr_class * (nr_class - 1) / 2) {
            fp.writeBytes(" " + model.rho[i]);
            ++i;
        }
        fp.writeBytes("\n");
        if (model.label != null) {
            fp.writeBytes("label");
            i = 0;
            while (i < nr_class) {
                fp.writeBytes(" " + model.label[i]);
                ++i;
            }
            fp.writeBytes("\n");
        }
        if (model.probA != null) {
            fp.writeBytes("probA");
            i = 0;
            while (i < nr_class * (nr_class - 1) / 2) {
                fp.writeBytes(" " + model.probA[i]);
                ++i;
            }
            fp.writeBytes("\n");
        }
        if (model.probB != null) {
            fp.writeBytes("probB");
            i = 0;
            while (i < nr_class * (nr_class - 1) / 2) {
                fp.writeBytes(" " + model.probB[i]);
                ++i;
            }
            fp.writeBytes("\n");
        }
        if (model.nSV != null) {
            fp.writeBytes("nr_sv");
            i = 0;
            while (i < nr_class) {
                fp.writeBytes(" " + model.nSV[i]);
                ++i;
            }
            fp.writeBytes("\n");
        }
        fp.writeBytes("SV\n");
        double[][] sv_coef = model.sv_coef;
        svm_node[][] SV = model.SV;
        int i2 = 0;
        while (i2 < l) {
            int j = 0;
            while (j < nr_class - 1) {
                fp.writeBytes(String.valueOf(sv_coef[j][i2]) + " ");
                ++j;
            }
            svm_node[] p = SV[i2];
            if (param.kernel_type == 4) {
                fp.writeBytes("0:" + (int)p[0].value);
            } else {
                int j2 = 0;
                while (j2 < p.length) {
                    fp.writeBytes(String.valueOf(p[j2].index) + ":" + p[j2].value + " ");
                    ++j2;
                }
            }
            fp.writeBytes("\n");
            ++i2;
        }
        fp.close();
    }

    public static void svm_save_model(DataOutputStream fp, svm_model model) throws IOException {
        svm_parameter param = model.param;
        fp.writeBytes("svm_type " + svm_type_table[param.svm_type] + "\n");
        fp.writeBytes("kernel_type " + kernel_type_table[param.kernel_type] + "\n");
        if (param.kernel_type == 1) {
            fp.writeBytes("degree " + param.degree + "\n");
        }
        if (param.kernel_type == 1 || param.kernel_type == 2 || param.kernel_type == 3) {
            fp.writeBytes("gamma " + param.gamma + "\n");
        }
        if (param.kernel_type == 1 || param.kernel_type == 3) {
            fp.writeBytes("coef0 " + param.coef0 + "\n");
        }
        int nr_class = model.nr_class;
        int l = model.l;
        fp.writeBytes("nr_class " + nr_class + "\n");
        fp.writeBytes("total_sv " + l + "\n");
        fp.writeBytes("rho");
        int i = 0;
        while (i < nr_class * (nr_class - 1) / 2) {
            fp.writeBytes(" " + model.rho[i]);
            ++i;
        }
        fp.writeBytes("\n");
        if (model.label != null) {
            fp.writeBytes("label");
            i = 0;
            while (i < nr_class) {
                fp.writeBytes(" " + model.label[i]);
                ++i;
            }
            fp.writeBytes("\n");
        }
        if (model.probA != null) {
            fp.writeBytes("probA");
            i = 0;
            while (i < nr_class * (nr_class - 1) / 2) {
                fp.writeBytes(" " + model.probA[i]);
                ++i;
            }
            fp.writeBytes("\n");
        }
        if (model.probB != null) {
            fp.writeBytes("probB");
            i = 0;
            while (i < nr_class * (nr_class - 1) / 2) {
                fp.writeBytes(" " + model.probB[i]);
                ++i;
            }
            fp.writeBytes("\n");
        }
        if (model.nSV != null) {
            fp.writeBytes("nr_sv");
            i = 0;
            while (i < nr_class) {
                fp.writeBytes(" " + model.nSV[i]);
                ++i;
            }
            fp.writeBytes("\n");
        }
        fp.writeBytes("SV\n");
        double[][] sv_coef = model.sv_coef;
        svm_node[][] SV = model.SV;
        int i2 = 0;
        while (i2 < l) {
            int j = 0;
            while (j < nr_class - 1) {
                fp.writeBytes(String.valueOf(sv_coef[j][i2]) + " ");
                ++j;
            }
            svm_node[] p = SV[i2];
            if (param.kernel_type == 4) {
                fp.writeBytes("0:" + (int)p[0].value);
            } else {
                int j2 = 0;
                while (j2 < p.length) {
                    fp.writeBytes(String.valueOf(p[j2].index) + ":" + p[j2].value + " ");
                    ++j2;
                }
            }
            fp.writeBytes("\n");
            ++i2;
        }
    }

    private static double atof(String s) {
        return CSVFormat.EG_FORMAT.parse(s);
    }

    private static int atoi(String s) {
        return Integer.parseInt(s);
    }

    public static svm_model svm_load_model(String model_file_name) throws IOException {
        return svm.svm_load_model(new BufferedReader(new FileReader(model_file_name)));
    }

    /*
     * Unable to fully structure code
     */
    public static svm_model svm_load_model(BufferedReader fp) throws IOException {
        model = new svm_model();
        model.param = param = new svm_parameter();
        model.rho = null;
        model.probA = null;
        model.probB = null;
        model.label = null;
        model.nSV = null;
        block0: while (true) {
            cmd = fp.readLine();
            arg = cmd.substring(cmd.indexOf(32) + 1);
            if (cmd.startsWith("svm_type")) {
                i = 0;
                while (i < svm.svm_type_table.length) {
                    if (arg.indexOf(svm.svm_type_table[i]) != -1) {
                        param.svm_type = i;
                        break;
                    }
                    ++i;
                }
                if (i != svm.svm_type_table.length) continue;
                System.err.print("unknown svm type.\n");
                return null;
            }
            if (cmd.startsWith("kernel_type")) {
                i = 0;
                while (i < svm.kernel_type_table.length) {
                    if (arg.indexOf(svm.kernel_type_table[i]) != -1) {
                        param.kernel_type = i;
                        break;
                    }
                    ++i;
                }
                if (i != svm.kernel_type_table.length) continue;
                System.err.print("unknown kernel function.\n");
                return null;
            }
            if (cmd.startsWith("degree")) {
                param.degree = svm.atoi(arg);
                continue;
            }
            if (cmd.startsWith("gamma")) {
                param.gamma = svm.atof(arg);
                continue;
            }
            if (cmd.startsWith("coef0")) {
                param.coef0 = svm.atof(arg);
                continue;
            }
            if (cmd.startsWith("nr_class")) {
                model.nr_class = svm.atoi(arg);
                continue;
            }
            if (cmd.startsWith("total_sv")) {
                model.l = svm.atoi(arg);
                continue;
            }
            if (cmd.startsWith("rho")) {
                n = model.nr_class * (model.nr_class - 1) / 2;
                model.rho = new double[n];
                st = new StringTokenizer(arg);
                i = 0;
                while (true) {
                    if (i >= n) continue block0;
                    model.rho[i] = svm.atof(st.nextToken());
                    ++i;
                }
            }
            if (cmd.startsWith("label")) {
                n = model.nr_class;
                model.label = new int[n];
                st = new StringTokenizer(arg);
                i = 0;
                while (true) {
                    if (i >= n) continue block0;
                    model.label[i] = svm.atoi(st.nextToken());
                    ++i;
                }
            }
            if (cmd.startsWith("probA")) {
                n = model.nr_class * (model.nr_class - 1) / 2;
                model.probA = new double[n];
                st = new StringTokenizer(arg);
                i = 0;
                while (true) {
                    if (i >= n) continue block0;
                    model.probA[i] = svm.atof(st.nextToken());
                    ++i;
                }
            }
            if (cmd.startsWith("probB")) {
                n = model.nr_class * (model.nr_class - 1) / 2;
                model.probB = new double[n];
                st = new StringTokenizer(arg);
                i = 0;
                while (true) {
                    if (i >= n) continue block0;
                    model.probB[i] = svm.atof(st.nextToken());
                    ++i;
                }
            }
            if (!cmd.startsWith("nr_sv")) break;
            n = model.nr_class;
            model.nSV = new int[n];
            st = new StringTokenizer(arg);
            i = 0;
            while (true) {
                if (i < n) ** break;
                continue block0;
                model.nSV[i] = svm.atoi(st.nextToken());
                ++i;
            }
            break;
        }
        if (!cmd.startsWith("SV")) {
            System.err.print("unknown text in model file: [" + cmd + "]\n");
            return null;
        }
        m = model.nr_class - 1;
        l = model.l;
        model.sv_coef = new double[m][l];
        model.SV = new svm_node[l][];
        i = 0;
        while (i < l) {
            line = fp.readLine();
            st = new StringTokenizer(line, " \t\n\r\f:");
            k = 0;
            while (k < m) {
                model.sv_coef[k][i] = svm.atof(st.nextToken());
                ++k;
            }
            n = st.countTokens() / 2;
            model.SV[i] = new svm_node[n];
            j = 0;
            while (j < n) {
                model.SV[i][j] = new svm_node();
                model.SV[i][j].index = svm.atoi(st.nextToken());
                model.SV[i][j].value = svm.atof(st.nextToken());
                ++j;
            }
            ++i;
        }
        fp.close();
        return model;
    }

    public static String svm_check_parameter(svm_problem prob, svm_parameter param) {
        int svm_type = param.svm_type;
        if (svm_type != 0 && svm_type != 1 && svm_type != 2 && svm_type != 3 && svm_type != 4) {
            return "unknown svm type";
        }
        int kernel_type = param.kernel_type;
        if (kernel_type != 0 && kernel_type != 1 && kernel_type != 2 && kernel_type != 3 && kernel_type != 4) {
            return "unknown kernel type";
        }
        if (param.gamma < 0.0) {
            return "gamma < 0";
        }
        if (param.degree < 0) {
            return "degree of polynomial kernel < 0";
        }
        if (param.cache_size <= 0.0) {
            return "cache_size <= 0";
        }
        if (param.eps <= 0.0) {
            return "eps <= 0";
        }
        if ((svm_type == 0 || svm_type == 3 || svm_type == 4) && param.C <= 0.0) {
            return "C <= 0";
        }
        if ((svm_type == 1 || svm_type == 2 || svm_type == 4) && (param.nu <= 0.0 || param.nu > 1.0)) {
            return "nu <= 0 or nu > 1";
        }
        if (svm_type == 3 && param.p < 0.0) {
            return "p < 0";
        }
        if (param.shrinking != 0 && param.shrinking != 1) {
            return "shrinking != 0 and shrinking != 1";
        }
        if (param.probability != 0 && param.probability != 1) {
            return "probability != 0 and probability != 1";
        }
        if (param.probability == 1 && svm_type == 2) {
            return "one-class SVM probability output not supported yet";
        }
        if (svm_type == 1) {
            int j;
            int l = prob.l;
            int max_nr_class = 16;
            int nr_class = 0;
            int[] label = new int[max_nr_class];
            int[] count = new int[max_nr_class];
            int i = 0;
            while (i < l) {
                int this_label = (int)prob.y[i];
                j = 0;
                while (j < nr_class) {
                    if (this_label == label[j]) {
                        int n = j;
                        count[n] = count[n] + 1;
                        break;
                    }
                    ++j;
                }
                if (j == nr_class) {
                    if (nr_class == max_nr_class) {
                        int[] new_data = new int[max_nr_class *= 2];
                        System.arraycopy(label, 0, new_data, 0, label.length);
                        label = new_data;
                        new_data = new int[max_nr_class];
                        System.arraycopy(count, 0, new_data, 0, count.length);
                        count = new_data;
                    }
                    label[nr_class] = this_label;
                    count[nr_class] = 1;
                    ++nr_class;
                }
                ++i;
            }
            i = 0;
            while (i < nr_class) {
                int n1 = count[i];
                j = i + 1;
                while (j < nr_class) {
                    int n2 = count[j];
                    if (param.nu * (double)(n1 + n2) / 2.0 > (double)Math.min(n1, n2)) {
                        return "specified nu is infeasible";
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static int svm_check_probability_model(svm_model model) {
        if ((model.param.svm_type == 0 || model.param.svm_type == 1) && model.probA != null && model.probB != null || (model.param.svm_type == 3 || model.param.svm_type == 4) && model.probA != null) {
            return 1;
        }
        return 0;
    }

    public static void svm_set_print_string_function(svm_print_interface print_func) {
        svm_print_string = print_func == null ? svm_print_stdout : print_func;
    }

    static class decision_function {
        double[] alpha;
        double rho;

        decision_function() {
        }
    }
}

