/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.dimension;

import org.encog.mathutil.dimension.MultiDimension;

public class DimensionConstraint {
    private final MultiDimension lower;
    private final MultiDimension upper;

    public DimensionConstraint(int n, int theLower, int theUpper) {
        this.lower = new MultiDimension(n);
        this.upper = new MultiDimension(n);
        int i = 0;
        while (i < n) {
            this.lower.setDimension(i, theLower);
            this.upper.setDimension(i, theUpper);
            ++i;
        }
    }

    public MultiDimension getLower() {
        return this.lower;
    }

    public MultiDimension getUpper() {
        return this.upper;
    }

    public int getLower(int d) {
        return this.lower.getDimension(d);
    }

    public int getUpper(int d) {
        return this.upper.getDimension(d);
    }

    public int getRange(int d) {
        return this.upper.getDimension(d) - this.lower.getDimension(d) + 1;
    }

    public int getMiddle(int d) {
        return this.getRange(d) / 2;
    }
}

