/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

import java.io.Serializable;
import org.encog.EncogError;

public class Equilateral
implements Serializable {
    public static final int MIN_EQ = 3;
    private final double[][] matrix;

    public Equilateral(int count, double high, double low) {
        this.matrix = this.equilat(count, high, low);
    }

    public final int decode(double[] activations) {
        double minValue = Double.POSITIVE_INFINITY;
        int minSet = -1;
        int i = 0;
        while (i < this.matrix.length) {
            double dist = this.getDistance(activations, i);
            if (dist < minValue) {
                minValue = dist;
                minSet = i;
            }
            ++i;
        }
        return minSet;
    }

    public final double[] encode(int set) {
        if (set < 0 || set > this.matrix.length) {
            throw new EncogError("Class out of range for equilateral: " + set);
        }
        return this.matrix[set];
    }

    private double[][] equilat(int n, double high, double low) {
        double[][] result = new double[n][n - 1];
        result[0][0] = -1.0;
        result[1][0] = 1.0;
        int k = 2;
        while (k < n) {
            double r = k;
            double f = Math.sqrt(r * r - 1.0) / r;
            int i = 0;
            while (i < k) {
                int j = 0;
                while (j < k - 1) {
                    double[] dArray = result[i];
                    int n2 = j++;
                    dArray[n2] = dArray[n2] * f;
                }
                ++i;
            }
            r = -1.0 / r;
            i = 0;
            while (i < k) {
                result[i][k - 1] = r;
                ++i;
            }
            i = 0;
            while (i < k - 1) {
                result[k][i] = 0.0;
                ++i;
            }
            result[k][k - 1] = 1.0;
            ++k;
        }
        int row = 0;
        while (row < result.length) {
            int col = 0;
            while (col < result[0].length) {
                double min = -1.0;
                double max = 1.0;
                result[row][col] = (result[row][col] - -1.0) / 2.0 * (high - low) + low;
                ++col;
            }
            ++row;
        }
        return result;
    }

    public final double getDistance(double[] data, int set) {
        double result = 0.0;
        int i = 0;
        while (i < data.length) {
            result += Math.pow(data[i] - this.matrix[set][i], 2.0);
            ++i;
        }
        return Math.sqrt(result);
    }
}

