/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.util.obj.ActivationUtil;

public class ActivationReLU
implements ActivationFunction {
    public static final int PARAM_RELU_LOW_THRESHOLD = 0;
    public static final int PARAM_RELU_LOW = 0;
    private static final long serialVersionUID = 6336245112244386279L;
    private final double[] params = new double[2];

    public ActivationReLU() {
        this(0.0, 0.0);
    }

    public ActivationReLU(double thresholdLow, double low) {
        this.params[0] = thresholdLow;
        this.params[0] = low;
    }

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        int i = start;
        while (i < start + size) {
            if (x[i] <= this.params[0]) {
                x[i] = this.params[0];
            }
            ++i;
        }
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationReLU(this.params[0], this.params[0]);
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        if (b <= this.params[0]) {
            return 0.0;
        }
        return 1.0;
    }

    public final double getLow() {
        return this.params[0];
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{"thresholdLow", "low"};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    public final double getThresholdLow() {
        return this.params[0];
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    public final void setLow(double d) {
        this.setParam(0, d);
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }

    public final void setThresholdLow(double d) {
        this.setParam(0, d);
    }

    @Override
    public String getFactoryCode() {
        return ActivationUtil.generateActivationFactory("relu", this);
    }

    @Override
    public String getLabel() {
        return "relu";
    }
}

