/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ca.universe.basic;

import java.io.Serializable;
import org.encog.ca.CellularAutomataError;
import org.encog.ca.universe.DiscreteCell;
import org.encog.ca.universe.UniverseCell;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.util.EngineArray;

public class BasicDiscreteCell
implements DiscreteCell,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[] data;
    private int elementCount;

    public BasicDiscreteCell(int theSize, int theElementCount) {
        this.data = new int[theSize];
        this.elementCount = theElementCount;
    }

    @Override
    public double get(int index) {
        return this.data[index];
    }

    @Override
    public void randomize() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = RangeRandomizer.randomInt(0, this.elementCount);
            ++i;
        }
    }

    @Override
    public void copy(UniverseCell sourceCell) {
        if (!(sourceCell instanceof BasicDiscreteCell)) {
            throw new CellularAutomataError("Can only copy another BasicDiscreteCell.");
        }
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = (int)sourceCell.get(i);
            ++i;
        }
    }

    @Override
    public double getAvg() {
        return (int)EngineArray.mean(this.data);
    }

    @Override
    public void set(int i, double d) {
        this.data[i] = (int)d;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public void set(int idx, double[] d) {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = (int)d[idx + i];
            ++i;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("'[");
        result.append(this.getClass().getSimpleName());
        result.append(":");
        int i = 0;
        while (i < this.size()) {
            if (i > 0) {
                result.append(',');
            }
            result.append(i);
            result.append("=");
            result.append(this.data[i]);
            ++i;
        }
        result.append("]");
        return result.toString();
    }
}

