/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.encog.bot.browse.Address;
import org.encog.bot.browse.BrowseError;
import org.encog.bot.browse.WebPage;
import org.encog.bot.browse.range.Div;
import org.encog.bot.browse.range.DocumentRange;
import org.encog.bot.browse.range.Form;
import org.encog.bot.browse.range.Input;
import org.encog.bot.browse.range.Link;
import org.encog.bot.browse.range.Span;
import org.encog.bot.dataunit.CodeDataUnit;
import org.encog.bot.dataunit.DataUnit;
import org.encog.bot.dataunit.TagDataUnit;
import org.encog.bot.dataunit.TextDataUnit;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadHTML;
import org.encog.util.logging.EncogLogging;

public class LoadWebPage {
    private WebPage page;
    private final URL base;
    private Form lastForm;
    private DocumentRange lastHierarchyElement;

    public LoadWebPage(URL theBase) {
        this.base = theBase;
    }

    private void addHierarchyElement(DocumentRange element) {
        if (this.lastHierarchyElement == null) {
            this.page.addContent(element);
        } else {
            this.lastHierarchyElement.addElement(element);
        }
        this.lastHierarchyElement = element;
    }

    private void createCodeDataUnit(String str) {
        if (str.trim().length() > 0) {
            CodeDataUnit d = new CodeDataUnit();
            d.setCode(str);
            this.page.addDataUnit(d);
        }
    }

    private void createTagDataUnit(Tag tag) {
        TagDataUnit d = new TagDataUnit();
        d.setTag(tag.clone());
        this.page.addDataUnit(d);
    }

    private void createTextDataUnit(String str) {
        if (str.trim().length() > 0) {
            TextDataUnit d = new TextDataUnit();
            d.setText(str);
            this.page.addDataUnit(d);
        }
    }

    public final int findEndTag(int index, Tag tag) {
        int depth = 0;
        int count = index;
        while (count < this.page.getDataSize()) {
            DataUnit du = this.page.getDataUnit(count);
            if (du instanceof TagDataUnit) {
                Tag nextTag = ((TagDataUnit)du).getTag();
                if (tag.getName().equalsIgnoreCase(nextTag.getName())) {
                    if (nextTag.getType() == Tag.Type.END) {
                        if (depth == 0) {
                            return count;
                        }
                        --depth;
                    } else if (nextTag.getType() == Tag.Type.BEGIN) {
                        ++depth;
                    }
                }
            }
            ++count;
        }
        return -1;
    }

    public final WebPage load(InputStream is) {
        this.page = new WebPage();
        this.loadDataUnits(is);
        this.loadContents();
        return this.page;
    }

    public final WebPage load(String str) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
            WebPage result = this.load(bis);
            bis.close();
            return result;
        }
        catch (IOException e) {
            EncogLogging.log(e);
            throw new BrowseError(e);
        }
    }

    protected final void loadContents() {
        int index = 0;
        while (index < this.page.getDataSize()) {
            DataUnit du = this.page.getDataUnit(index);
            if (du instanceof TagDataUnit) {
                Tag tag = ((TagDataUnit)du).getTag();
                if (tag.getType() != Tag.Type.END) {
                    if (tag.getName().equalsIgnoreCase("a")) {
                        this.loadLink(index, tag);
                    } else if (tag.getName().equalsIgnoreCase("title")) {
                        this.loadTitle(index, tag);
                    } else if (tag.getName().equalsIgnoreCase("form")) {
                        this.loadForm(index, tag);
                    } else if (tag.getName().equalsIgnoreCase("input")) {
                        this.loadInput(index, tag);
                    }
                }
                if (tag.getType() == Tag.Type.BEGIN) {
                    if (tag.getName().equalsIgnoreCase("div")) {
                        this.loadDiv(index, tag);
                    } else if (tag.getName().equalsIgnoreCase("span")) {
                        this.loadSpan(index, tag);
                    }
                }
                if (tag.getType() == Tag.Type.END) {
                    if (tag.getName().equalsIgnoreCase("div")) {
                        if (this.lastHierarchyElement != null) {
                            this.lastHierarchyElement = this.lastHierarchyElement.getParent();
                        }
                    } else if (tag.getName().equalsIgnoreCase("span") && this.lastHierarchyElement != null) {
                        this.lastHierarchyElement = this.lastHierarchyElement.getParent();
                    }
                }
            }
            ++index;
        }
    }

    protected final void loadDataUnits(InputStream is) {
        int ch;
        StringBuilder text = new StringBuilder();
        ReadHTML parse = new ReadHTML(is);
        boolean style = false;
        boolean script = false;
        while ((ch = parse.read()) != -1) {
            if (ch == 0) {
                if (style) {
                    this.createCodeDataUnit(text.toString());
                } else if (script) {
                    this.createCodeDataUnit(text.toString());
                } else {
                    this.createTextDataUnit(text.toString());
                }
                style = false;
                script = false;
                text.setLength(0);
                this.createTagDataUnit(parse.getTag());
                if (parse.getTag().getName().equalsIgnoreCase("style")) {
                    style = true;
                    continue;
                }
                if (!parse.getTag().getName().equalsIgnoreCase("script")) continue;
                script = true;
                continue;
            }
            text.append((char)ch);
        }
        this.createTextDataUnit(text.toString());
    }

    private void loadDiv(int index, Tag tag) {
        Div div = new Div(this.page);
        String classAttribute = tag.getAttributeValue("class");
        String idAttribute = tag.getAttributeValue("id");
        div.setIdAttribute(idAttribute);
        div.setClassAttribute(classAttribute);
        div.setBegin(index);
        div.setEnd(this.findEndTag(index + 1, tag));
        this.addHierarchyElement(div);
    }

    protected final void loadForm(int index, Tag tag) {
        String method = tag.getAttributeValue("method");
        String action = tag.getAttributeValue("action");
        Form form = new Form(this.page);
        form.setBegin(index);
        form.setEnd(this.findEndTag(index + 1, tag));
        if (method == null || method.equalsIgnoreCase("GET")) {
            form.setMethod(Form.Method.GET);
        } else {
            form.setMethod(Form.Method.POST);
        }
        if (action == null) {
            form.setAction(new Address(this.base));
        } else {
            form.setAction(new Address(this.base, action));
        }
        this.page.addContent(form);
        this.lastForm = form;
    }

    protected final void loadInput(int index, Tag tag) {
        String type = tag.getAttributeValue("type");
        String name = tag.getAttributeValue("name");
        String value = tag.getAttributeValue("value");
        Input input = new Input(this.page);
        input.setType(type);
        input.setName(name);
        input.setValue(value);
        if (this.lastForm != null) {
            this.lastForm.addElement(input);
        } else {
            this.page.addContent(input);
        }
    }

    protected final void loadLink(int index, Tag tag) {
        Link link = new Link(this.page);
        String href = tag.getAttributeValue("href");
        if (href != null) {
            link.setTarget(new Address(this.base, href));
            link.setBegin(index);
            link.setEnd(this.findEndTag(index + 1, tag));
            this.page.addContent(link);
        }
    }

    private void loadSpan(int index, Tag tag) {
        Span span = new Span(this.page);
        String classAttribute = tag.getAttributeValue("class");
        String idAttribute = tag.getAttributeValue("id");
        span.setIdAttribute(idAttribute);
        span.setClassAttribute(classAttribute);
        span.setBegin(index);
        span.setEnd(this.findEndTag(index + 1, tag));
        this.addHierarchyElement(span);
    }

    protected final void loadTitle(int index, Tag tag) {
        DocumentRange title = new DocumentRange(this.page);
        title.setBegin(index);
        title.setEnd(this.findEndTag(index + 1, tag));
        this.page.setTitle(title);
    }
}

