/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.generate.generators.mql4;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.generate.AnalystCodeGenerationError;
import org.encog.app.generate.generators.AbstractTemplateGenerator;
import org.encog.ml.MLMethod;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.EngineArray;

public class GenerateMQL4
extends AbstractTemplateGenerator {
    @Override
    public String getNullArray() {
        return "{-1}";
    }

    @Override
    public String getTemplatePath() {
        return "org/encog/data/mt4.mql4";
    }

    private void processCalc() {
        AnalystField firstOutputField = null;
        int barsNeeded = Math.abs(this.getAnalyst().determineMinTimeSlice());
        int inputCount = this.getAnalyst().determineInputCount();
        int outputCount = this.getAnalyst().determineOutputCount();
        this.setIndentLevel(2);
        this.addLine("if( _inputCount>0 && Bars>=" + barsNeeded + " )");
        this.addLine("{");
        this.indentIn();
        this.addLine("double input[" + inputCount + "];");
        this.addLine("double output[" + outputCount + "];");
        int idx = 0;
        for (AnalystField field : this.getAnalyst().getScript().getNormalize().getNormalizedFields()) {
            if (field.isInput()) {
                DataField df = this.getAnalyst().getScript().findDataField(field.getName());
                switch (field.getAction()) {
                    case PassThrough: {
                        String str = EngineArray.replace(df.getSource(), "##", "pos+" + -field.getTimeSlice());
                        this.addLine("input[" + idx + "]=" + str + ";");
                        ++idx;
                        break;
                    }
                    case Normalize: {
                        String str = EngineArray.replace(df.getSource(), "##", "pos+" + -field.getTimeSlice());
                        this.addLine("input[" + idx + "]=Norm(" + str + "," + field.getNormalizedHigh() + "," + field.getNormalizedLow() + "," + field.getActualHigh() + "," + field.getActualLow() + ");");
                        ++idx;
                        break;
                    }
                    case Ignore: {
                        break;
                    }
                    default: {
                        throw new AnalystCodeGenerationError("Can't generate Ninjascript code, unsupported normalizatoin action: " + field.getAction().toString());
                    }
                }
            }
            if (!field.isOutput() || firstOutputField != null) continue;
            firstOutputField = field;
        }
        if (firstOutputField == null) {
            throw new AnalystCodeGenerationError("Could not find an output field.");
        }
        this.addLine("Compute(input,output);");
        this.addLine("ExtMapBuffer1[pos] = DeNorm(output[0]," + firstOutputField.getNormalizedHigh() + "," + firstOutputField.getNormalizedLow() + "," + firstOutputField.getActualHigh() + "," + firstOutputField.getActualLow() + ");");
        this.indentOut();
        this.addLine("}");
        this.setIndentLevel(2);
    }

    private void processHeaders() {
        DataField[] fields = this.getAnalyst().getScript().getFields();
        StringBuilder line = new StringBuilder();
        line.append("FileWrite(iHandle");
        DataField[] dataFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            DataField df = dataFieldArray[n2];
            line.append(",");
            line.append("\"");
            line.append(df.getName());
            line.append("\"");
            ++n2;
        }
        line.append(");");
        this.addLine(line.toString());
    }

    private void processMainBlock() {
        EncogAnalyst analyst = this.getAnalyst();
        String processID = analyst.getScript().getProperties().getPropertyString("PROCESS:CONFIG_sourceFile");
        String methodID = analyst.getScript().getProperties().getPropertyString("ML:CONFIG_machineLearningFile");
        File methodFile = analyst.getScript().resolveFilename(methodID);
        File processFile = analyst.getScript().resolveFilename(processID);
        MLMethod method = null;
        int[] contextTargetOffset = null;
        int[] contextTargetSize = null;
        boolean hasContext = false;
        int inputCount = 0;
        int[] layerContextCount = null;
        int[] layerCounts = null;
        int[] layerFeedCounts = null;
        int[] layerIndex = null;
        double[] layerOutput = null;
        double[] layerSums = null;
        int outputCount = 0;
        int[] weightIndex = null;
        double[] weights = null;
        int neuronCount = 0;
        int layerCount = 0;
        int[] activation = null;
        double[] p = null;
        if (methodFile.exists()) {
            method = (MLMethod)EncogDirectoryPersistence.loadObject(methodFile);
            FlatNetwork flat = ((BasicNetwork)method).getFlat();
            contextTargetOffset = flat.getContextTargetOffset();
            contextTargetSize = flat.getContextTargetSize();
            hasContext = flat.getHasContext();
            inputCount = flat.getInputCount();
            layerContextCount = flat.getLayerContextCount();
            layerCounts = flat.getLayerCounts();
            layerFeedCounts = flat.getLayerFeedCounts();
            layerIndex = flat.getLayerIndex();
            layerOutput = flat.getLayerOutput();
            layerSums = flat.getLayerSums();
            outputCount = flat.getOutputCount();
            weightIndex = flat.getWeightIndex();
            weights = flat.getWeights();
            activation = this.createActivations(flat);
            p = this.createParams(flat);
            neuronCount = flat.getLayerOutput().length;
            layerCount = flat.getLayerCounts().length;
        }
        this.setIndentLevel(2);
        this.indentIn();
        this.addNameValue("string EXPORT_FILENAME", "\"" + processFile.getName() + "\"");
        this.addNameValue("int _neuronCount", neuronCount);
        this.addNameValue("int _layerCount", layerCount);
        this.addNameValue("int _contextTargetOffset[]", contextTargetOffset);
        this.addNameValue("int _contextTargetSize[]", contextTargetSize);
        this.addNameValue("bool _hasContext", hasContext ? "true" : "false");
        this.addNameValue("int _inputCount", inputCount);
        this.addNameValue("int _layerContextCount[]", layerContextCount);
        this.addNameValue("int _layerCounts[]", layerCounts);
        this.addNameValue("int _layerFeedCounts[]", layerFeedCounts);
        this.addNameValue("int _layerIndex[]", layerIndex);
        this.addNameValue("double _layerOutput[]", layerOutput);
        this.addNameValue("double _layerSums[]", layerSums);
        this.addNameValue("int _outputCount", outputCount);
        this.addNameValue("int _weightIndex[]", weightIndex);
        this.addNameValue("double _weights[]", weights);
        this.addNameValue("int _activation[]", activation);
        this.addNameValue("double _p[]", p);
        this.indentOut();
        this.setIndentLevel(0);
    }

    private void processObtain() {
        this.setIndentLevel(3);
        this.addLine("FileWrite(iHandle, when,");
        DataField[] fields = this.getAnalyst().getScript().getFields();
        String lastLine = null;
        DataField[] dataFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            DataField field = dataFieldArray[n2];
            DataField df = field;
            if (!df.getName().equalsIgnoreCase("time") && !df.getName().equalsIgnoreCase("prediction")) {
                String str = EngineArray.replace(df.getSource(), "##", "pos");
                if (lastLine != null) {
                    this.addLine(String.valueOf(lastLine) + ",");
                }
                lastLine = str;
            }
            ++n2;
        }
        if (lastLine != null) {
            this.addLine(lastLine);
        }
        this.addLine(");");
        this.setIndentLevel(0);
    }

    @Override
    public void processToken(String command) {
        if (command.equalsIgnoreCase("MAIN-BLOCK")) {
            this.processMainBlock();
        } else if (command.equals("CALC")) {
            this.processCalc();
        } else if (command.equals("OBTAIN")) {
            this.processObtain();
        } else if (command.equals("HEADERS")) {
            this.processHeaders();
        }
        this.setIndentLevel(0);
    }
}

