/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class CSVHeaders {
    private final List<String> headerList = new ArrayList<String>();
    private final Map<String, Integer> columnMapping = new HashMap<String, Integer>();

    public static int parseTimeSlice(String name) {
        String[] values;
        int index1 = name.indexOf(40);
        if (index1 == -1) {
            return 0;
        }
        int index2 = name.indexOf(41);
        if (index2 == -1) {
            return 0;
        }
        if (index2 < index1) {
            return 0;
        }
        String list = name.substring(index1 + 1, index2);
        String[] stringArray = values = list.split(",");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            String str = value.trim();
            if (str.toLowerCase().startsWith("t")) {
                int slice = Integer.parseInt(str.substring(1));
                return slice;
            }
            ++n2;
        }
        return 0;
    }

    public static String tagColumn(String name, int part, int timeSlice, boolean multiPart) {
        StringBuilder result = new StringBuilder();
        result.append(name);
        if (multiPart || timeSlice != 0) {
            result.append('(');
            if (multiPart) {
                result.append('p');
                result.append(part);
            }
            if (timeSlice != 0) {
                if (multiPart) {
                    result.append(',');
                }
                result.append('t');
                if (timeSlice > 0) {
                    result.append('+');
                }
                result.append(timeSlice);
            }
            result.append(')');
        }
        return result.toString();
    }

    public CSVHeaders(File filename, boolean headers, CSVFormat format) {
        try (ReadCSV csv = null;){
            csv = new ReadCSV(filename.toString(), headers, format);
            if (csv.next()) {
                if (headers) {
                    for (String str : csv.getColumnNames()) {
                        this.headerList.add(str);
                    }
                } else {
                    int i = 0;
                    while (i < csv.getColumnCount()) {
                        this.headerList.add("field:" + (i + 1));
                        ++i;
                    }
                }
            }
            this.init();
        }
    }

    public CSVHeaders(List<String> inputHeadings) {
        for (String header : inputHeadings) {
            this.headerList.add(header);
        }
        this.init();
    }

    public CSVHeaders(String[] inputHeadings) {
        String[] stringArray = inputHeadings;
        int n = inputHeadings.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            this.headerList.add(header);
            ++n2;
        }
        this.init();
    }

    public int find(String name) {
        String key = name.toLowerCase();
        if (!this.columnMapping.containsKey(key)) {
            throw new AnalystError("Can't find column: " + name.toLowerCase());
        }
        return this.columnMapping.get(key);
    }

    public String getBaseHeader(int index) {
        String result = this.headerList.get(index);
        int loc = result.indexOf(40);
        if (loc != -1) {
            result = result.substring(0, loc);
        }
        return result.trim();
    }

    public String getHeader(int index) {
        return this.headerList.get(index);
    }

    public List<String> getHeaders() {
        return this.headerList;
    }

    public int getSlice(int currentIndex) {
        String[] values;
        String name = this.headerList.get(currentIndex);
        int index1 = name.indexOf(40);
        if (index1 == -1) {
            return 0;
        }
        int index2 = name.indexOf(41);
        if (index2 == -1) {
            return 0;
        }
        if (index2 < index1) {
            return 0;
        }
        String list = name.substring(index1 + 1, index2);
        String[] stringArray = values = list.split(",");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            String str = value.trim();
            if (str.toLowerCase().startsWith("t")) {
                str = value.trim().substring(1).trim();
                if (str.charAt(0) == '+') {
                    str = str.substring(1);
                }
                int slice = Integer.parseInt(str);
                return slice;
            }
            ++n2;
        }
        return 0;
    }

    private void init() {
        int index = 0;
        for (String str : this.headerList) {
            this.columnMapping.put(str.toLowerCase(), index++);
        }
        this.validateSameName();
    }

    public int size() {
        return this.headerList.size();
    }

    private void validateSameName() {
        int i = 0;
        while (i < this.headerList.size()) {
            int j = 0;
            while (j < this.headerList.size()) {
                if (i != j && this.headerList.get(i).equalsIgnoreCase(this.headerList.get(j))) {
                    throw new AnalystError("Multiple fields named: " + this.headerList.get(i));
                }
                ++j;
            }
            ++i;
        }
    }
}

