/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.ScriptLoad;
import org.encog.app.analyst.script.ScriptSave;
import org.encog.app.analyst.script.ml.ScriptOpcode;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.script.normalize.AnalystNormalize;
import org.encog.app.analyst.script.process.AnalystProcess;
import org.encog.app.analyst.script.prop.ScriptProperties;
import org.encog.app.analyst.script.segregate.AnalystSegregate;
import org.encog.app.analyst.script.task.AnalystTask;
import org.encog.app.analyst.util.FieldDirection;
import org.encog.util.arrayutil.ClassItem;
import org.encog.util.arrayutil.NormalizationAction;
import org.encog.util.csv.CSVFormat;

public class AnalystScript {
    public static final int DEFAULT_MAX_CLASS = 50;
    private DataField[] fields;
    private final AnalystNormalize normalize = new AnalystNormalize(this);
    private final AnalystSegregate segregate = new AnalystSegregate();
    private final AnalystProcess process = new AnalystProcess();
    private final Set<String> generated = new HashSet<String>();
    private final List<ScriptOpcode> opcodes = new ArrayList<ScriptOpcode>();
    private final Map<String, AnalystTask> tasks = new HashMap<String, AnalystTask>();
    private final ScriptProperties properties = new ScriptProperties();
    private String basePath;
    private transient double defaultNormalizedRangeLow = 0.0;
    private transient double defaultNormalizedRangeHigh = 1.0;

    public AnalystScript() {
        this.properties.setProperty("SETUP:CONFIG_csvFormat", AnalystFileFormat.DECPNT_COMMA);
        this.properties.setProperty("SETUP:CONFIG_maxClassCount", 50);
        this.properties.setProperty("SETUP:CONFIG_allowedClasses", "integer,string");
    }

    public void addTask(AnalystTask task) {
        this.tasks.put(task.getName(), task);
    }

    public void clearTasks() {
        this.tasks.clear();
    }

    public CSVFormat determineFormat() {
        return this.getProperties().getPropertyCSVFormat("SETUP:CONFIG_csvFormat");
    }

    public boolean expectInputHeaders(String filename) {
        if (this.isGenerated(filename)) {
            return true;
        }
        return this.properties.getPropertyBoolean("SETUP:CONFIG_inputHeaders");
    }

    public DataField findDataField(String name) {
        DataField[] dataFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            DataField dataField = dataFieldArray[n2];
            if (dataField.getName().equalsIgnoreCase(name)) {
                return dataField;
            }
            ++n2;
        }
        return null;
    }

    public int findDataFieldIndex(DataField df) {
        int result = 0;
        while (result < this.fields.length) {
            if (df == this.fields[result]) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public AnalystField findNormalizedField(String name, int slice) {
        for (AnalystField field : this.getNormalize().getNormalizedFields()) {
            if (!field.getName().equalsIgnoreCase(name) || field.getTimeSlice() != slice) continue;
            return field;
        }
        return null;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public DataField[] getFields() {
        return this.fields;
    }

    public AnalystNormalize getNormalize() {
        return this.normalize;
    }

    public int getPrecision() {
        return 10;
    }

    public ScriptProperties getProperties() {
        return this.properties;
    }

    public AnalystSegregate getSegregate() {
        return this.segregate;
    }

    public AnalystTask getTask(String name) {
        if (!this.tasks.containsKey(name)) {
            return null;
        }
        return this.tasks.get(name);
    }

    public Map<String, AnalystTask> getTasks() {
        return this.tasks;
    }

    public void init() {
        this.normalize.init(this);
    }

    public boolean isGenerated(String filename) {
        return this.generated.contains(filename);
    }

    public void load(InputStream stream) {
        ScriptLoad s = new ScriptLoad(this);
        s.load(stream);
    }

    public void markGenerated(String filename) {
        this.generated.add(filename);
    }

    public File resolveFilename(String sourceID) {
        String name = this.getProperties().getFilename(sourceID);
        if (new File(name).getParent() == null && this.basePath != null) {
            return new File(this.basePath, name);
        }
        return new File(name);
    }

    public void save(OutputStream stream) {
        ScriptSave s = new ScriptSave(this);
        s.save(stream);
    }

    public void setBasePath(String theBasePath) {
        this.basePath = theBasePath;
    }

    public void setFields(DataField[] theFields) {
        this.fields = theFields;
    }

    public AnalystField findAnalystField(String fieldName) {
        for (AnalystField field : this.normalize.getNormalizedFields()) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }

    public AnalystProcess getProcess() {
        return this.process;
    }

    public List<ScriptOpcode> getOpcodes() {
        return this.opcodes;
    }

    public boolean hasClasses() {
        for (AnalystField field : this.getNormalize().getNormalizedFields()) {
            DataField df;
            if (field.getAction() == NormalizationAction.Ignore || !(df = this.findDataField(field.getName())).isClass()) continue;
            return true;
        }
        return false;
    }

    public AnalystField defineField(String fieldName, FieldDirection d, NormalizationAction action, double theActualHigh, double theActualLow) {
        AnalystField field = new AnalystField();
        if (action == NormalizationAction.Equilateral || action == NormalizationAction.OneOf) {
            throw new AnalystError("Must use defineClass if you are going to use Equilateral or OneOf");
        }
        DataField df = new DataField(fieldName);
        df.setMax(theActualHigh);
        df.setMin(theActualLow);
        df.setReal(true);
        df.setClass(false);
        df.setMean(theActualLow + (theActualHigh - theActualLow) / 2.0);
        if (this.getFields() == null) {
            this.setFields(new DataField[]{df});
        } else {
            int len = this.getFields().length;
            DataField[] added = Arrays.copyOf(this.getFields(), len + 1);
            added[len] = df;
            this.setFields(added);
        }
        field.setAction(action);
        field.setNormalizedHigh(this.defaultNormalizedRangeHigh);
        field.setNormalizedLow(this.defaultNormalizedRangeLow);
        field.setActualHigh(theActualHigh);
        field.setActualLow(theActualLow);
        field.setName(fieldName);
        field.setOutput(d == FieldDirection.Output || d == FieldDirection.InputOutput);
        this.getNormalize().getNormalizedFields().add(field);
        return field;
    }

    public void setDefaultNormalizedRange(double low, double high) {
        this.defaultNormalizedRangeLow = low;
        this.defaultNormalizedRangeHigh = high;
    }

    public AnalystField defineClass(String fieldName, FieldDirection d, NormalizationAction action, List<ClassItem> classes) {
        AnalystField field = new AnalystField();
        if (action != NormalizationAction.Equilateral && action != NormalizationAction.OneOf) {
            throw new AnalystError("defineClass can only be used with action type of Equilateral or OneOf");
        }
        field.setAction(action);
        field.setNormalizedHigh(this.defaultNormalizedRangeHigh);
        field.setNormalizedLow(this.defaultNormalizedRangeLow);
        field.setActualHigh(0.0);
        field.setActualLow(0.0);
        field.setName(fieldName);
        field.setOutput(d == FieldDirection.Output || d == FieldDirection.InputOutput);
        field.getClasses().addAll(classes);
        this.getNormalize().getNormalizedFields().add(field);
        return field;
    }
}

