/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.sort;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.csv.sort.RowComparator;
import org.encog.app.analyst.csv.sort.SortedField;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class SortCSV
extends BasicFile {
    private final List<LoadedRow> data = new ArrayList<LoadedRow>();
    private final List<SortedField> sortOrder = new ArrayList<SortedField>();

    public List<SortedField> getSortOrder() {
        return this.sortOrder;
    }

    public void process(File inputFile, File outputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.readInputFile();
        this.sortData();
        this.writeOutputFile(outputFile);
    }

    private void readInputFile() {
        this.resetStatus();
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
        while (csv.next() && !this.shouldStop()) {
            this.updateStatus("Reading input file");
            LoadedRow row = new LoadedRow(csv);
            this.data.add(row);
        }
        this.setColumnCount(csv.getColumnCount());
        if (this.isExpectInputHeaders()) {
            this.setInputHeadings(new String[csv.getColumnNames().size()]);
            int i = 0;
            while (i < csv.getColumnNames().size()) {
                this.getInputHeadings()[i] = csv.getColumnNames().get(i);
                ++i;
            }
        }
        csv.close();
    }

    private void sortData() {
        RowComparator comp = new RowComparator(this);
        Collections.sort(this.data, comp);
    }

    private void writeOutputFile(File outputFile) {
        PrintWriter tw = this.prepareOutputFile(outputFile);
        boolean[] nonNumeric = new boolean[this.getColumnCount()];
        boolean first = true;
        this.resetStatus();
        for (LoadedRow row : this.data) {
            this.updateStatus("Writing output");
            if (first) {
                int i = 0;
                while (i < this.getColumnCount()) {
                    try {
                        String str = row.getData()[i];
                        Double.parseDouble(str);
                        nonNumeric[i] = false;
                    }
                    catch (Exception ex) {
                        nonNumeric[i] = true;
                    }
                    ++i;
                }
                first = false;
            }
            StringBuilder line = new StringBuilder();
            int i = 0;
            while (i < this.getColumnCount()) {
                if (i > 0) {
                    line.append(",");
                }
                if (nonNumeric[i]) {
                    line.append("\"");
                    line.append(row.getData()[i]);
                    line.append("\"");
                } else {
                    line.append(row.getData()[i]);
                }
                ++i;
            }
            tw.println(line.toString());
        }
        this.reportDone("Writing output");
        tw.close();
    }
}

