/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.normalize;

import java.io.File;
import org.encog.EncogError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.TimeSeriesUtil;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.normalize.AnalystNormalizeCSV;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.logging.EncogLogging;

public class AnalystNormalizeToEGB
extends BasicFile {
    private EncogAnalyst analyst;
    private TimeSeriesUtil series;
    private CSVHeaders analystHeaders;

    public void analyze(File inputFilename, boolean expectInputHeaders, CSVFormat inputFormat, EncogAnalyst theAnalyst) {
        this.setInputFilename(inputFilename);
        this.setInputFormat(inputFormat);
        this.setExpectInputHeaders(expectInputHeaders);
        this.analyst = theAnalyst;
        this.setAnalyzed(true);
        this.analystHeaders = new CSVHeaders(inputFilename, expectInputHeaders, inputFormat);
        for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            field.init();
        }
        this.series = new TimeSeriesUtil(this.analyst, true, this.analystHeaders.getHeaders());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void normalize(File file) {
        if (this.analyst == null) {
            throw new EncogError("Can't normalize yet, file has not been analyzed.");
        }
        int inputCount = this.analyst.getScript().getNormalize().calculateInputColumns();
        int idealCount = this.analyst.getScript().getNormalize().calculateOutputColumns();
        BasicMLData inputData = new BasicMLData(inputCount);
        BasicMLData idealData = new BasicMLData(idealCount);
        ReadCSV csv = null;
        BufferedMLDataSet buffer = new BufferedMLDataSet(file);
        buffer.beginLoad(inputCount, idealCount);
        try {
            block21: {
                int outputLength;
                block20: {
                    csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
                    this.resetStatus();
                    outputLength = this.analyst.determineTotalColumns();
                    if (!true) break block20;
                    if (!csv.next()) return;
                    if (this.shouldStop()) break block21;
                }
                do {
                    this.updateStatus(false);
                    double[] output = AnalystNormalizeCSV.extractFields(this.analyst, this.analystHeaders, csv, outputLength, false);
                    if (this.series.getTotalDepth() > 1) {
                        output = this.series.process(output);
                    }
                    int idx = 0;
                    int i = 0;
                    while (i < inputData.size()) {
                        inputData.setData(i, output[idx++]);
                        ++i;
                    }
                    i = 0;
                    while (i < idealData.size()) {
                        idealData.setData(i, output[idx++]);
                        ++i;
                    }
                    if (output != null) {
                        buffer.add(inputData, idealData);
                    }
                    if (!csv.next()) return;
                } while (!this.shouldStop());
            }
            return;
        }
        finally {
            this.reportDone(false);
            if (csv != null) {
                try {
                    csv.close();
                }
                catch (Exception ex) {
                    EncogLogging.log(ex);
                }
            }
            if (buffer != null) {
                try {
                    buffer.endLoad();
                }
                catch (Exception ex) {
                    EncogLogging.log(ex);
                }
            }
        }
    }

    public void setSourceFile(File file, boolean headers, CSVFormat format) {
        this.setInputFilename(file);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
    }
}

