/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.csv.process.AnalystProcess;
import org.encog.app.analyst.util.AnalystReportBridge;
import org.encog.util.csv.CSVFormat;
import org.encog.util.logging.EncogLogging;

public class CmdProcess
extends Cmd {
    public static final String COMMAND_NAME = "PROCESS";

    public CmdProcess(EncogAnalyst analyst) {
        super(analyst);
    }

    @Override
    public boolean executeCommand(String args) {
        String sourceID = this.getProp().getPropertyString("PROCESS:CONFIG_sourceFile");
        String targetID = this.getProp().getPropertyString("PROCESS:CONFIG_targetFile");
        int forwardSize = this.getProp().getPropertyInt("PROCESS:CONFIG_forwardSize");
        int backwardSize = this.getProp().getPropertyInt("PROCESS:CONFIG_backwardSize");
        EncogLogging.log(0, "Beginning randomize");
        EncogLogging.log(0, "source file:" + sourceID);
        EncogLogging.log(0, "target file:" + targetID);
        File sourceFile = this.getScript().resolveFilename(sourceID);
        File targetFile = this.getScript().resolveFilename(targetID);
        CSVFormat format = this.getScript().determineFormat();
        this.getScript().markGenerated(targetID);
        AnalystProcess process = new AnalystProcess(this.getAnalyst(), backwardSize, forwardSize);
        process.setScript(this.getScript());
        this.getAnalyst().setCurrentQuantTask(process);
        process.setReport(new AnalystReportBridge(this.getAnalyst()));
        boolean headers = this.getScript().expectInputHeaders(sourceID);
        process.analyze(sourceFile, headers, format);
        process.process(targetFile);
        this.getAnalyst().setCurrentQuantTask(null);
        return process.shouldStop();
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }
}

