/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.csv.normalize.AnalystNormalizeCSV;
import org.encog.app.analyst.util.AnalystReportBridge;
import org.encog.util.csv.CSVFormat;
import org.encog.util.logging.EncogLogging;

public class CmdNormalize
extends Cmd {
    public static final String COMMAND_NAME = "NORMALIZE";

    public CmdNormalize(EncogAnalyst theAnalyst) {
        super(theAnalyst);
    }

    @Override
    public boolean executeCommand(String args) {
        String sourceID = this.getProp().getPropertyString("NORMALIZE:CONFIG_sourceFile");
        String targetID = this.getProp().getPropertyString("NORMALIZE:CONFIG_targetFile");
        File sourceFile = this.getScript().resolveFilename(sourceID);
        File targetFile = this.getScript().resolveFilename(targetID);
        EncogLogging.log(0, "Beginning normalize");
        EncogLogging.log(0, "source file:" + sourceID);
        EncogLogging.log(0, "target file:" + targetID);
        this.getScript().markGenerated(targetID);
        CSVFormat format = this.getScript().determineFormat();
        AnalystNormalizeCSV norm = new AnalystNormalizeCSV();
        norm.setScript(this.getScript());
        this.getAnalyst().setCurrentQuantTask(norm);
        norm.setReport(new AnalystReportBridge(this.getAnalyst()));
        boolean headers = this.getScript().expectInputHeaders(sourceID);
        norm.analyze(sourceFile, headers, format, this.getAnalyst());
        norm.setProduceOutputHeaders(true);
        norm.normalize(targetFile);
        this.getAnalyst().setCurrentQuantTask(null);
        return norm.shouldStop();
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }
}

