/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.analyze;

import java.util.List;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.analyze.AnalyzedField;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.app.analyst.util.ConvertStringConst;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class PerformAnalysis {
    private final String filename;
    private final boolean headers;
    private final AnalystFileFormat format;
    private AnalyzedField[] fields;
    private final AnalystScript script;

    public PerformAnalysis(AnalystScript theScript, String theFilename, boolean theHeaders, AnalystFileFormat theFormat) {
        this.filename = theFilename;
        this.headers = theHeaders;
        this.format = theFormat;
        this.script = theScript;
    }

    private void generateFields(ReadCSV csv) {
        if (this.headers) {
            this.generateFieldsFromHeaders(csv);
        } else {
            this.generateFieldsFromCount(csv);
        }
    }

    private void generateFieldsFromCount(ReadCSV csv) {
        this.fields = new AnalyzedField[csv.getColumnCount()];
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i] = new AnalyzedField(this.script, "field:" + (i + 1));
            ++i;
        }
    }

    private void generateFieldsFromHeaders(ReadCSV csv) {
        CSVHeaders h = new CSVHeaders(csv.getColumnNames());
        this.fields = new AnalyzedField[csv.getColumnCount()];
        int i = 0;
        while (i < this.fields.length) {
            if (i >= csv.getColumnNames().size()) {
                throw new AnalystError("CSV header count does not match column count");
            }
            this.fields[i] = new AnalyzedField(this.script, h.getHeader(i));
            ++i;
        }
    }

    public void process(EncogAnalyst target) {
        int count = 0;
        CSVFormat csvFormat = ConvertStringConst.convertToCSVFormat(this.format);
        ReadCSV csv = new ReadCSV(this.filename, this.headers, csvFormat);
        while (csv.next()) {
            if (this.fields == null) {
                this.generateFields(csv);
            }
            int i = 0;
            while (i < csv.getColumnCount()) {
                this.fields[i].analyze1(csv.get(i));
                ++i;
            }
            ++count;
        }
        if (count == 0) {
            throw new AnalystError("Can't analyze file, it is empty.");
        }
        AnalyzedField[] analyzedFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            AnalyzedField field = analyzedFieldArray[n2];
            field.completePass1();
            ++n2;
        }
        csv.close();
        csv = new ReadCSV(this.filename, this.headers, csvFormat);
        while (csv.next()) {
            int i = 0;
            while (i < csv.getColumnCount()) {
                this.fields[i].analyze2(csv.get(i));
                ++i;
            }
        }
        analyzedFieldArray = this.fields;
        n = this.fields.length;
        n2 = 0;
        while (n2 < n) {
            AnalyzedField field = analyzedFieldArray[n2];
            field.completePass2();
            ++n2;
        }
        csv.close();
        String str = this.script.getProperties().getPropertyString("SETUP:CONFIG_allowedClasses");
        if (str == null) {
            str = "";
        }
        boolean allowInt = str.contains("int");
        boolean allowReal = str.contains("real") || str.contains("double");
        boolean allowString = str.contains("string");
        AnalyzedField[] analyzedFieldArray2 = this.fields;
        int n3 = this.fields.length;
        int n4 = 0;
        while (n4 < n3) {
            AnalyzedField field = analyzedFieldArray2[n4];
            if (field.isClass()) {
                if (!allowInt && field.isInteger()) {
                    field.setClass(false);
                }
                if (!(allowString || field.isInteger() || field.isReal())) {
                    field.setClass(false);
                }
                if (!allowReal && field.isReal() && !field.isInteger()) {
                    field.setClass(false);
                }
            }
            ++n4;
        }
        if (target.getScript().getFields() != null && this.fields.length == target.getScript().getFields().length) {
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i].setName(target.getScript().getFields()[i].getName());
                this.fields[i].setSource(target.getScript().getFields()[i].getSource());
                if (this.fields[i].isClass()) {
                    List<AnalystClassItem> t = this.fields[i].getAnalyzedClassMembers();
                    List<AnalystClassItem> s = target.getScript().getFields()[i].getClassMembers();
                    if (s.size() == t.size()) {
                        int j = 0;
                        while (j < s.size()) {
                            if (t.get(j).getCode().equals(s.get(j).getCode())) {
                                t.get(j).setName(s.get(j).getName());
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        DataField[] df = new DataField[this.fields.length];
        int i = 0;
        while (i < df.length) {
            df[i] = this.fields[i].finalizeField();
            ++i;
        }
        target.getScript().setFields(df);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" filename=");
        result.append(this.filename);
        result.append(", headers=");
        result.append(this.headers);
        result.append("]");
        return result.toString();
    }
}

