/*
 * Decompiled with CFR 0.152.
 */
package org.encog;

import org.encog.Encog;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.training.propagation.sgd.StochasticGradientDescent;
import org.encog.neural.networks.training.propagation.sgd.update.RMSPropUpdate;

public class Test {
    public static double[][] XOR_INPUT = new double[][]{{0.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}, {1.0, 1.0}};
    public static double[][] XOR_IDEAL = new double[][]{{0.0}, {1.0}, {1.0}, {0.0}};

    public static void main(String[] args) {
        BasicNetwork network = new BasicNetwork();
        network.addLayer(new BasicLayer(null, true, 2));
        network.addLayer(new BasicLayer((ActivationFunction)new ActivationSigmoid(), true, 3));
        network.addLayer(new BasicLayer((ActivationFunction)new ActivationSigmoid(), false, 1));
        network.getStructure().finalizeStructure();
        network.reset();
        BasicMLDataSet trainingSet = new BasicMLDataSet(XOR_INPUT, XOR_IDEAL);
        StochasticGradientDescent train = new StochasticGradientDescent(network, trainingSet);
        train.setUpdateRule(new RMSPropUpdate());
        int epoch = 1;
        do {
            train.iteration();
            System.out.println("Epoch #" + epoch + " Error:" + train.getError());
            ++epoch;
        } while (train.getError() > 0.01);
        train.finishTraining();
        System.out.println("Neural Network Results:");
        for (MLDataPair pair : trainingSet) {
            MLData output = network.compute(pair.getInput());
            System.out.println(String.valueOf(pair.getInput().getData(0)) + "," + pair.getInput().getData(1) + ", actual=" + output.getData(0) + ",ideal=" + pair.getIdeal().getData(0));
        }
        Encog.getInstance().shutdown();
    }
}

