/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sort;

import java.util.Random;

public class Select {
    private static Random random = new Random(System.currentTimeMillis());

    public static int randomizedSelect(int[] a, int i) {
        int p = 0;
        int r = a.length - 1;
        while (p != r) {
            int q = Select.randomizedPartition(a, p, r);
            int k = q - p + 1;
            if (i == k - 1) {
                return a[q];
            }
            if (i < k) {
                r = q - 1;
                continue;
            }
            i -= k;
            p = q + 1;
        }
        return a[p];
    }

    private static int randomizedPartition(int[] a, int p, int r) {
        int i = 0;
        i = p < r ? p + random.nextInt(r - p) : r + random.nextInt(p - r);
        Select.swap(a, r, i);
        return Select.partition(a, p, r);
    }

    private static int partition(int[] a, int p, int r) {
        int x = a[r];
        int i = p - 1;
        for (int j = p; j <= r - 1; ++j) {
            if (a[j] > x) continue;
            Select.swap(a, ++i, j);
        }
        Select.swap(a, i + 1, r);
        return i + 1;
    }

    private static void swap(int[] array, int i, int j) {
        int valueI = array[i];
        array[i] = array[j];
        array[j] = valueI;
    }
}

