/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Itemset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class Sequence {
    private int numberOfItems = 0;
    private final List<Itemset> itemsets = new ArrayList<Itemset>();
    private int id;

    public Sequence(int id) {
        this.id = id;
    }

    public void addItemset(Itemset itemset) {
        this.itemsets.add(itemset);
        this.numberOfItems += itemset.size();
    }

    public void addItem(Item item) {
        this.itemsets.get(this.size() - 1).addItem(item);
        ++this.numberOfItems;
    }

    public void addItem(int indexItemset, Item item) {
        this.itemsets.get(indexItemset).addItem(item);
        ++this.numberOfItems;
    }

    public void addItem(int indexItemset, int indexItem, Item item) {
        this.itemsets.get(indexItemset).addItem(indexItem, item);
        ++this.numberOfItems;
    }

    public Itemset remove(int indexItemset) {
        Itemset itemset = this.itemsets.remove(indexItemset);
        this.numberOfItems -= itemset.size();
        return itemset;
    }

    public Item remove(int indexItemset, int indexItem) {
        --this.numberOfItems;
        return this.itemsets.get(indexItem).removeItem(indexItem);
    }

    public void remove(int indexItemset, Item item) {
        this.itemsets.get(indexItemset).removeItem(item);
        --this.numberOfItems;
    }

    public Sequence cloneSequence() {
        Sequence sequence = new Sequence(this.getId());
        for (Itemset itemset : this.itemsets) {
            sequence.addItemset(itemset.cloneItemset());
        }
        return sequence;
    }

    public String toString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset : this.itemsets) {
            r.append("{t=");
            r.append(itemset.getTimestamp());
            r.append(", ");
            for (Item item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append('}');
        }
        return r.append("    ").toString();
    }

    public int getId() {
        return this.id;
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    public Itemset get(int index) {
        return this.itemsets.get(index);
    }

    public int size() {
        return this.itemsets.size();
    }

    public int length() {
        return this.numberOfItems;
    }

    public long getTimeLength() {
        return this.itemsets.get(this.itemsets.size() - 1).getTimestamp() - this.itemsets.get(0).getTimestamp();
    }

    public Sequence cloneSequenceMinusItems(Map<Item, BitSet> mapSequenceID, double relativeMinSup) {
        Sequence sequence = new Sequence(this.getId());
        for (Itemset itemset : this.itemsets) {
            Itemset newItemset = itemset.cloneItemSetMinusItems(mapSequenceID);
            if (newItemset.size() == 0) continue;
            sequence.addItemset(newItemset);
        }
        return sequence;
    }

    public void setID(int id) {
        this.id = id;
    }
}

