/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.CandidateInSequenceFinder;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.patterns.Pattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SupportCounting {
    private SequenceDatabase database;
    private Map<Item, Set<Pattern>> indexationMap;
    private AbstractionCreator abstractionCreator;

    public SupportCounting(SequenceDatabase database, AbstractionCreator creador) {
        this.database = database;
        this.abstractionCreator = creador;
        this.indexationMap = new HashMap<Item, Set<Pattern>>();
    }

    public Set<Pattern> countSupport(List<Pattern> candidateSet, int k, double minSupportAbsolute) {
        this.indexationMap.clear();
        for (Sequence sequence : this.database.getSequences()) {
            this.checkCandidateInSequence(sequence, k, candidateSet);
        }
        LinkedHashSet<Pattern> result = new LinkedHashSet<Pattern>();
        for (Pattern candidate : candidateSet) {
            if (!(candidate.getSupport() >= minSupportAbsolute)) continue;
            result.add(candidate);
            this.putInIndexationMap(candidate);
        }
        candidateSet = null;
        return result;
    }

    private void checkCandidateInSequence(Sequence sequence, int k, List<Pattern> candidateSet) {
        for (Pattern candidate : candidateSet) {
            ArrayList<int[]> position = new ArrayList<int[]>(k);
            for (int i = 0; i < k; ++i) {
                position.add(new int[]{0, 0});
            }
            CandidateInSequenceFinder finder = new CandidateInSequenceFinder(this.abstractionCreator);
            this.abstractionCreator.isCandidateInSequence(finder, candidate, sequence, k, 0, position);
            if (!finder.isPresent()) continue;
            candidate.addAppearance(sequence.getId());
        }
    }

    private void putInIndexationMap(Pattern entry) {
        ItemAbstractionPair pair = entry.getIthElement(0);
        Set<Pattern> correspondence = this.indexationMap.get(pair.getItem());
        if (correspondence == null) {
            correspondence = new LinkedHashSet<Pattern>();
            this.indexationMap.put(pair.getItem(), correspondence);
        }
        correspondence.add(entry);
    }

    public Map<Item, Set<Pattern>> getIndexationMap() {
        return this.indexationMap;
    }
}

