/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp;

import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.Event;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.MyPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.SignTest;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class AlgoGoKrimp {
    ArrayList<Integer> characters;
    ArrayList<ArrayList<Event>> data;
    ArrayList<MyPattern> patterns;
    ArrayList<MyPattern> candidates;
    HashMap<Integer, String> labels;
    HashMap<Integer, ArrayList<Integer>> related_events;
    ArrayList<Integer> classlabels;
    int Nword;
    double comp_size;
    double uncomp_size;
    static final int NSTART = 1000;
    static final int NRELATED = 1000;
    BufferedWriter writer;

    public void gokrimp() throws IOException {
        long startTime = System.currentTimeMillis();
        this.initialization();
        ArrayList<MyPattern> ie = this.get_Initial_Patterns();
        MyPattern maxp = new MyPattern();
        while (true) {
            double max = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < ie.size(); ++i) {
                MyPattern mp;
                MyPattern prev = mp = ie.get(i);
                while ((mp = this.extend(mp)) != null) {
                    prev = mp;
                }
                if (!(prev.ben > max)) continue;
                maxp = prev;
                max = prev.ben;
            }
            if (max <= 0.0) break;
            this.addPattern(maxp);
            this.printMyPattern(maxp);
            this.remove(maxp);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        System.out.println("Compressed size: " + this.comp_size + ", uncompressed size: " + this.uncomp_size + ", compression ratio: " + this.uncomp_size / (0.0 + this.comp_size));
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        System.out.println("Running time: " + totalTime / 1000L + " seconds");
    }

    public void seqkrimp() throws IOException {
        MyPattern maxp = new MyPattern();
        block2: while (true) {
            double max = Double.NEGATIVE_INFINITY;
            int mi = this.getBestPattern();
            if (this.candidates.get((int)mi).ben > max) {
                maxp = new MyPattern(this.candidates.get(mi));
                max = this.candidates.get((int)mi).ben;
            }
            if (max <= 0.0) break;
            this.addPattern(maxp);
            this.printMyPattern(maxp);
            this.remove(maxp);
            this.candidates.remove(mi);
            int i = 0;
            while (true) {
                if (i >= this.candidates.size()) continue block2;
                this.candidates.get((int)i).ben = 0.0;
                this.candidates.get((int)i).freq = 0;
                this.candidates.get((int)i).g_cost = 0;
                ++i;
            }
            break;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Compressed size: " + this.comp_size + ", uncompressed size: " + this.uncomp_size + ", compression ratio: " + this.uncomp_size / (0.0 + this.comp_size));
    }

    void initialization() {
        int i;
        this.patterns = new ArrayList();
        this.candidates = new ArrayList();
        this.related_events = new HashMap();
        this.Nword = 0;
        this.comp_size = 0.0;
        this.characters = new ArrayList();
        for (i = 0; i < this.data.size(); ++i) {
            for (int j = 0; j < this.data.get(i).size(); ++j) {
                if (this.data.get((int)i).get((int)j).id >= this.characters.size()) {
                    for (int ii = this.characters.size(); ii < this.data.get((int)i).get((int)j).id + 1; ++ii) {
                        this.characters.add(new Integer(0));
                    }
                }
                this.characters.set(this.data.get((int)i).get((int)j).id, this.characters.get(this.data.get((int)i).get((int)j).id) + 1);
            }
            this.Nword += this.data.get(i).size();
        }
        this.Nword += 2 * this.characters.size();
        for (i = 0; i < this.characters.size(); ++i) {
            MyPattern mp = new MyPattern();
            mp.ids.add(i);
            mp.ben = 0.0;
            mp.freq = this.characters.get(i) + 2;
            mp.g_cost = 0;
            this.patterns.add(mp);
            this.comp_size += (double)mp.freq * Math.log(this.Nword) / Math.log(2.0) - (double)mp.freq * Math.log(mp.freq) / Math.log(2.0);
            this.characters.set(i, this.patterns.size() - 1);
        }
        this.uncomp_size = this.comp_size;
        for (i = 0; i < this.data.size(); ++i) {
            Iterator<Event> it = this.data.get(i).iterator();
            while (it.hasNext()) {
                if (this.patterns.get((int)this.characters.get((int)it.next().id).intValue()).freq >= 25) continue;
                it.remove();
            }
        }
    }

    void addPattern(MyPattern pattern) {
        this.Nword = this.Nword - (pattern.freq - 1) * pattern.ids.size() + pattern.ids.size() + pattern.freq;
        this.comp_size -= pattern.ben;
        HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
        for (int j = 0; j < pattern.ids.size(); ++j) {
            if (!hm.containsKey(pattern.ids.get(j))) {
                hm.put(pattern.ids.get(j), 1);
                continue;
            }
            hm.put(pattern.ids.get(j), (Integer)hm.get(pattern.ids.get(j)) + 1);
        }
        for (int i = 0; i < this.patterns.size(); ++i) {
            if (this.patterns.get((int)i).ids.size() != 1 || !hm.containsKey(this.patterns.get((int)i).ids.get(0))) continue;
            this.patterns.get((int)i).freq -= (pattern.freq - 1) * (Integer)hm.get(this.patterns.get((int)i).ids.get(0));
            this.patterns.get((int)i).freq += ((Integer)hm.get(this.patterns.get((int)i).ids.get(0))).intValue();
        }
        this.patterns.add(pattern);
    }

    MyPattern extend(MyPattern pattern) {
        ArrayList<Integer> ve = this.get_Extending_Events_SignTest(pattern.ids.get(pattern.ids.size() - 1));
        this.candidates.clear();
        for (int i = 0; i < ve.size(); ++i) {
            MyPattern can = new MyPattern();
            can.g_cost = 0;
            can.freq = 0;
            can.ben = 0.0;
            can.ids = new ArrayList<Integer>(pattern.ids);
            can.ids.add(ve.get(i));
            this.candidates.add(can);
        }
        if (this.candidates.isEmpty()) {
            return null;
        }
        int best = this.getBestPattern();
        if (this.candidates.get((int)best).ben > pattern.ben) {
            return this.candidates.get(best);
        }
        return null;
    }

    ArrayList<MyPattern> get_Initial_Patterns() {
        int i;
        ArrayList<MyPattern> ie = new ArrayList<MyPattern>();
        for (i = 0; i < this.patterns.size(); ++i) {
            if (this.patterns.get((int)i).freq < 25) continue;
            ie.add(new MyPattern(this.patterns.get(i)));
        }
        for (i = 0; i < ie.size(); ++i) {
            ((MyPattern)ie.get((int)i)).ben = ((MyPattern)ie.get((int)i)).freq;
        }
        Collections.sort(ie);
        while (ie.size() > 1000) {
            ie.remove(ie.size() - 1);
        }
        for (i = 0; i < ie.size(); ++i) {
            ie.get((int)i).ben = 0.0;
        }
        return ie;
    }

    ArrayList<Integer> get_Extending_Events_SignTest(Integer e) {
        if (this.related_events.containsKey(e)) {
            return this.related_events.get(e);
        }
        ArrayList<Integer> ve = this.getRelatedEvents(e);
        this.related_events.put(e, ve);
        return ve;
    }

    int getBestPattern() {
        int index = 0;
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.candidates.size(); ++i) {
            for (int j = 0; j < this.data.size(); ++j) {
                int k;
                HashMap<Integer, ArrayList> hm = new HashMap<Integer, ArrayList>();
                ArrayList<ArrayList<Integer>> pos = new ArrayList<ArrayList<Integer>>();
                for (k = 0; k < this.candidates.get((int)i).ids.size(); ++k) {
                    ArrayList a;
                    if (!hm.containsKey(this.candidates.get((int)i).ids.get(k))) {
                        a = new ArrayList();
                        a.add(k);
                        hm.put(this.candidates.get((int)i).ids.get(k), a);
                    } else {
                        a = (ArrayList)hm.get(this.candidates.get((int)i).ids.get(k));
                        a.add(k);
                        hm.put(this.candidates.get((int)i).ids.get(k), a);
                    }
                    pos.add(new ArrayList());
                }
                for (k = 0; k < this.data.get(j).size(); ++k) {
                    if (!hm.containsKey(this.data.get((int)j).get((int)k).id)) continue;
                    for (int l = 0; l < ((ArrayList)hm.get(this.data.get((int)j).get((int)k).id)).size(); ++l) {
                        pos.get((Integer)((ArrayList)hm.get(this.data.get((int)j).get((int)k).id)).get(l)).add(this.data.get((int)j).get((int)k).ts);
                    }
                }
                ArrayList<ArrayList<Integer>> matches = this.getBestMatches(pos);
                this.candidates.get((int)i).freq += matches.size();
                this.candidates.get((int)i).g_cost += this.gap_cost(matches);
            }
            if (this.candidates.get((int)i).freq == 0) continue;
            ++this.candidates.get((int)i).freq;
            double com = this.get_Compress_Size_When_Adding(this.candidates.get(i));
            if (!(com < min)) continue;
            min = com;
            index = i;
        }
        this.candidates.get((int)index).ben = this.comp_size - min;
        return index;
    }

    void remove(MyPattern pattern) {
        for (int j = 0; j < this.data.size(); ++j) {
            int k;
            HashMap<Integer, ArrayList> hm = new HashMap<Integer, ArrayList>();
            ArrayList<ArrayList<Integer>> pos = new ArrayList<ArrayList<Integer>>();
            for (k = 0; k < pattern.ids.size(); ++k) {
                ArrayList a;
                if (!hm.containsKey(pattern.ids.get(k))) {
                    a = new ArrayList();
                    a.add(k);
                    hm.put(pattern.ids.get(k), a);
                } else {
                    a = (ArrayList)hm.get(pattern.ids.get(k));
                    a.add(k);
                    hm.put(pattern.ids.get(k), a);
                }
                pos.add(new ArrayList());
            }
            for (k = 0; k < this.data.get(j).size(); ++k) {
                if (!hm.containsKey(this.data.get((int)j).get((int)k).id)) continue;
                for (int l = 0; l < ((ArrayList)hm.get(this.data.get((int)j).get((int)k).id)).size(); ++l) {
                    pos.get((Integer)((ArrayList)hm.get(this.data.get((int)j).get((int)k).id)).get(l)).add(this.data.get((int)j).get((int)k).ts);
                }
            }
            ArrayList<ArrayList<Integer>> matches = this.getBestMatches(pos);
            this.remove(matches, j);
        }
    }

    double get_Compress_Size_When_Adding(MyPattern pattern) {
        int new_Nword = this.Nword - (pattern.freq - 1) * pattern.ids.size() + pattern.ids.size() + pattern.freq;
        double com = this.comp_size;
        com += (double)new_Nword * Math.log(new_Nword) / Math.log(2.0) - (double)this.Nword * Math.log(this.Nword) / Math.log(2.0) - (double)pattern.freq * Math.log(pattern.freq) / Math.log(2.0);
        HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
        for (int i = 0; i < pattern.ids.size(); ++i) {
            if (!hm.containsKey(pattern.ids.get(i))) {
                hm.put(pattern.ids.get(i), 1);
                continue;
            }
            hm.put(pattern.ids.get(i), (Integer)hm.get(pattern.ids.get(i)) + 1);
        }
        for (Integer key : hm.keySet()) {
            int new_freq = this.patterns.get((int)this.characters.get((int)key.intValue()).intValue()).freq - (Integer)hm.get(key) * pattern.freq + 2 * (Integer)hm.get(key);
            com -= (double)new_freq * Math.log(new_freq) / Math.log(2.0) - (double)this.patterns.get((int)this.characters.get((int)key.intValue()).intValue()).freq * Math.log(this.patterns.get((int)this.characters.get((int)key.intValue()).intValue()).freq) / Math.log(2.0);
        }
        return com += (double)pattern.g_cost;
    }

    ArrayList<ArrayList<Integer>> getBestMatches(ArrayList<ArrayList<Integer>> pos) {
        ArrayList<ArrayList<Integer>> matches = new ArrayList<ArrayList<Integer>>();
        block0: while (true) {
            int i;
            int i2;
            ArrayList matrix = new ArrayList();
            for (i2 = 0; i2 < pos.size(); ++i2) {
                matrix.add(new ArrayList());
            }
            for (i2 = 0; i2 < pos.size(); ++i2) {
                int j;
                if (i2 == 0) {
                    for (j = 0; j < pos.get(0).size(); ++j) {
                        Event ww = new Event();
                        ww.ts = 0;
                        ww.id = pos.get(0).get(j);
                        ww.gap = 0;
                        ((ArrayList)matrix.get(0)).add(ww);
                    }
                    continue;
                }
                for (j = 0; j < pos.get(i2).size(); ++j) {
                    int index = 0;
                    int min = Integer.MAX_VALUE;
                    int mini = 0;
                    while (index < ((ArrayList)matrix.get(i2 - 1)).size() && ((Event)((ArrayList)matrix.get((int)(i2 - 1))).get((int)index)).id < pos.get(i2).get(j)) {
                        if (((Event)((ArrayList)matrix.get((int)(i2 - 1))).get((int)index)).ts == Integer.MAX_VALUE) {
                            ++index;
                            continue;
                        }
                        int g = ((Event)((ArrayList)matrix.get((int)(i2 - 1))).get((int)index)).ts + this.bits(pos.get(i2).get(j) - ((Event)((ArrayList)matrix.get((int)(i2 - 1))).get((int)index)).id);
                        if (g <= min) {
                            min = g;
                            mini = index;
                        }
                        ++index;
                    }
                    Event ww = new Event();
                    ww.ts = min;
                    ww.id = pos.get(i2).get(j);
                    ww.gap = mini;
                    ((ArrayList)matrix.get(i2)).add(ww);
                }
            }
            int min = Integer.MAX_VALUE;
            int mini = 0;
            for (int i3 = 0; i3 < ((ArrayList)matrix.get(matrix.size() - 1)).size(); ++i3) {
                if (min <= ((Event)((ArrayList)matrix.get((int)(matrix.size() - 1))).get((int)i3)).ts) continue;
                min = ((Event)((ArrayList)matrix.get((int)(matrix.size() - 1))).get((int)i3)).ts;
                mini = i3;
            }
            if (min == Integer.MAX_VALUE) break;
            ArrayList<Integer> match = new ArrayList<Integer>();
            HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
            for (i = matrix.size() - 1; i >= 0; --i) {
                match.add(0, ((Event)((ArrayList)matrix.get((int)i)).get((int)mini)).id);
                hm.put(((Event)((ArrayList)matrix.get((int)i)).get((int)mini)).id, 1);
                mini = ((Event)((ArrayList)matrix.get((int)i)).get((int)mini)).gap;
            }
            matches.add(match);
            i = 0;
            while (true) {
                if (i >= pos.size()) continue block0;
                Iterator<Integer> it = pos.get(i).iterator();
                while (it.hasNext()) {
                    if (!hm.containsKey(it.next())) continue;
                    it.remove();
                }
                if (pos.get(i).isEmpty()) {
                    return matches;
                }
                ++i;
            }
            break;
        }
        return matches;
    }

    int gap_cost(ArrayList<ArrayList<Integer>> matches) {
        int g = 0;
        for (int i = 0; i < matches.size(); ++i) {
            for (int j = 1; j < matches.get(i).size(); ++j) {
                g += this.bits(matches.get(i).get(j) - matches.get(i).get(j - 1));
            }
        }
        return g;
    }

    void remove(ArrayList<ArrayList<Integer>> matches, int index) {
        HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
        for (int i = 0; i < matches.size(); ++i) {
            for (int j = 0; j < matches.get(i).size(); ++j) {
                hm.put(matches.get(i).get(j), 1);
            }
        }
        Iterator<Event> it = this.data.get(index).iterator();
        while (it.hasNext()) {
            if (!hm.containsKey(it.next().ts)) continue;
            it.remove();
        }
    }

    ArrayList<Integer> getRelatedEvents(Integer e) {
        int i;
        HashMap<Integer, SignTest> me = new HashMap<Integer, SignTest>();
        HashMap<Integer, Integer> mc = new HashMap<Integer, Integer>();
        ArrayList<Integer> nextdata = new ArrayList<Integer>();
        for (i = 0; i < this.data.size(); ++i) {
            int next = this.data.get(i).size();
            for (int j = 0; j < this.data.get(i).size(); ++j) {
                if (this.data.get((int)i).get((int)j).id != e) continue;
                next = j;
                break;
            }
            nextdata.add(++next);
        }
        for (i = 0; i < this.data.size(); ++i) {
            mc.clear();
            if ((Integer)nextdata.get(i) >= this.data.get(i).size()) continue;
            double middle = this.data.get((int)i).get((int)((Integer)nextdata.get((int)i)).intValue()).ts;
            middle += ((double)this.data.get((int)i).get((int)(this.data.get((int)i).size() - 1)).ts - middle) / 2.0;
            for (int j = ((Integer)nextdata.get(i)).intValue(); j < this.data.get(i).size(); ++j) {
                if ((double)this.data.get((int)i).get((int)j).ts <= middle) {
                    if (!mc.containsKey(this.data.get((int)i).get((int)j).id)) {
                        mc.put(this.data.get((int)i).get((int)j).id, new Integer(1));
                        continue;
                    }
                    mc.put(this.data.get((int)i).get((int)j).id, new Integer((Integer)mc.get(this.data.get((int)i).get((int)j).id) + 1));
                    continue;
                }
                if (!mc.containsKey(this.data.get((int)i).get((int)j).id)) {
                    mc.put(this.data.get((int)i).get((int)j).id, new Integer(-1));
                    continue;
                }
                mc.put(this.data.get((int)i).get((int)j).id, new Integer((Integer)mc.get(this.data.get((int)i).get((int)j).id) - 1));
            }
            for (Integer key : mc.keySet()) {
                SignTest st;
                if (!me.containsKey(key)) {
                    st = new SignTest(1, 0.0);
                    if ((Integer)mc.get(key) > 0) {
                        st.Nplus += 1.0;
                    }
                    me.put(key, st);
                    continue;
                }
                st = (Integer)mc.get(key) != 0 ? new SignTest(((SignTest)me.get((Object)key)).Npairs + 1, ((SignTest)me.get((Object)key)).Nplus) : new SignTest(((SignTest)me.get((Object)key)).Npairs, ((SignTest)me.get((Object)key)).Nplus);
                if ((Integer)mc.get(key) > 0) {
                    st.Nplus += 1.0;
                }
                me.put(key, st);
            }
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (Integer key : me.keySet()) {
            if (((SignTest)me.get(key)).sign_test()) {
                results.add(key);
            }
            if (results.size() <= 1000) continue;
            break;
        }
        return results;
    }

    int bits(Integer a) {
        if (a < 0) {
            return 0;
        }
        double x = Math.log(a.intValue()) / Math.log(2.0);
        return 2 * this.lowround(x) + 1;
    }

    int lowround(double x) {
        int y = (int)Math.round(x);
        if ((double)y > x) {
            --y;
        }
        return y;
    }

    boolean isOccurred(MyPattern p, int index) {
        int d = 0;
        for (int i = 0; i < this.data.get(index).size() && d < p.ids.size(); ++i) {
            if (p.ids.get(d) != this.data.get((int)index).get((int)i).id) continue;
            ++d;
        }
        return d == p.ids.size();
    }

    void printData() {
        for (int i = 0; i < this.data.size(); ++i) {
            for (int j = 0; j < this.data.get(i).size(); ++j) {
                System.out.print(this.data.get((int)i).get((int)j).id + 1 + " -1 ");
            }
            System.out.print("-2");
            System.out.println();
        }
    }

    void printMyPattern(MyPattern pattern) throws IOException {
        if (this.writer == null) {
            if (this.labels == null || this.labels.isEmpty()) {
                System.out.print("");
                for (int j = 0; j < pattern.ids.size(); ++j) {
                    System.out.print(pattern.ids.get(j) + " ");
                }
                System.out.println(" #SUP: " + pattern.ben);
            } else {
                System.out.print("");
                for (int j = 0; j < pattern.ids.size(); ++j) {
                    System.out.print(this.labels.get(pattern.ids.get(j)) + " ");
                }
                System.out.println(" #SUP: " + pattern.ben);
            }
        } else {
            StringBuffer buffer = new StringBuffer();
            if (this.labels == null || this.labels.isEmpty()) {
                for (int j = 0; j < pattern.ids.size(); ++j) {
                    this.writer.write(pattern.ids.get(j) + " ");
                }
                this.writer.write(" #SUP: " + pattern.ben);
            } else {
                for (int j = 0; j < pattern.ids.size(); ++j) {
                    this.writer.write(this.labels.get(pattern.ids.get(j)) + " ");
                }
                this.writer.write(" #SUP: " + pattern.ben);
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void setOutputFilePath(String outputFilePath) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
    }
}

