/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AbstractAlgoPrefixSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequences;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.AlgoDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPatterns;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPatternsDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequences;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class AlgoSeqDim {
    protected MDSequences sequences = new MDSequences("FREQUENT MD-SEQUENCES");
    private long startTime;
    private long endTime;
    private boolean mineClosedPatterns = false;
    BufferedWriter writer = null;
    private int patternCount;
    private int databaseSize = 0;

    public MDSequences runAlgorithm(MDSequenceDatabase database, AbstractAlgoPrefixSpan algoPrefixSpan, AlgoDim algoDim, boolean mineClosedPatterns, String output) throws IOException {
        MemoryLogger.getInstance().reset();
        this.patternCount = 0;
        this.startTime = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.databaseSize = database.size();
        this.mineClosedPatterns = mineClosedPatterns;
        Sequences sequencesFound = algoPrefixSpan.runAlgorithm(database.getSequenceDatabase());
        for (int j = 0; j < sequencesFound.getLevelCount(); ++j) {
            List<Sequence> sequencesList = sequencesFound.getLevel(j);
            for (Sequence sequence : sequencesList) {
                this.trySequence(sequence, database, algoPrefixSpan.getMinSupp(), algoDim);
            }
        }
        if (mineClosedPatterns) {
            this.removeRedundancy();
        }
        this.endTime = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        return this.sequences;
    }

    private void trySequence(Sequence sequence, MDSequenceDatabase database, double minsupp, AlgoDim algoDim) throws IOException {
        MDPatternsDatabase newContexte = this.createProjectedDatabase(sequence.getSequencesID(), database.getPatternDatabase());
        double newMinSupp = minsupp * (double)database.size() / (double)newContexte.size();
        MDPatterns patterns = algoDim.runAlgorithm(newContexte, newMinSupp);
        for (int i = 0; i < patterns.getLevelCount(); ++i) {
            for (MDPattern pattern : patterns.getLevel(i)) {
                MDSequence mdsequence = new MDSequence(0, pattern, sequence);
                boolean onlyWildcards = true;
                for (Integer id : pattern.getPatternsID()) {
                    if (id == 9999) continue;
                    onlyWildcards = false;
                    break;
                }
                if (onlyWildcards) {
                    mdsequence.setSupport(sequence.getSequencesID().size());
                } else {
                    mdsequence.setSupport(pattern.getAbsoluteSupport());
                }
                this.savePattern(sequence, mdsequence);
            }
        }
    }

    private void savePattern(Sequence sequence, MDSequence mdsequence) throws IOException {
        if (!this.mineClosedPatterns) {
            this.writeToFile(mdsequence);
        } else {
            this.sequences.addSequence(mdsequence, sequence.size());
        }
        ++this.patternCount;
    }

    private void writeToFile(MDSequence mdsequence) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(mdsequence.getMdpattern().toStringShort());
        buffer.append(mdsequence.getSequence().toStringShort());
        buffer.append(" #SUP: ");
        buffer.append(mdsequence.getAbsoluteSupport());
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private MDPatternsDatabase createProjectedDatabase(Set<Integer> patternsIds, MDPatternsDatabase patternsDatabase) {
        MDPatternsDatabase projectedDatabase = new MDPatternsDatabase();
        for (MDPattern pattern : patternsDatabase.getMDPatterns()) {
            if (!patternsIds.contains(pattern.getId())) continue;
            projectedDatabase.addMDPattern(pattern);
        }
        return projectedDatabase;
    }

    public void printStatistics(int databaseSize) {
        StringBuffer r = new StringBuffer(140);
        r.append("=============  SEQ-DIM - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" max memory : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append("\n Frequent sequences count : ");
        r.append(this.patternCount);
        System.out.println(r.toString());
        System.out.println("===================================================");
    }

    private void removeRedundancy() throws IOException {
        for (int i = this.sequences.getLevels().size() - 1; i > 0; --i) {
            for (MDSequence sequence : this.sequences.getLevel(i)) {
                boolean included = false;
                block2: for (int j = i; j < this.sequences.getLevels().size() && !included; ++j) {
                    for (MDSequence sequence2 : this.sequences.getLevel(j)) {
                        if (sequence == sequence2 || sequence2.getAbsoluteSupport() != sequence.getAbsoluteSupport() || !sequence2.contains(sequence)) continue;
                        included = true;
                        continue block2;
                    }
                }
                if (included) continue;
                this.writeToFile(sequence);
            }
        }
    }
}

