/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AbstractAlgoPrefixSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.PseudoSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoBIDEPlus
extends AbstractAlgoPrefixSpan {
    private Sequences patterns = null;
    private long startTime;
    private long endTime;
    private final double minsup;
    private int minsuppRelative;
    private PseudoSequenceDatabase initialDatabase = null;

    public AlgoBIDEPlus(double minsup) {
        this.minsup = minsup;
    }

    @Override
    public double getMinSupp() {
        return this.minsup;
    }

    @Override
    public Sequences runAlgorithm(SequenceDatabase database) {
        this.patterns = new Sequences("FREQUENT CLOSED SEQUENTIAL PATTERNS");
        this.minsuppRelative = (int)Math.ceil(this.minsup * (double)database.size());
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        this.startTime = System.currentTimeMillis();
        this.bide(database);
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    private void bide(SequenceDatabase database) {
        Map<ItemSimple, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(database);
        this.initialDatabase = new PseudoSequenceDatabase();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppRelative);
            if (optimizedSequence.size() == 0) continue;
            this.initialDatabase.addSequence(new PseudoSequence(0L, optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppRelative) continue;
            ItemSimple item = (ItemSimple)entry.getKey();
            PseudoSequenceDatabase projectedContext = this.buildProjectedDatabase(item, this.initialDatabase, false);
            Sequence prefix = new Sequence(0);
            prefix.addItemset(new Itemset(item, 0L));
            prefix.setSequencesID((Set)entry.getValue());
            int successorSupport = 0;
            if (!this.checkBackScanPruning(prefix)) {
                successorSupport = this.recursion(prefix, projectedContext);
            }
            if (prefix.getAbsoluteSupport() == successorSupport || this.checkBackwardExtension(prefix)) continue;
            this.patterns.addSequence(prefix, 1);
        }
    }

    private boolean checkBackScanPruning(Sequence prefix) {
        for (int i = 0; i < prefix.getItemOccurencesTotalCount(); ++i) {
            ArrayList<PseudoSequence> semimaximumPeriods = new ArrayList<PseudoSequence>();
            for (PseudoSequence sequence : this.initialDatabase.getPseudoSequences()) {
                PseudoSequence period;
                if (!prefix.getSequencesID().contains(sequence.getId()) || (period = sequence.getIthSemiMaximumPeriodOfAPrefix(prefix, i, false)) == null) continue;
                semimaximumPeriods.add(period);
            }
            Set<Pair> paires = this.findAllFrequentPairsForBackwardExtensionCheck(prefix, semimaximumPeriods, i);
            for (Pair pair : paires) {
                if (pair.getCount() != prefix.getAbsoluteSupport()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkBackwardExtension(Sequence prefix) {
        for (int i = 0; i < prefix.getItemOccurencesTotalCount(); ++i) {
            ArrayList<PseudoSequence> maximumPeriods = new ArrayList<PseudoSequence>();
            for (PseudoSequence sequence : this.initialDatabase.getPseudoSequences()) {
                PseudoSequence period;
                if (!prefix.getSequencesID().contains(sequence.getId()) || (period = sequence.getIthMaximumPeriodOfAPrefix(prefix, i, false)) == null) continue;
                maximumPeriods.add(period);
            }
            for (Pair pair : this.findAllFrequentPairsForBackwardExtensionCheck(prefix, maximumPeriods, i)) {
                if (pair.getCount() != prefix.getAbsoluteSupport()) continue;
                return true;
            }
        }
        return false;
    }

    protected Set<Pair> findAllFrequentPairsForBackwardExtensionCheck(Sequence prefix, List<PseudoSequence> maximumPeriods, int iPeriod) {
        HashMap<Pair, Pair> mapPaires = new HashMap<Pair, Pair>();
        PseudoSequence lastPeriod = null;
        HashSet<Pair> alreadyCountedForSequenceID = new HashSet<Pair>();
        ItemSimple itemI = prefix.getIthItem(iPeriod);
        ItemSimple itemIm1 = null;
        if (iPeriod > 0) {
            itemIm1 = prefix.getIthItem(iPeriod - 1);
        }
        for (PseudoSequence period : maximumPeriods) {
            if (period != lastPeriod) {
                alreadyCountedForSequenceID.clear();
                lastPeriod = period;
            }
            for (int i = 0; i < period.size(); ++i) {
                ItemSimple item;
                int j;
                boolean sawI = false;
                boolean sawIm1 = false;
                for (j = 0; j < period.getSizeOfItemsetAt(i); ++j) {
                    item = period.getItemAtInItemsetAt(j, i);
                    if (item.getId() == itemI.getId()) {
                        sawI = true;
                        continue;
                    }
                    if (item.getId() > itemI.getId()) break;
                }
                for (j = 0; j < period.getSizeOfItemsetAt(i); ++j) {
                    Pair paire2;
                    item = period.getItemAtInItemsetAt(j, i);
                    if (itemIm1 != null && item.getId() == itemIm1.getId()) {
                        sawIm1 = true;
                    }
                    boolean isPrefix = period.isCutAtRight(i);
                    boolean isPostfix = period.isCutAtLeft(i);
                    Pair paire = new Pair(isPrefix, isPostfix, item);
                    this.addPair(mapPaires, alreadyCountedForSequenceID, period, paire);
                    if (sawIm1) {
                        paire2 = new Pair(isPrefix, !isPostfix, item);
                        this.addPair(mapPaires, alreadyCountedForSequenceID, period, paire2);
                    }
                    if (!sawI) continue;
                    paire2 = new Pair(!isPrefix, isPostfix, item);
                    this.addPair(mapPaires, alreadyCountedForSequenceID, period, paire2);
                }
            }
        }
        return mapPaires.keySet();
    }

    private void addPair(Map<Pair, Pair> mapPaires, Set<Pair> alreadyCountedForSequenceID, PseudoSequence period, Pair pair) {
        Pair oldPaire = mapPaires.get(pair);
        if (!alreadyCountedForSequenceID.contains(pair)) {
            if (oldPaire == null) {
                mapPaires.put(pair, pair);
            } else {
                pair = oldPaire;
            }
            alreadyCountedForSequenceID.add(pair);
            pair.getSequencesID().add(period.getId());
        }
    }

    private Map<ItemSimple, Set<Integer>> findSequencesContainingItems(SequenceDatabase database) {
        HashSet<Integer> alreadyCounted = new HashSet<Integer>();
        Sequence lastSequence = null;
        HashMap<ItemSimple, Set<Integer>> mapSequenceID = new HashMap<ItemSimple, Set<Integer>>();
        for (Sequence sequence : database.getSequences()) {
            if (lastSequence == null || lastSequence.getId() != sequence.getId()) {
                alreadyCounted.clear();
                lastSequence = sequence;
            }
            for (Itemset itemset : sequence.getItemsets()) {
                for (ItemSimple item : itemset.getItems()) {
                    if (alreadyCounted.contains(item.getId())) continue;
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                    alreadyCounted.add(item.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private PseudoSequenceDatabase buildProjectedDatabase(ItemSimple item, PseudoSequenceDatabase database, boolean inSuffix) {
        PseudoSequenceDatabase sequenceDatabase = new PseudoSequenceDatabase();
        for (PseudoSequence sequence : database.getPseudoSequences()) {
            for (int i = 0; i < sequence.size(); ++i) {
                PseudoSequence newSequence;
                int index = sequence.indexOf(i, item.getId());
                if (index == -1 || sequence.isCutAtLeft(i) != inSuffix) continue;
                if (index != sequence.getSizeOfItemsetAt(i) - 1) {
                    newSequence = new PseudoSequence(sequence.getAbsoluteTimeStamp(i), sequence, i, index + 1);
                    if (newSequence.size() <= 0) continue;
                    sequenceDatabase.addSequence(newSequence);
                    continue;
                }
                if (i == sequence.size() - 1 || (newSequence = new PseudoSequence(sequence.getAbsoluteTimeStamp(i), sequence, i + 1, 0)).size() <= 0) continue;
                sequenceDatabase.addSequence(newSequence);
            }
        }
        return sequenceDatabase;
    }

    private int recursion(Sequence prefix, PseudoSequenceDatabase contexte) {
        Set<Pair> pairs = this.findAllFrequentPairs(prefix, contexte.getPseudoSequences());
        int maxSupport = 0;
        for (Pair paire : pairs) {
            boolean noForwardSIExtension;
            if (paire.getCount() < this.minsuppRelative) continue;
            Sequence newPrefix = paire.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, paire.getItem()) : this.appendItemToSequence(prefix, paire.getItem());
            PseudoSequenceDatabase projectedContext = this.buildProjectedDatabase(paire.getItem(), contexte, paire.isPostfix());
            newPrefix.setSequencesID(paire.getSequencesID());
            int maxSupportOfSuccessors = 0;
            if (!this.checkBackScanPruning(newPrefix)) {
                maxSupportOfSuccessors = this.recursion(newPrefix, projectedContext);
            }
            boolean bl = noForwardSIExtension = newPrefix.getAbsoluteSupport() != maxSupportOfSuccessors;
            if (noForwardSIExtension && !this.checkBackwardExtension(newPrefix)) {
                this.patterns.addSequence(newPrefix, newPrefix.size());
            }
            if (newPrefix.getAbsoluteSupport() <= maxSupport) continue;
            maxSupport = newPrefix.getAbsoluteSupport();
        }
        return maxSupport;
    }

    protected Set<Pair> findAllFrequentPairs(Sequence prefix, List<PseudoSequence> sequences) {
        HashMap<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        PseudoSequence lastSequence = null;
        HashSet<Pair> alreadyCountedForSequenceID = new HashSet<Pair>();
        for (PseudoSequence sequence : sequences) {
            if (sequence != lastSequence) {
                alreadyCountedForSequenceID.clear();
                lastSequence = sequence;
            }
            for (int i = 0; i < sequence.size(); ++i) {
                for (int j = 0; j < sequence.getSizeOfItemsetAt(i); ++j) {
                    ItemSimple item = sequence.getItemAtInItemsetAt(j, i);
                    Pair pair = new Pair(sequence.isCutAtRight(i), sequence.isCutAtLeft(i), item);
                    this.addPair(mapPairs, alreadyCountedForSequenceID, sequence, pair);
                }
            }
        }
        return mapPairs.keySet();
    }

    private Sequence appendItemToSequence(Sequence prefix, ItemSimple item) {
        Sequence newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item, 0L));
        return newPrefix;
    }

    private Sequence appendItemToPrefixOfSequence(Sequence prefix, ItemSimple item) {
        Sequence newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    public void printStatistics(int databaseSize) {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Closed sequential patterns count : ");
        r.append(this.patterns.sequenceCount);
        r.append('\n');
        r.append(this.patterns.toString(databaseSize));
        r.append("===================================================\n");
        System.out.println(r.toString());
    }
}

