/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.PseudoSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.Abstraction_Generic;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.ItemAbstractionPairCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.trie.Trie;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.trie.TrieNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.savers.Saver;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RecursionCloSpan {
    private AbstractionCreator abstractionCreator;
    private Saver saver;
    private long minSupportAbsolute;
    private PseudoSequenceDatabase pseudoDatabase;
    private Map<Item, BitSet> mapSequenceID;
    private int numberOfFrequentPatterns = 0;
    private Map<Integer, Map<Integer, List<Map.Entry<Pattern, Trie>>>> matchingMap;
    private Trie generalTrie;
    private boolean findClosedPatterns;
    private boolean executePruningMethods;

    public RecursionCloSpan(AbstractionCreator abstractionCreator, Saver saver, long minSupportAbsolute, PseudoSequenceDatabase pseudoDatabase, Map<Item, BitSet> mapSequenceID, boolean findClosedPatterns, boolean executePruningMethods) {
        this.abstractionCreator = abstractionCreator;
        this.minSupportAbsolute = minSupportAbsolute;
        this.pseudoDatabase = pseudoDatabase;
        this.mapSequenceID = mapSequenceID;
        this.matchingMap = new LinkedHashMap<Integer, Map<Integer, List<Map.Entry<Pattern, Trie>>>>();
        this.generalTrie = new Trie();
        this.findClosedPatterns = findClosedPatterns;
        this.executePruningMethods = executePruningMethods;
        this.saver = saver;
    }

    public void execute(boolean verbose) {
        ArrayList<Item> keySetList = new ArrayList<Item>(this.mapSequenceID.keySet());
        Collections.sort(keySetList);
        if (verbose) {
            System.out.println(keySetList.size() + " frequent items");
        }
        int numberOfFrequentItems = keySetList.size();
        int cont = 0;
        for (Item item : keySetList) {
            ++cont;
            if (verbose) {
                System.out.println("Projecting item = " + item + " (" + cont + "/" + numberOfFrequentItems + ")");
            }
            PseudoSequenceDatabase projectedContext = this.makePseudoProjections(item, this.pseudoDatabase, this.abstractionCreator.CreateDefaultAbstraction(), true);
            ItemAbstractionPair pair = new ItemAbstractionPair(item, this.abstractionCreator.CreateDefaultAbstraction());
            Pattern prefix = new Pattern(pair);
            prefix.setAppearingIn(this.mapSequenceID.get(item));
            Trie newTrie = new Trie();
            newTrie.setAppearingIn(prefix.getAppearingIn());
            TrieNode prefixNode = new TrieNode(pair, newTrie);
            this.generalTrie.addNode(prefixNode);
            if (projectedContext == null) continue;
            this.cloSpanLoop(prefix, prefixNode, 2, projectedContext, verbose);
        }
    }

    public List<Pattern> getFrequentPatterns() {
        List<Pattern> result = this.generalTrie.preorderTraversal(null);
        return result;
    }

    private PseudoSequenceDatabase makePseudoProjections(Item item, PseudoSequenceDatabase database, Abstraction_Generic abstraccion, boolean firstTime) {
        PseudoSequenceDatabase newProjectedDatabase = new PseudoSequenceDatabase();
        int numberOfProjectionsSum = 0;
        int cumulativeSum = 0;
        int totalElementInProjectedDatabase = 0;
        StringBuilder sb = new StringBuilder();
        List<PseudoSequence> pseudoSequences = database.getPseudoSequences();
        for (int sequenceIndex = 0; sequenceIndex < pseudoSequences.size(); ++sequenceIndex) {
            PseudoSequence sequence = pseudoSequences.get(sequenceIndex);
            boolean alreadyProjected = false;
            PseudoSequence newSequence = null;
            int numberOfProjections = 0;
            HashSet<Integer> projectionsAlreadyMade = new HashSet<Integer>();
            for (int k = 0; k < sequence.numberOfProjectionsIncluded(); ++k) {
                int sequenceSize = sequence.size(k);
                for (int i = 0; i < sequenceSize; ++i) {
                    int remainingElements;
                    int index = sequence.indexOf(k, i, item);
                    if (index == -1 || !firstTime && !abstraccion.compute(sequence, k, i)) continue;
                    int itemsetSize = sequence.getSizeOfItemsetAt(k, i);
                    if (index != itemsetSize - 1) {
                        if (!alreadyProjected) {
                            newSequence = new PseudoSequence(sequence.getRelativeTimeStamp(i, k), sequence, i, index + 1, k);
                            projectionsAlreadyMade.add(sequence.getFirstItemset(k) + i);
                            if (newSequence.size(numberOfProjections) > 0) {
                                ++numberOfProjections;
                                newProjectedDatabase.addSequence(newSequence);
                                cumulativeSum += newSequence.size(0);
                                remainingElements = newSequence.length(newSequence.numberOfProjectionsIncluded() - 1);
                                totalElementInProjectedDatabase += remainingElements;
                                sb.append(remainingElements);
                            }
                            alreadyProjected = true;
                            continue;
                        }
                        if (!projectionsAlreadyMade.add(sequence.getFirstItemset(k) + i)) continue;
                        newSequence.addProjectionPoint(k, sequence.getRelativeTimeStamp(i, k), sequence, i, index + 1);
                        cumulativeSum += newSequence.size(newSequence.numberOfProjectionsIncluded() - 1);
                        remainingElements = newSequence.length(newSequence.numberOfProjectionsIncluded() - 1);
                        totalElementInProjectedDatabase += remainingElements;
                        sb.append(remainingElements);
                        continue;
                    }
                    if (i == sequenceSize - 1) continue;
                    if (!alreadyProjected) {
                        newSequence = new PseudoSequence(sequence.getRelativeTimeStamp(i, k), sequence, i + 1, 0, k);
                        projectionsAlreadyMade.add(sequence.getFirstItemset(k) + i);
                        if (itemsetSize > 0 && newSequence.size(numberOfProjections) > 0) {
                            ++numberOfProjections;
                            newProjectedDatabase.addSequence(newSequence);
                            cumulativeSum += newSequence.size(0);
                            remainingElements = newSequence.length(newSequence.numberOfProjectionsIncluded() - 1);
                            totalElementInProjectedDatabase += remainingElements;
                            sb.append(remainingElements);
                        }
                        alreadyProjected = true;
                        continue;
                    }
                    if (!projectionsAlreadyMade.add(sequence.getFirstItemset(k) + i)) continue;
                    newSequence.addProjectionPoint(k, sequence.getRelativeTimeStamp(i, k), sequence, i + 1, 0);
                    cumulativeSum += newSequence.size(newSequence.numberOfProjectionsIncluded() - 1);
                    remainingElements = newSequence.length(newSequence.numberOfProjectionsIncluded() - 1);
                    totalElementInProjectedDatabase += remainingElements;
                    sb.append(remainingElements);
                }
            }
            if (newSequence == null) continue;
            numberOfProjectionsSum += newSequence.numberOfProjectionsIncluded();
        }
        newProjectedDatabase.setCumulativeSum(cumulativeSum);
        newProjectedDatabase.setCumulativeSumNumberOfProjections(numberOfProjectionsSum);
        newProjectedDatabase.setNumberOfElementsProjectedDatabase(totalElementInProjectedDatabase);
        newProjectedDatabase.setElementsProjectedDatabase(sb.toString());
        return newProjectedDatabase;
    }

    private void cloSpanLoop(Pattern prefix, TrieNode prefixNode, int k, PseudoSequenceDatabase context, boolean verbose) {
        if (this.findClosedPatterns && this.executePruningMethods && this.pruneByCheckingProjectedDBSize(prefix, context, prefixNode)) {
            return;
        }
        Trie currentTrie = prefixNode.getChild();
        ++this.numberOfFrequentPatterns;
        if (context == null || (long)context.size() < this.minSupportAbsolute) {
            return;
        }
        Set<Pair> pairs = this.abstractionCreator.findAllFrequentPairs(context.getPseudoSequences());
        if (verbose) {
            StringBuilder tab = new StringBuilder();
            for (int i = 0; i < k - 2; ++i) {
                tab.append('\t');
            }
            System.out.println(tab + "Projecting prefix = " + prefix);
            System.out.print(tab + "\tFound " + pairs.size() + " frequent items in this projection\n");
        }
        for (Pair pair : pairs) {
            if ((long)pair.getSupport() < this.minSupportAbsolute) continue;
            Pattern newPrefix = prefix.clonePatron();
            ItemAbstractionPair newPair = ItemAbstractionPairCreator.getInstance().getItemAbstractionPair(pair.getPar().getItem(), this.abstractionCreator.createAbstractionFromAPrefix(prefix, pair.getPar().getAbstraction()));
            newPrefix.add(newPair);
            PseudoSequenceDatabase projection = this.makePseudoProjections(pair.getPar().getItem(), context, pair.getPar().getAbstraction(), false);
            if (projection == null) continue;
            Trie newTrie = new Trie();
            newTrie.setAppearingIn(pair.getSequencesID());
            TrieNode newNodoPrefix = new TrieNode(newPair, newTrie);
            currentTrie.addNode(newNodoPrefix);
            this.cloSpanLoop(newPrefix, newNodoPrefix, k + 1, projection, verbose);
        }
    }

    public int numberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public void clear() {
        if (this.pseudoDatabase != null) {
            this.pseudoDatabase.clear();
            this.pseudoDatabase = null;
        }
        if (this.mapSequenceID != null) {
            this.mapSequenceID.clear();
            this.mapSequenceID = null;
        }
        if (this.matchingMap != null) {
            this.matchingMap.clear();
            this.mapSequenceID = null;
        }
        if (this.generalTrie != null) {
            this.generalTrie.removeAll();
        }
    }

    private boolean pruneByCheckingProjectedDBSize(Pattern prefix, PseudoSequenceDatabase projection, TrieNode trieNode) {
        Trie prefixTrie = trieNode.getChild();
        int support = prefixTrie.getSupport();
        int key1 = prefixTrie.getSumIdSequences();
        int prefixSize = prefix.size();
        int key2 = RecursionCloSpan.key_standardAndSupport(projection, prefixTrie);
        Map<Integer, List<Map.Entry<Pattern, Trie>>> associatedMap = this.matchingMap.get(key1);
        AbstractMap.SimpleEntry<Pattern, Trie> newEntry = new AbstractMap.SimpleEntry<Pattern, Trie>(prefix, prefixTrie);
        if (associatedMap == null) {
            associatedMap = new LinkedHashMap<Integer, List<Map.Entry<Pattern, Trie>>>();
            ArrayList<AbstractMap.SimpleEntry<Pattern, Trie>> entryList = new ArrayList<AbstractMap.SimpleEntry<Pattern, Trie>>();
            entryList.add(newEntry);
            associatedMap.put(key2, entryList);
            this.matchingMap.put(key1, associatedMap);
        } else {
            List<Map.Entry<Pattern, Trie>> associatedList = associatedMap.get(key2);
            if (associatedList == null) {
                associatedList = new ArrayList<Map.Entry<Pattern, Trie>>();
                associatedList.add(newEntry);
                associatedMap.put(key2, associatedList);
            } else {
                int superPattern = 0;
                for (int i = 0; i < associatedList.size(); ++i) {
                    Map.Entry<Pattern, Trie> storedEntry = associatedList.get(i);
                    Pattern p = storedEntry.getKey();
                    Trie t = storedEntry.getValue();
                    int pSize = p.size();
                    if (support != t.getSupport() || pSize == prefixSize) continue;
                    if (prefixSize < pSize) {
                        if (!prefix.isSubpattern(this.abstractionCreator, p)) continue;
                        prefixTrie.setNodes(t.getNodes());
                        return true;
                    }
                    if (!p.isSubpattern(this.abstractionCreator, prefix)) continue;
                    ++superPattern;
                    prefixTrie.setNodes(t.getNodes());
                    associatedList.remove(i);
                    --i;
                }
                associatedList.add(newEntry);
                if (superPattern > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private static int key_standard(PseudoSequenceDatabase projection) {
        return projection.getNumberOfElementsProjectedDatabase();
    }

    private static int key_standardAndSupport(PseudoSequenceDatabase projection, Trie prefix) {
        return projection.getNumberOfElementsProjectedDatabase() + prefix.getSupport();
    }

    private static int key_standardAndSumIDs(PseudoSequenceDatabase projection, Trie prefix) {
        return projection.getNumberOfElementsProjectedDatabase() + prefix.getSumIdSequences();
    }

    private static int key_standardAndCumulativeSum(PseudoSequenceDatabase projection, Trie prefix) {
        int key = projection.getNumberOfElementsProjectedDatabase();
        return key += projection.getCumulativeSum();
    }

    private static int Key_standardAndElements(PseudoSequenceDatabase projection, Trie prefix) {
        int key = projection.getNumberOfElementsProjectedDatabase();
        return key += projection.getElementsProjectedDatabase();
    }

    void removeNonClosedPatterns(List<Pattern> frequentPatterns, boolean keepPatterns) {
        System.err.println("Before removing NonClosed patterns there are " + this.numberOfFrequentPatterns + " patterns");
        this.numberOfFrequentPatterns = 0;
        LinkedHashMap<Integer, ArrayList<Pattern>> totalPatterns = new LinkedHashMap<Integer, ArrayList<Pattern>>();
        for (Pattern p : frequentPatterns) {
            ArrayList<Pattern> patternList = (ArrayList<Pattern>)totalPatterns.get(p.getSumIdSequences());
            if (patternList == null) {
                patternList = new ArrayList<Pattern>();
                totalPatterns.put(p.getSumIdSequences(), patternList);
            }
            patternList.add(p);
        }
        for (List list : totalPatterns.values()) {
            block2: for (int i = 0; i < list.size(); ++i) {
                for (int j = i + 1; j < list.size(); ++j) {
                    Pattern p1 = (Pattern)list.get(i);
                    Pattern p2 = (Pattern)list.get(j);
                    if (p1.getSupport() != p2.getSupport() || p1.size() == p2.size()) continue;
                    if (p1.size() < p2.size()) {
                        if (!p1.isSubpattern(this.abstractionCreator, p2)) continue;
                        list.remove(i);
                        --i;
                        continue block2;
                    }
                    if (!p2.isSubpattern(this.abstractionCreator, p1)) continue;
                    list.remove(j);
                    --j;
                }
            }
        }
        for (List list : totalPatterns.values()) {
            this.numberOfFrequentPatterns += list.size();
            if (!keepPatterns) continue;
            for (Pattern p : list) {
                this.saver.savePattern(p);
            }
        }
    }
}

