/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.Itemset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SequentialPattern {
    private final List<Itemset> itemsets = new ArrayList<Itemset>();
    private int id;
    private Set<Integer> sequencesID = null;

    SequentialPattern(int id) {
        this.id = id;
    }

    public String getRelativeSupportFormated(int sequencecount) {
        double frequence = (double)this.sequencesID.size() / (double)sequencecount;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(frequence);
    }

    public int getAbsoluteSupport() {
        return this.sequencesID.size();
    }

    void addItemset(Itemset itemset) {
        this.itemsets.add(itemset);
    }

    SequentialPattern cloneSequence() {
        SequentialPattern sequence = new SequentialPattern(this.getId());
        for (Itemset itemset : this.itemsets) {
            sequence.addItemset(itemset.cloneItemSet());
        }
        return sequence;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuffer r = new StringBuffer("");
        for (Itemset itemset : this.itemsets) {
            r.append('(');
            for (String item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append(')');
        }
        if (this.getSequencesID() != null) {
            r.append("  Sequence ID: ");
            for (Integer id : this.getSequencesID()) {
                r.append(id);
                r.append(' ');
            }
        }
        return r.append("    ").toString();
    }

    public String itemsetsToString() {
        StringBuffer r = new StringBuffer("");
        for (Itemset itemset : this.itemsets) {
            for (String item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append('}');
        }
        return r.append("    ").toString();
    }

    public int getId() {
        return this.id;
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    public Itemset get(int index) {
        return this.itemsets.get(index);
    }

    public String getIthItem(int i) {
        for (int j = 0; j < this.itemsets.size(); ++j) {
            if (i < this.itemsets.get(j).size()) {
                return this.itemsets.get(j).get(i);
            }
            i -= this.itemsets.get(j).size();
        }
        return null;
    }

    public int size() {
        return this.itemsets.size();
    }

    public Set<Integer> getSequencesID() {
        return this.sequencesID;
    }

    void setSequencesID(Set<Integer> sequencesID) {
        this.sequencesID = sequencesID;
    }

    int getItemOccurencesTotalCount() {
        int count = 0;
        for (Itemset itemset : this.itemsets) {
            count += itemset.size();
        }
        return count;
    }

    SequentialPattern cloneSequenceMinusItems(Map<String, Set<Integer>> mapSequenceID, double relativeMinSup) {
        SequentialPattern sequence = new SequentialPattern(this.getId());
        for (Itemset itemset : this.itemsets) {
            Itemset newItemset = itemset.cloneItemSetMinusItems(mapSequenceID, relativeMinSup);
            if (newItemset.size() == 0) continue;
            sequence.addItemset(newItemset);
        }
        return sequence;
    }

    public void setID(int id2) {
        this.id = id2;
    }
}

