/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.vme;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoVME {
    Map<Integer, Set<Integer>> mapItemTIDs = new HashMap<Integer, Set<Integer>>();
    Map<Integer, Integer> mapTransactionProfit = new HashMap<Integer, Integer>();
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    double maxProfitLoss = 0.0;
    double overallProfit = 0.0;
    private int erasableItemsetCount = 0;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output, double threshold) throws NumberFormatException, IOException {
        String[] lineSplited;
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.erasableItemsetCount = 0;
        this.overallProfit = 0.0;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        int i = 0;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            lineSplited = line.split(" ");
            int profit = Integer.parseInt(lineSplited[0]);
            this.overallProfit += (double)profit;
            this.mapTransactionProfit.put(i++, profit);
        }
        reader.close();
        this.maxProfitLoss = this.overallProfit * threshold;
        reader = new BufferedReader(new FileReader(input));
        i = 0;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            lineSplited = line.split(" ");
            for (int j = 1; j < lineSplited.length; ++j) {
                int item = Integer.parseInt(lineSplited[j]);
                Set<Integer> tids = this.mapItemTIDs.get(item);
                if (tids == null) {
                    tids = new HashSet<Integer>();
                    this.mapItemTIDs.put(item, tids);
                }
                tids.add(i);
            }
            ++i;
        }
        reader.close();
        List<Itemset> level = new ArrayList<Itemset>();
        Iterator<Map.Entry<Integer, Set<Integer>>> iterator = this.mapItemTIDs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Set<Integer>> entry = iterator.next();
            int loss = 0;
            for (Integer tid : entry.getValue()) {
                loss += this.mapTransactionProfit.get(tid).intValue();
            }
            if ((double)loss <= this.maxProfitLoss) {
                Itemset itemset = new Itemset(entry.getKey());
                itemset.setTIDs(this.mapItemTIDs.get(entry.getKey()));
                level.add(itemset);
                this.saveItemsetToFile(itemset, loss);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(level, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return o1.get(0) - o2.get(0);
            }
        });
        while (!level.isEmpty()) {
            level = this.generateCandidateSizeK(level);
        }
        this.writer.close();
        this.endTimeStamp = System.currentTimeMillis();
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) throws IOException {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        block0: for (int i = 0; i < levelK_1.size(); ++i) {
            Itemset itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                Itemset itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.size(); ++k) {
                    if (k == itemset1.size() - 1) {
                        if (itemset1.getItems()[k] < itemset2.getItems()[k]) continue;
                        continue block0;
                    }
                    if (itemset1.getItems()[k] < itemset2.get(k)) continue block1;
                    if (itemset1.getItems()[k] > itemset2.get(k)) continue block0;
                }
                Integer missing = itemset2.get(itemset2.size() - 1);
                HashSet<Integer> unionTIDS = new HashSet<Integer>(itemset1.getTransactionsIds());
                unionTIDS.addAll(itemset2.getTransactionsIds());
                int loss = 0;
                for (Integer tid : unionTIDS) {
                    loss += this.mapTransactionProfit.get(tid).intValue();
                }
                if (!((double)loss <= this.maxProfitLoss)) continue;
                int[] newItemset = new int[itemset1.size() + 1];
                System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                Itemset candidate = new Itemset(newItemset);
                candidate.setTIDs(unionTIDS);
                candidates.add(candidate);
                this.saveItemsetToFile(candidate, loss);
            }
        }
        return candidates;
    }

    private void saveItemsetToFile(Itemset itemset, int loss) throws IOException {
        this.writer.write(itemset.toString() + " #LOSS: " + loss);
        this.writer.newLine();
        ++this.erasableItemsetCount;
    }

    public void printStats() {
        System.out.println("=============  VME - STATS =============");
        long temps = this.endTimeStamp - this.startTimestamp;
        System.out.println("Overall profit: " + this.overallProfit);
        System.out.println("Maximum profit loss (over. profit x treshold): " + this.maxProfitLoss);
        System.out.println(" Erasable itemset count : " + this.erasableItemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }
}

