/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.two_phase;

import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.TransactionTP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UtilityTransactionDatabaseTP {
    private final Set<Integer> allItems = new HashSet<Integer>();
    private final List<TransactionTP> transactions = new ArrayList<TransactionTP>();

    public void addTransaction(TransactionTP t) {
        this.transactions.add(t);
        this.allItems.addAll(t.getItems());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.processTransaction(thisLine.split(":"));
            }
        }
    }

    private void processTransaction(String[] line) {
        int transactionUtility = Integer.parseInt(line[1]);
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (String item : line[0].split(" ")) {
            items.add(Integer.parseInt(item));
        }
        ArrayList<Integer> itemsUtilities = new ArrayList<Integer>();
        for (String utility : line[2].split(" ")) {
            itemsUtilities.add(Integer.parseInt(utility));
        }
        this.bubbleSort(items, itemsUtilities);
        this.transactions.add(new TransactionTP(items, itemsUtilities, transactionUtility));
    }

    private void bubbleSort(List<Integer> items, List<Integer> itemsUtilities) {
        for (int i = 0; i < items.size(); ++i) {
            for (int j = items.size() - 1; j >= i + 1; --j) {
                if (items.get(j) >= items.get(j - 1)) continue;
                int temp = items.get(j);
                items.set(j, items.get(j - 1));
                items.set(j - 1, temp);
                int tempUtilities = itemsUtilities.get(j);
                itemsUtilities.set(j, itemsUtilities.get(j - 1));
                itemsUtilities.set(j - 1, tempUtilities);
            }
        }
    }

    public void printDatabase() {
        System.out.println("===================  Database ===================");
        int count = 0;
        for (TransactionTP itemset : this.transactions) {
            System.out.print("0" + count + ":  ");
            itemset.print();
            System.out.println("");
            ++count;
        }
    }

    public int size() {
        return this.transactions.size();
    }

    public List<TransactionTP> getTransactions() {
        return this.transactions;
    }

    public Set<Integer> getAllItems() {
        return this.allItems;
    }
}

