/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat;

import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoEclat_Bitset {
    private int minsupRelative;
    protected TransactionDatabase database;
    protected long startTimestamp;
    protected long endTime;
    protected Itemsets frequentItemsets;
    BufferedWriter writer = null;
    protected int itemsetCount;
    private TriangularMatrix matrix;

    public Itemsets runAlgorithm(String output, TransactionDatabase database, double minsupp, boolean useTriangularMatrixOptimization) throws IOException {
        MemoryLogger.getInstance().reset();
        if (output == null) {
            this.writer = null;
            this.frequentItemsets = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.frequentItemsets = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.database = database;
        this.startTimestamp = System.currentTimeMillis();
        this.minsupRelative = (int)Math.ceil(minsupp * (double)database.size());
        final HashMap<Integer, BitSetSupport> mapItemTIDS = new HashMap<Integer, BitSetSupport>();
        int maxItemId = this.calculateSupportSingleItems(database, mapItemTIDS);
        if (useTriangularMatrixOptimization) {
            this.matrix = new TriangularMatrix(maxItemId + 1);
            for (List<Integer> itemset : database.getTransactions()) {
                Object[] array = itemset.toArray();
                for (int i = 0; i < itemset.size(); ++i) {
                    Integer itemI = (Integer)array[i];
                    for (int j = i + 1; j < itemset.size(); ++j) {
                        Integer itemJ = (Integer)array[j];
                        this.matrix.incrementCount(itemI, itemJ);
                    }
                }
            }
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemTIDS.entrySet()) {
            BitSetSupport tidset = (BitSetSupport)entry.getValue();
            int support = tidset.support;
            int item = (Integer)entry.getKey();
            if (support < this.minsupRelative) continue;
            frequentItems.add(item);
            this.saveSingleItem(item, support, tidset.bitset);
        }
        Collections.sort(frequentItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((BitSetSupport)mapItemTIDS.get((Object)arg0)).support - ((BitSetSupport)mapItemTIDS.get((Object)arg1)).support;
            }
        });
        for (int i = 0; i < frequentItems.size(); ++i) {
            Integer itemI = (Integer)frequentItems.get(i);
            BitSetSupport tidsetI = (BitSetSupport)mapItemTIDS.get(itemI);
            ArrayList<Integer> equivalenceClassIitems = new ArrayList<Integer>();
            ArrayList<BitSetSupport> equivalenceClassItidsets = new ArrayList<BitSetSupport>();
            for (int j = i + 1; j < frequentItems.size(); ++j) {
                int itemJ = (Integer)frequentItems.get(j);
                int supportIJ = -1;
                if (useTriangularMatrixOptimization && (supportIJ = this.matrix.getSupportForItems(itemI, itemJ)) < this.minsupRelative) continue;
                BitSetSupport tidsetJ = (BitSetSupport)mapItemTIDS.get(itemJ);
                BitSetSupport bitsetSupportIJ = useTriangularMatrixOptimization ? this.performANDFirstTime(tidsetI, tidsetJ, supportIJ) : this.performAND(tidsetI, tidsetJ);
                if (!useTriangularMatrixOptimization && bitsetSupportIJ.support < this.minsupRelative) continue;
                equivalenceClassIitems.add(itemJ);
                equivalenceClassItidsets.add(bitsetSupportIJ);
            }
            if (equivalenceClassIitems.size() <= 0) continue;
            this.processEquivalenceClass(new int[]{itemI}, equivalenceClassIitems, equivalenceClassItidsets);
        }
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        return this.frequentItemsets;
    }

    private int calculateSupportSingleItems(TransactionDatabase database, Map<Integer, BitSetSupport> mapItemTIDS) {
        int maxItemId = 0;
        for (int i = 0; i < database.size(); ++i) {
            for (Integer item : database.getTransactions().get(i)) {
                BitSetSupport tids = mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new BitSetSupport();
                    mapItemTIDS.put(item, tids);
                    if (item > maxItemId) {
                        maxItemId = item;
                    }
                }
                tids.bitset.set(i);
                ++tids.support;
            }
        }
        return maxItemId;
    }

    private BitSetSupport performAND(BitSetSupport tidsetI, BitSetSupport tidsetJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.and(tidsetJ.bitset);
        bitsetSupportIJ.support = bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    private BitSetSupport performANDFirstTime(BitSetSupport tidsetI, BitSetSupport tidsetJ, int supportIJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.and(tidsetJ.bitset);
        bitsetSupportIJ.support = supportIJ;
        return bitsetSupportIJ;
    }

    private void processEquivalenceClass(int[] prefix, List<Integer> equivalenceClassItems, List<BitSetSupport> equivalenceClassTidsets) throws IOException {
        if (equivalenceClassItems.size() == 1) {
            int itemI = equivalenceClassItems.get(0);
            BitSetSupport tidsetI = equivalenceClassTidsets.get(0);
            this.save(prefix, itemI, tidsetI);
            return;
        }
        if (equivalenceClassItems.size() == 2) {
            int itemI = equivalenceClassItems.get(0);
            BitSetSupport tidsetI = equivalenceClassTidsets.get(0);
            this.save(prefix, itemI, tidsetI);
            int itemJ = equivalenceClassItems.get(1);
            BitSetSupport tidsetJ = equivalenceClassTidsets.get(1);
            this.save(prefix, itemJ, tidsetJ);
            BitSetSupport bitsetSupportIJ = this.performAND(tidsetI, tidsetJ);
            if (bitsetSupportIJ.support >= this.minsupRelative) {
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = itemI;
                this.save(newPrefix, itemJ, bitsetSupportIJ);
            }
            return;
        }
        for (int i = 0; i < equivalenceClassItems.size(); ++i) {
            int itemI = equivalenceClassItems.get(i);
            BitSetSupport tidsetI = equivalenceClassTidsets.get(i);
            this.save(prefix, itemI, tidsetI);
            ArrayList<Integer> equivalenceClassISuffixItems = new ArrayList<Integer>();
            ArrayList<BitSetSupport> equivalenceITidsets = new ArrayList<BitSetSupport>();
            for (int j = i + 1; j < equivalenceClassItems.size(); ++j) {
                int itemJ = equivalenceClassItems.get(j);
                BitSetSupport tidsetJ = equivalenceClassTidsets.get(j);
                BitSetSupport bitsetSupportIJ = this.performAND(tidsetI, tidsetJ);
                if (bitsetSupportIJ.support < this.minsupRelative) continue;
                equivalenceClassISuffixItems.add(itemJ);
                equivalenceITidsets.add(bitsetSupportIJ);
            }
            if (equivalenceClassISuffixItems.size() <= 0) continue;
            int[] newPrefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
            newPrefix[prefix.length] = itemI;
            this.processEquivalenceClass(newPrefix, equivalenceClassISuffixItems, equivalenceITidsets);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void save(int[] prefix, int suffixItem, BitSetSupport tidset) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            int[] itemsetArray = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, itemsetArray, 0, prefix.length);
            itemsetArray[prefix.length] = suffixItem;
            Itemset itemset = new Itemset(itemsetArray);
            itemset.setTIDs(tidset.bitset, tidset.support);
            this.frequentItemsets.addItemset(itemset, itemset.size());
        } else {
            StringBuffer buffer = new StringBuffer();
            for (int item : prefix) {
                buffer.append(item);
                buffer.append(" ");
            }
            buffer.append(suffixItem);
            buffer.append(" #SUP: ");
            buffer.append(tidset.support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    private void saveSingleItem(int item, int support, BitSet tidset) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            Itemset itemset = new Itemset(new int[]{item});
            itemset.setTIDs(tidset, support);
            this.frequentItemsets.addItemset(itemset, itemset.size());
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append(item);
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  ECLAT vALTERNATE-Bitset - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    public Itemsets getItemsets() {
        return this.frequentItemsets;
    }

    public class BitSetSupport {
        BitSet bitset = new BitSet();
        int support;
    }
}

