/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.charm;

import ca.pfv.spmf.algorithms.frequentpatterns.charm.AlgoCharm_Bitset;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.BitSet;
import java.util.Map;

public class AlgoDCharm_Bitset
extends AlgoCharm_Bitset {
    @Override
    public void printStats() {
        System.out.println("=============  dCharm vALTERNATE-Bitset - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    private int calculateSupportSingleItems(TransactionDatabase database, Map<Integer, AlgoCharm_Bitset.BitSetSupport> mapItemTIDS) {
        int maxItemId = 0;
        for (int i = 0; i < database.size(); ++i) {
            for (Integer item : database.getTransactions().get(i)) {
                AlgoCharm_Bitset.BitSetSupport tids = mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new AlgoCharm_Bitset.BitSetSupport();
                    tids.bitset.set(0, database.size(), true);
                    mapItemTIDS.put(item, tids);
                    if (item > maxItemId) {
                        maxItemId = item;
                    }
                }
                tids.bitset.set(i, false);
                ++tids.support;
            }
        }
        return maxItemId;
    }

    private AlgoCharm_Bitset.BitSetSupport performAND(AlgoCharm_Bitset.BitSetSupport tidsetI, AlgoCharm_Bitset.BitSetSupport tidsetJ) {
        AlgoCharm_Bitset.BitSetSupport bitsetSupportIJ = new AlgoCharm_Bitset.BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetJ.bitset.clone();
        bitsetSupportIJ.bitset.andNot(tidsetI.bitset);
        bitsetSupportIJ.support = tidsetI.support - bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    private AlgoCharm_Bitset.BitSetSupport performANDFirstTime(AlgoCharm_Bitset.BitSetSupport tidsetI, AlgoCharm_Bitset.BitSetSupport tidsetJ, int supportIJ) {
        AlgoCharm_Bitset.BitSetSupport bitsetSupportIJ = new AlgoCharm_Bitset.BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetJ.bitset.clone();
        bitsetSupportIJ.bitset.andNot(tidsetI.bitset);
        bitsetSupportIJ.support = tidsetI.support - bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }
}

