/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.aprioriTID;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoAprioriTID_Bitset {
    protected int k;
    Map<Integer, BitSet> mapItemTIDS = new HashMap<Integer, BitSet>();
    int minSuppRelative;
    int maxItemsetSize = Integer.MAX_VALUE;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    BufferedWriter writer = null;
    private int itemsetCount;
    private int tidcount = 0;

    public void runAlgorithm(String input, String output, double minsup) throws NumberFormatException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        this.writer = new BufferedWriter(new FileWriter(output));
        this.tidcount = 0;
        this.mapItemTIDS = new HashMap<Integer, BitSet>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            MemoryLogger.getInstance().checkMemory();
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            for (String stringItem : lineSplited = line.split(" ")) {
                int item = Integer.parseInt(stringItem);
                BitSet tids = this.mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new BitSet();
                    this.mapItemTIDS.put(item, tids);
                }
                tids.set(this.tidcount);
            }
            ++this.tidcount;
        }
        reader.close();
        this.minSuppRelative = (int)Math.ceil(minsup * (double)this.tidcount);
        this.k = 1;
        List<Itemset> level = new ArrayList<Itemset>();
        Iterator<Map.Entry<Integer, BitSet>> iterator = this.mapItemTIDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BitSet> entry = iterator.next();
            int cardinality = entry.getValue().cardinality();
            if (cardinality >= this.minSuppRelative) {
                Integer item = entry.getKey();
                Itemset itemset = new Itemset(item);
                itemset.setTIDs(this.mapItemTIDS.get(item), cardinality);
                level.add(itemset);
                this.saveItemsetToFile(itemset);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(level, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return o1.get(0) - o2.get(0);
            }
        });
        this.k = 2;
        while (!level.isEmpty() && this.k <= this.maxItemsetSize) {
            level = this.generateCandidateSizeK(level);
            ++this.k;
        }
        this.writer.close();
        this.endTimeStamp = System.currentTimeMillis();
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) throws IOException {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        block0: for (int i = 0; i < levelK_1.size(); ++i) {
            Itemset itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                Itemset itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.size(); ++k) {
                    if (k == itemset1.size() - 1) {
                        if (itemset1.getItems()[k] < itemset2.get(k)) continue;
                        continue block0;
                    }
                    if (itemset1.getItems()[k] < itemset2.get(k)) continue block1;
                    if (itemset1.getItems()[k] > itemset2.get(k)) continue block0;
                }
                Integer missing = itemset2.get(itemset2.size() - 1);
                BitSet list = (BitSet)itemset1.getTransactionsIds().clone();
                list.and(itemset2.getTransactionsIds());
                int cardinality = list.cardinality();
                if (cardinality < this.minSuppRelative) continue;
                int[] newItemset = new int[itemset1.size() + 1];
                System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                Itemset candidate = new Itemset(newItemset);
                candidate.setTIDs(list, cardinality);
                candidates.add(candidate);
                this.saveItemsetToFile(candidate);
            }
        }
        return candidates;
    }

    public void setMaxItemsetSize(int maxItemsetSize) {
        this.maxItemsetSize = maxItemsetSize;
    }

    void saveItemsetToFile(Itemset itemset) throws IOException {
        this.writer.write(itemset.toString() + " #SUP: " + itemset.cardinality);
        this.writer.newLine();
        ++this.itemsetCount;
    }

    public void printStats() {
        System.out.println("=============  APRIORI - STATS =============");
        System.out.println(" Transactions count from database : " + this.tidcount);
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

