/*
 * Decompiled with CFR 0.152.
 */
package jnumeric;

import java.lang.reflect.Array;
import jnumeric.PyMultiarray;
import jnumeric.UnaryFunction;

final class Log
extends UnaryFunction {
    Log() {
    }

    @Override
    String docString() {
        return "log(a [,r]) returns log(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            Array.setDouble(a.data, i, Math.log(Array.getDouble(a.data, i)));
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); i += 2) {
            double re = Array.getDouble(a.data, i);
            double im = Array.getDouble(a.data, i + 1);
            Array.setDouble(a.data, i, Math.log(im * im + re * re) / 2.0);
            Array.setDouble(a.data, i + 1, Math.atan2(im, re));
        }
        return a;
    }
}

