/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

public enum TimeUnit {
    NANOSECOND("ns", "nanosecond", 2.777777777777778E-13),
    MICROSECOND("us", "microsecond", 2.7777777777777777E-10),
    MILLISECOND("ms", "millisecond", 2.7777777777777776E-7),
    SECOND("s", "second", 2.777777777777778E-4),
    MINUTE("min", "minute", 0.016666666666666666),
    HOUR("h", "hour", 1.0),
    DAY("d", "day", 24.0),
    WEEK("w", "week", 168.0);

    private String shortName;
    private String longName;
    private transient double numHours;

    private TimeUnit(String shortName, String longName, double numHours) {
        this.shortName = shortName;
        this.longName = longName;
        this.numHours = numHours;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String toString() {
        return this.longName;
    }

    public double getHours() {
        return this.numHours;
    }

    public static double convert(double value, TimeUnit srcUnit, TimeUnit dstUnit) {
        double hours = value * srcUnit.getHours();
        return hours / dstUnit.getHours();
    }
}

