/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Logger;

public class TextDataReader {
    private static Logger log = Logger.getLogger("umontreal.iro.lecuyer.util");

    public static double[] readDoubleData(Reader input) throws IOException {
        String li;
        LineNumberReader inb = new LineNumberReader(input);
        double[] data = new double[5];
        int n = 0;
        while ((li = inb.readLine()) != null) {
            int index;
            if ((li = li.trim()).startsWith("#")) continue;
            for (index = 0; index < li.length() && (li.charAt(index) == '+' || li.charAt(index) == '-' || li.charAt(index) == 'e' || li.charAt(index) == 'E' || li.charAt(index) == '.' || Character.isDigit(li.charAt(index))); ++index) {
            }
            if ((li = li.substring(0, index)).equals("")) continue;
            try {
                data[n++] = Double.parseDouble(li);
                if (n < data.length) continue;
                double[] newData = new double[2 * n];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            catch (NumberFormatException nfe) {
                log.warning("Invalid line " + inb.getLineNumber() + ": " + li);
            }
        }
        if (data.length != n) {
            double[] data2 = new double[n];
            System.arraycopy(data, 0, data2, 0, n);
            return data2;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readDoubleData(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            double[] dArray = TextDataReader.readDoubleData(reader);
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readDoubleData(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            double[] dArray = TextDataReader.readDoubleData(reader);
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readDoubleData(String file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            double[] dArray = TextDataReader.readDoubleData(reader);
            return dArray;
        }
    }

    public static int[] readIntData(Reader input) throws IOException {
        String li;
        LineNumberReader inb = new LineNumberReader(input);
        int[] data = new int[5];
        int n = 0;
        while ((li = inb.readLine()) != null) {
            int index;
            if ((li = li.trim()).startsWith("#")) continue;
            for (index = 0; index < li.length() && (li.charAt(index) == '+' || li.charAt(index) == '-' || Character.isDigit(li.charAt(index))); ++index) {
            }
            if ((li = li.substring(0, index)).equals("")) continue;
            try {
                data[n++] = Integer.parseInt(li);
                if (n < data.length) continue;
                int[] newData = new int[2 * n];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            catch (NumberFormatException nfe) {
                log.warning("Invalid line " + inb.getLineNumber() + ": " + li);
            }
        }
        if (data.length != n) {
            int[] data2 = new int[n];
            System.arraycopy(data, 0, data2, 0, n);
            return data2;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntData(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            int[] nArray = TextDataReader.readIntData(reader);
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntData(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            int[] nArray = TextDataReader.readIntData(reader);
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntData(String file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            int[] nArray = TextDataReader.readIntData(reader);
            return nArray;
        }
    }

    public static String[] readStringData(Reader input) throws IOException {
        String li;
        LineNumberReader inb = new LineNumberReader(input);
        String[] data = new String[5];
        int n = 0;
        while ((li = inb.readLine()) != null) {
            if ((li = li.trim()).startsWith("#")) continue;
            data[n++] = li;
            if (n < data.length) continue;
            String[] newData = new String[2 * n];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        if (data.length != n) {
            String[] data2 = new String[n];
            System.arraycopy(data, 0, data2, 0, n);
            return data2;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStringData(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            String[] stringArray = TextDataReader.readStringData(reader);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStringData(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            String[] stringArray = TextDataReader.readStringData(reader);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStringData(String file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            String[] stringArray = TextDataReader.readStringData(reader);
            return stringArray;
        }
    }

    public static double[][] readDoubleData2D(Reader input) throws IOException {
        String li;
        LineNumberReader inb = new LineNumberReader(input);
        double[][] data = new double[5][];
        int n = 0;
        while ((li = inb.readLine()) != null) {
            if ((li = li.trim()).startsWith("#")) continue;
            if (li.equals(";")) {
                data[n++] = new double[0];
            } else {
                int index = 0;
                int begin = 0;
                boolean end = false;
                double[] row = new double[5];
                int k = 0;
                while (index < li.length() && !end) {
                    while (index < li.length() && (li.charAt(index) == '+' || li.charAt(index) == '-' || li.charAt(index) == 'e' || li.charAt(index) == 'E' || li.charAt(index) == '.' || Character.isDigit(li.charAt(index)))) {
                        ++index;
                    }
                    if (index >= li.length() || Character.isWhitespace(li.charAt(index))) {
                        String number = li.substring(begin, index);
                        begin = ++index;
                        if (number.equals("")) continue;
                        try {
                            row[k++] = Double.parseDouble(number);
                            if (k < row.length) continue;
                            double[] newRow = new double[2 * k];
                            System.arraycopy(row, 0, newRow, 0, row.length);
                            row = newRow;
                        }
                        catch (NumberFormatException nfe) {
                            log.warning("Invalid column " + k + " at line " + inb.getLineNumber() + ": " + number);
                        }
                        continue;
                    }
                    end = true;
                }
                if (k > 0) {
                    data[n] = new double[k];
                    System.arraycopy(row, 0, data[n], 0, k);
                    ++n;
                } else {
                    log.warning("Invalid line " + inb.getLineNumber() + ": " + li);
                }
            }
            if (n != data.length) continue;
            double[][] newData = new double[2 * n][];
            System.arraycopy(data, 0, newData, 0, n);
            data = newData;
        }
        double[][] data2 = new double[n][];
        System.arraycopy(data, 0, data2, 0, n);
        return data2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] readDoubleData2D(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            double[][] dArray = TextDataReader.readDoubleData2D(reader);
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] readDoubleData2D(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            double[][] dArray = TextDataReader.readDoubleData2D(reader);
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] readDoubleData2D(String file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            double[][] dArray = TextDataReader.readDoubleData2D(reader);
            return dArray;
        }
    }

    public static int[][] readIntData2D(Reader input) throws IOException {
        String li;
        LineNumberReader inb = new LineNumberReader(input);
        int[][] data = new int[5][];
        int n = 0;
        while ((li = inb.readLine()) != null) {
            if ((li = li.trim()).startsWith("#")) continue;
            if (li.equals(";")) {
                data[n++] = new int[0];
            } else {
                int index = 0;
                int begin = 0;
                boolean end = false;
                int[] row = new int[5];
                int k = 0;
                while (index < li.length() && !end) {
                    while (index < li.length() && (li.charAt(index) == '+' || li.charAt(index) == '-' || Character.isDigit(li.charAt(index)))) {
                        ++index;
                    }
                    if (index >= li.length() || Character.isWhitespace(li.charAt(index))) {
                        String number = li.substring(begin, index);
                        begin = ++index;
                        if (number.equals("")) continue;
                        try {
                            row[k++] = Integer.parseInt(number);
                            if (k < row.length) continue;
                            int[] newRow = new int[2 * k];
                            System.arraycopy(row, 0, newRow, 0, row.length);
                            row = newRow;
                        }
                        catch (NumberFormatException nfe) {
                            log.warning("Invalid column " + k + " at line " + inb.getLineNumber() + ": " + number);
                        }
                        continue;
                    }
                    end = true;
                }
                if (k > 0) {
                    data[n] = new int[k];
                    System.arraycopy(row, 0, data[n], 0, k);
                    ++n;
                } else {
                    log.warning("Invalid line " + inb.getLineNumber() + ": " + li);
                }
            }
            if (n != data.length) continue;
            int[][] newData = new int[2 * n][];
            System.arraycopy(data, 0, newData, 0, n);
            data = newData;
        }
        int[][] data2 = new int[n][];
        System.arraycopy(data, 0, data2, 0, n);
        return data2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readIntData2D(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            int[][] nArray = TextDataReader.readIntData2D(reader);
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readIntData2D(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            int[][] nArray = TextDataReader.readIntData2D(reader);
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readIntData2D(String file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            int[][] nArray = TextDataReader.readIntData2D(reader);
            return nArray;
        }
    }

    public static String[][] readCSVData(Reader input, char colDelim, char stringDelim) throws IOException {
        LineNumberReader inb = new LineNumberReader(input);
        StringBuffer sb = new StringBuffer();
        boolean stringMode = false;
        String[][] data = new String[5][];
        int numRows = 0;
        int numColumns = 0;
        boolean newRow = false;
        boolean newColumn = false;
        int ich = -1;
        char ch = ' ';
        boolean readDone = false;
        while (!readDone) {
            if (ich == -2) {
                ich = 0;
            } else {
                ich = inb.read();
                if (ich == -1) {
                    readDone = true;
                    newColumn = true;
                    newRow = true;
                } else {
                    ch = (char)ich;
                }
            }
            if (ich != -1) {
                char chNext;
                if (stringMode) {
                    if (ch == stringDelim) {
                        int ichNext = inb.read();
                        if (ichNext >= 0) {
                            chNext = (char)ichNext;
                            if (chNext == stringDelim) {
                                sb.append(stringDelim);
                            } else {
                                stringMode = false;
                                ich = -2;
                                ch = chNext;
                            }
                        }
                    } else {
                        sb.append(ch);
                    }
                } else if (ch == '\n' || ch == '\r') {
                    int ichNext = inb.read();
                    if (ichNext >= 0) {
                        chNext = (char)ichNext;
                        if (ch == '\r' && chNext == '\n') {
                            ichNext = inb.read();
                            if (ichNext >= 0) {
                                chNext = (char)ichNext;
                                ich = -2;
                                ch = chNext;
                                newRow = true;
                            }
                        } else {
                            ich = -2;
                            ch = chNext;
                            newRow = true;
                        }
                    }
                } else if (ch == colDelim) {
                    newColumn = true;
                } else if (ch == stringDelim) {
                    stringMode = true;
                } else {
                    sb.append(ch);
                }
            }
            if (newColumn || newRow) {
                if (numColumns == 0) {
                    ++numRows;
                    numColumns = 1;
                } else {
                    ++numColumns;
                }
                if (data.length < numRows) {
                    String[][] newData = new String[2 * data.length][];
                    System.arraycopy(data, 0, newData, 0, data.length);
                    data = newData;
                }
                if (data[numRows - 1] == null) {
                    data[numRows - 1] = new String[5];
                } else if (data[numRows - 1].length < numColumns) {
                    String[] newData = new String[2 * data[numRows - 1].length];
                    System.arraycopy(data[numRows - 1], 0, newData, 0, data[numRows - 1].length);
                    data[numRows - 1] = newData;
                }
                data[numRows - 1][numColumns - 1] = sb.toString();
                sb.delete(0, sb.length());
                newColumn = false;
            }
            if (!newRow) continue;
            if (data[numRows - 1].length != numColumns) {
                String[] data2 = new String[numColumns];
                System.arraycopy(data[numRows - 1], 0, data2, 0, numColumns);
                data[numRows - 1] = data2;
            }
            numColumns = 0;
            newRow = false;
        }
        if (stringMode) {
            throw new IllegalArgumentException("Too many string delimiters " + stringDelim);
        }
        if (data.length != numRows) {
            String[][] data2 = new String[numRows][];
            System.arraycopy(data, 0, data2, 0, numRows);
            return data2;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] readCSVData(URL url, char colDelim, char stringDelim) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            String[][] stringArray = TextDataReader.readCSVData(reader, colDelim, stringDelim);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] readCSVData(File file, char colDelim, char stringDelim) throws IOException {
        try (FileReader reader = new FileReader(file);){
            String[][] stringArray = TextDataReader.readCSVData(reader, colDelim, stringDelim);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] readCSVData(String file, char colDelim, char stringDelim) throws IOException {
        try (FileReader reader = new FileReader(file);){
            String[][] stringArray = TextDataReader.readCSVData(reader, colDelim, stringDelim);
            return stringArray;
        }
    }
}

