/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.GammaProcessPCA;
import umontreal.iro.lecuyer.stochprocess.VarianceGammaProcessDiff;

public class VarianceGammaProcessDiffPCA
extends VarianceGammaProcessDiff {
    int[] indexEigenUp;
    int[] indexEigenDw;

    public VarianceGammaProcessDiffPCA(double s0, double theta, double sigma, double nu, RandomStream stream) {
        super(s0, theta, sigma, nu, new GammaProcessPCA(0.0, 1.0, 1.0, stream), new GammaProcessPCA(0.0, 1.0, 1.0, stream));
    }

    public VarianceGammaProcessDiffPCA(double s0, double theta, double sigma, double nu, GammaProcessPCA gpos, GammaProcessPCA gneg) {
        super(s0, theta, sigma, nu, gpos, gneg);
    }

    @Override
    public double nextObservation() {
        throw new UnsupportedOperationException("Impossible with PCA, use generatePath() instead.");
    }

    @Override
    public double[] generatePath() {
        double[] u = new double[2 * this.d];
        for (int i = 0; i < 2 * this.d; ++i) {
            u[i] = this.getStream().nextDouble();
        }
        return this.generatePath(u);
    }

    @Override
    public double[] generatePath(double[] uniform01) {
        int dd = uniform01.length;
        int d = dd / 2;
        if (dd % 2 != 0) {
            throw new IllegalArgumentException("The Array uniform01 must have a even length");
        }
        double[] QMCpointsUP = new double[d];
        double[] QMCpointsDW = new double[d];
        for (int i = 0; i < d; ++i) {
            QMCpointsUP[i] = uniform01[this.indexEigenUp[i]];
            QMCpointsDW[i] = uniform01[this.indexEigenDw[i]];
        }
        this.gpos.resetStartProcess();
        this.gneg.resetStartProcess();
        double[] pathUP = this.gpos.generatePath(QMCpointsUP);
        double[] pathDOWN = this.gneg.generatePath(QMCpointsDW);
        for (int i = 0; i < d; ++i) {
            this.path[i + 1] = this.x0 + pathUP[i + 1] - pathDOWN[i + 1];
        }
        this.observationIndex = d;
        this.observationCounter = d;
        return this.path;
    }

    @Override
    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            double[] eigenValUp = ((GammaProcessPCA)this.gpos).getBMPCA().getSortedEigenvalues();
            double[] eigenValDw = ((GammaProcessPCA)this.gneg).getBMPCA().getSortedEigenvalues();
            this.indexEigenUp = new int[this.d];
            this.indexEigenDw = new int[this.d];
            int iUp = 0;
            int iDw = 0;
            for (int iQMC = 0; iQMC < 2 * this.d; ++iQMC) {
                if (iUp == this.d) {
                    this.indexEigenDw[iDw] = iQMC;
                    ++iDw;
                    continue;
                }
                if (iDw == this.d) {
                    this.indexEigenUp[iUp] = iQMC;
                    ++iUp;
                    continue;
                }
                if (eigenValUp[iUp] >= eigenValDw[iDw]) {
                    this.indexEigenUp[iUp] = iQMC;
                    ++iUp;
                    continue;
                }
                this.indexEigenDw[iDw] = iQMC;
                ++iDw;
            }
        }
    }
}

