/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvarmulti;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvarmulti.MultinormalGen;

public class MultinormalPCAGen
extends MultinormalGen {
    private double[] lambda;

    private static SingularValueDecomposition getSvd(DoubleMatrix2D sigma) {
        return new SingularValueDecomposition(sigma);
    }

    private DoubleMatrix2D decompPCA(SingularValueDecomposition svd) {
        DoubleMatrix2D D = svd.getS();
        for (int i = 0; i < D.rows(); ++i) {
            this.lambda[i] = D.getQuick(i, i);
            D.setQuick(i, i, Math.sqrt(D.getQuick(i, i)));
        }
        DoubleMatrix2D P = svd.getV();
        return P.zMult(D, null);
    }

    private void initL() {
        if (this.mu.length != this.sigma.rows() || this.mu.length != this.sigma.columns()) {
            throw new IllegalArgumentException("Incompatible mean vector and covariance matrix");
        }
        this.lambda = new double[this.mu.length];
        this.sqrtSigma = this.decompPCA(MultinormalPCAGen.getSvd(this.sigma));
    }

    public MultinormalPCAGen(NormalGen gen1, double[] mu, double[][] sigma) {
        super(gen1, mu, sigma);
        this.initL();
    }

    public MultinormalPCAGen(NormalGen gen1, double[] mu, DoubleMatrix2D sigma) {
        super(gen1, mu, sigma);
        this.initL();
    }

    public static DoubleMatrix2D decompPCA(double[][] sigma) {
        return MultinormalPCAGen.decompPCA(new DenseDoubleMatrix2D(sigma));
    }

    public static DoubleMatrix2D decompPCA(DoubleMatrix2D sigma) {
        SingularValueDecomposition sv = MultinormalPCAGen.getSvd(sigma);
        DoubleMatrix2D D = sv.getS();
        for (int i = 0; i < D.rows(); ++i) {
            D.setQuick(i, i, Math.sqrt(D.getQuick(i, i)));
        }
        DoubleMatrix2D P = sv.getV();
        return P.zMult(D, null);
    }

    public DoubleMatrix2D getPCADecompSigma() {
        return this.sqrtSigma.copy();
    }

    public static double[] getLambda(DoubleMatrix2D sigma) {
        SingularValueDecomposition sv = MultinormalPCAGen.getSvd(sigma);
        DoubleMatrix2D D = sv.getS();
        double[] lambd = new double[D.rows()];
        for (int i = 0; i < D.rows(); ++i) {
            lambd[i] = D.getQuick(i, i);
        }
        return lambd;
    }

    public double[] getLambda() {
        return this.lambda;
    }

    public void setSigma(DoubleMatrix2D sigma) {
        if (sigma.rows() != this.mu.length || sigma.columns() != this.mu.length) {
            throw new IllegalArgumentException("Invalid dimensions of covariance matrix");
        }
        this.sigma.assign(sigma);
        this.sqrtSigma = this.decompPCA(MultinormalPCAGen.getSvd(sigma));
    }

    public static void nextPoint(NormalGen gen1, double[] mu, DoubleMatrix2D sigma, double[] p) {
        int i;
        if (gen1 == null) {
            throw new NullPointerException("gen1 is null");
        }
        NormalDist dist = (NormalDist)gen1.getDistribution();
        if (dist.getMu() != 0.0) {
            throw new IllegalArgumentException("mu != 0");
        }
        if (dist.getSigma() != 1.0) {
            throw new IllegalArgumentException("sigma != 1");
        }
        if (mu.length != sigma.rows() || mu.length != sigma.columns()) {
            throw new IllegalArgumentException("Incompatible mean vector and covariance matrix dimensions");
        }
        double[] temp = new double[mu.length];
        DoubleMatrix2D sqrtSigma = MultinormalPCAGen.decompPCA(sigma);
        for (i = 0; i < temp.length; ++i) {
            temp[i] = gen1.nextDouble();
            if (temp[i] == Double.NEGATIVE_INFINITY) {
                temp[i] = -37.54;
            }
            if (temp[i] != Double.POSITIVE_INFINITY) continue;
            temp[i] = 37.54;
        }
        for (i = 0; i < temp.length; ++i) {
            p[i] = 0.0;
            for (int c = 0; c < temp.length; ++c) {
                int n = i;
                p[n] = p[n] + sqrtSigma.getQuick(i, c) * temp[c];
            }
            int n = i;
            p[n] = p[n] + mu[i];
        }
    }

    public static void nextPoint(NormalGen gen1, double[] mu, double[][] sigma, double[] p) {
        MultinormalPCAGen.nextPoint(gen1, mu, new DenseDoubleMatrix2D(sigma), p);
    }

    @Override
    public void nextPoint(double[] p) {
        int i;
        int n = this.mu.length;
        for (i = 0; i < n; ++i) {
            this.temp[i] = this.gen1.nextDouble();
            if (this.temp[i] == Double.NEGATIVE_INFINITY) {
                this.temp[i] = -37.54;
            }
            if (this.temp[i] != Double.POSITIVE_INFINITY) continue;
            this.temp[i] = 37.54;
        }
        for (i = 0; i < n; ++i) {
            p[i] = 0.0;
            for (int c = 0; c < n; ++c) {
                int n2 = i;
                p[n2] = p[n2] + this.sqrtSigma.getQuick(i, c) * this.temp[c];
            }
            int n3 = i;
            p[n3] = p[n3] + this.mu[i];
        }
    }
}

