/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.InverseGaussianDist;
import umontreal.iro.lecuyer.randvar.InverseGaussianGen;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class InverseGaussianMSHGen
extends InverseGaussianGen {
    private NormalGen genN;

    public InverseGaussianMSHGen(RandomStream s, NormalGen sn, double mu, double lambda) {
        super(s, null);
        this.setParams(mu, lambda, sn);
    }

    public InverseGaussianMSHGen(RandomStream s, NormalGen sn, InverseGaussianDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getLambda(), sn);
        }
    }

    public static double nextDouble(RandomStream s, NormalGen sn, double mu, double lambda) {
        return InverseGaussianMSHGen.mhs(s, sn, mu, lambda);
    }

    @Override
    public double nextDouble() {
        return InverseGaussianMSHGen.mhs(this.stream, this.genN, this.mu, this.lambda);
    }

    private static double mhs(RandomStream stream, NormalGen genN, double mu, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (mu <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        double z = genN.nextDouble();
        double ymu = mu * z * z;
        double x1 = mu + 0.5 * mu * ymu / lambda - 0.5 * mu / lambda * Math.sqrt(4.0 * ymu * lambda + ymu * ymu);
        double u = stream.nextDouble();
        if (u <= mu / (mu + x1)) {
            return x1;
        }
        return mu * mu / x1;
    }

    protected void setParams(double mu, double lambda, NormalGen sn) {
        this.setParams(mu, lambda);
        this.genN = sn;
    }
}

