/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class JohnsonSBDist
extends ContinuousDistribution {
    private double gamma;
    private double delta;
    private double xi;
    private double lambda;

    public JohnsonSBDist(double gamma, double delta, double xi, double lambda) {
        this.setParams(gamma, delta, xi, lambda);
    }

    @Override
    public double density(double x) {
        return JohnsonSBDist.density(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    @Override
    public double cdf(double x) {
        return JohnsonSBDist.cdf(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    @Override
    public double barF(double x) {
        return JohnsonSBDist.barF(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    @Override
    public double inverseF(double u) {
        return JohnsonSBDist.inverseF(this.gamma, this.delta, this.xi, this.lambda, u);
    }

    public static double density(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi || x >= xi + lambda) {
            return 0.0;
        }
        double y = (x - xi) / lambda;
        double t1 = gamma + delta * Math.log(y / (1.0 - y));
        return delta / (lambda * y * (1.0 - y) * Math.sqrt(Math.PI * 2)) * Math.exp(-t1 * t1 / 2.0);
    }

    public static double cdf(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi) {
            return 0.0;
        }
        if (x >= xi + lambda) {
            return 1.0;
        }
        double y = (x - xi) / lambda;
        return NormalDist.cdf01(gamma + delta * Math.log(y / (1.0 - y)));
    }

    public static double barF(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi) {
            return 1.0;
        }
        if (x >= xi + lambda) {
            return 0.0;
        }
        double y = (x - xi) / lambda;
        return NormalDist.barF01(gamma + delta * Math.log(y / (1.0 - y)));
    }

    public static double inverseF(double gamma, double delta, double xi, double lambda, double u) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return xi + lambda;
        }
        if (u <= 0.0) {
            return xi;
        }
        double z = NormalDist.inverseF01(u);
        double v = (z - gamma) / delta;
        if (z >= 100.0 || v >= 709.782712893384) {
            return xi + lambda;
        }
        if (z <= -100.0 || v <= -709.782712893384) {
            return xi;
        }
        v = Math.exp(v);
        return (xi + (xi + lambda) * v) / (1.0 + v);
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getXi() {
        return this.xi;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = gamma;
        this.delta = delta;
        this.xi = xi;
        this.lambda = lambda;
        this.supportA = xi;
        this.supportB = xi + lambda;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.gamma, this.delta, this.xi, this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : gamma = " + this.gamma + ", delta = " + this.delta + ", xi = " + this.xi + ", lambda = " + this.lambda;
    }
}

