/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.Distribution;

public abstract class DiscreteDistributionInt
implements Distribution {
    public static double EPSILON = 1.0E-16;
    protected static final double EPS_EXTRA = 0.01;
    protected double[] cdf = null;
    protected double[] pdf = null;
    protected int xmin = 0;
    protected int xmax = 0;
    protected int xmed = 0;
    protected int supportA = Integer.MIN_VALUE;
    protected int supportB = Integer.MAX_VALUE;

    public abstract double prob(int var1);

    @Override
    public double cdf(double x) {
        return this.cdf((int)x);
    }

    public abstract double cdf(int var1);

    @Override
    public double barF(double x) {
        return this.barF((int)x);
    }

    public double barF(int x) {
        return 1.0 - this.cdf(x - 1);
    }

    public int getXinf() {
        return this.supportA;
    }

    public int getXsup() {
        return this.supportB;
    }

    @Override
    public double inverseF(double u) {
        return this.inverseFInt(u);
    }

    public int inverseFInt(double u) {
        int i;
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (u <= 0.0) {
            return this.supportA;
        }
        if (u >= 1.0) {
            return this.supportB;
        }
        if (u <= this.cdf[this.xmed - this.xmin]) {
            if (u <= this.cdf[0]) {
                return this.xmin;
            }
            i = 0;
            int j = this.xmed - this.xmin;
            while (i < j) {
                int k = (i + j) / 2;
                if (u > this.cdf[k]) {
                    i = k + 1;
                    continue;
                }
                j = k;
            }
        } else {
            if ((u = 1.0 - u) < this.cdf[this.xmax - this.xmin]) {
                return this.xmax;
            }
            i = this.xmed - this.xmin + 1;
            int j = this.xmax - this.xmin;
            while (i < j) {
                int k = (i + j) / 2;
                if (u < this.cdf[k]) {
                    i = k + 1;
                    continue;
                }
                j = k;
            }
            --i;
        }
        return i + this.xmin;
    }
}

