/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.DigitalNetBase2;
import umontreal.iro.lecuyer.hups.PointSetIterator;

public abstract class DigitalSequenceBase2
extends DigitalNetBase2 {
    public abstract void extendSequence(int var1);

    private int[] copyDigitalShift(int[] S) {
        if (S == null) {
            return null;
        }
        int[] T = new int[S.length];
        for (int i = 0; i < S.length; ++i) {
            T[i] = S[i];
        }
        return T;
    }

    private DigitalNetBase2 initNetVar(boolean shiftFlag) {
        DigitalNetBase2 net = new DigitalNetBase2();
        net.dim = shiftFlag ? this.dim + 1 : this.dim;
        net.numPoints = this.numPoints;
        net.numCols = this.numCols;
        net.numRows = this.numRows;
        net.outDigits = this.outDigits;
        net.normFactor = this.normFactor;
        net.factor = new double[this.outDigits];
        net.genMat = new int[net.dim * this.numCols];
        net.shiftStream = this.shiftStream;
        net.capacityShift = this.capacityShift;
        net.dimShift = this.dimShift;
        net.digitalShift = this.copyDigitalShift(this.digitalShift);
        if (shiftFlag && this.shiftStream != null) {
            net.addRandomShift(this.dimShift, this.dimShift + 1, this.shiftStream);
        }
        return net;
    }

    public DigitalNetBase2 toNet() {
        DigitalNetBase2 net = this.initNetVar(false);
        for (int i = 0; i < this.dim * this.numCols; ++i) {
            net.genMat[i] = this.genMat[i];
        }
        return net;
    }

    public DigitalNetBase2 toNetShiftCj() {
        int c;
        DigitalNetBase2 net = this.initNetVar(true);
        for (c = (this.dim + 1) * this.numCols - 1; c >= this.numCols; --c) {
            net.genMat[c] = this.genMat[c - this.numCols];
        }
        for (c = 0; c < this.numCols; ++c) {
            net.genMat[c] = 1 << this.outDigits - this.numCols + c;
        }
        return net;
    }

    public PointSetIterator iteratorShift() {
        return new DigitalNetBase2IteratorShiftGenerators();
    }

    public PointSetIterator iteratorShiftNoGray() {
        return new DigitalNetBase2IteratorShiftNoGray();
    }

    protected class DigitalNetBase2IteratorShiftNoGray
    extends DigitalNetBase2.DigitalNetBase2Iterator {
        private boolean shiftDimFlag = false;

        public DigitalNetBase2IteratorShiftNoGray() {
            this.dimS = DigitalSequenceBase2.this.dim + 1;
            if (DigitalSequenceBase2.this.digitalShift != null && DigitalSequenceBase2.this.dimShift < this.dimS) {
                DigitalSequenceBase2.this.addRandomShift(DigitalSequenceBase2.this.dimShift, this.dimS, DigitalSequenceBase2.this.shiftStream);
            }
            this.resetCurPointIndex();
        }

        @Override
        public void init2() {
        }

        @Override
        protected void addShiftToCache() {
            if (DigitalSequenceBase2.this.digitalShift == null) {
                for (int j = 0; j <= DigitalSequenceBase2.this.dim; ++j) {
                    this.cachedCurPoint[j] = 0;
                }
            } else {
                for (int j = 0; j <= DigitalSequenceBase2.this.dim; ++j) {
                    this.cachedCurPoint[j] = DigitalSequenceBase2.this.digitalShift[j];
                }
            }
        }

        @Override
        public void setCurPointIndex(int i) {
            if (i == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            this.addShiftToCache();
            int pos = 0;
            while (i >> pos != 0) {
                if ((i >> pos & 1) != 0) {
                    this.cachedCurPoint[0] = this.cachedCurPoint[0] ^ 1 << DigitalSequenceBase2.this.outDigits - DigitalSequenceBase2.this.numCols + pos;
                    for (int j = 1; j <= DigitalSequenceBase2.this.dim; ++j) {
                        int n = j;
                        this.cachedCurPoint[n] = this.cachedCurPoint[n] ^ DigitalSequenceBase2.this.genMat[(j - 1) * DigitalSequenceBase2.this.numCols + pos];
                    }
                }
                ++pos;
            }
        }

        @Override
        public int resetToNextPoint() {
            if (this.curPointIndex + 1 >= DigitalSequenceBase2.this.numPoints) {
                return ++this.curPointIndex;
            }
            int diff = this.curPointIndex ^ this.curPointIndex + 1;
            int pos = 0;
            while (diff >> pos != 0) {
                if ((diff >> pos & 1) != 0) {
                    this.cachedCurPoint[0] = this.cachedCurPoint[0] ^ 1 << DigitalSequenceBase2.this.outDigits - DigitalSequenceBase2.this.numCols + pos;
                    for (int j = 1; j <= DigitalSequenceBase2.this.dim; ++j) {
                        int n = j;
                        this.cachedCurPoint[n] = this.cachedCurPoint[n] ^ DigitalSequenceBase2.this.genMat[(j - 1) * DigitalSequenceBase2.this.numCols + pos];
                    }
                }
                ++pos;
            }
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }
    }

    protected class DigitalNetBase2IteratorShiftGenerators
    extends DigitalNetBase2.DigitalNetBase2Iterator {
        public DigitalNetBase2IteratorShiftGenerators() {
            this.dimS = DigitalSequenceBase2.this.dim + 1;
            if (DigitalSequenceBase2.this.digitalShift != null && DigitalSequenceBase2.this.dimShift < this.dimS) {
                DigitalSequenceBase2.this.addRandomShift(DigitalSequenceBase2.this.dimShift, this.dimS, DigitalSequenceBase2.this.shiftStream);
            }
            this.resetCurPointIndex();
        }

        @Override
        public void init2() {
        }

        @Override
        protected void addShiftToCache() {
            if (DigitalSequenceBase2.this.digitalShift == null) {
                for (int j = 0; j < this.dimS; ++j) {
                    this.cachedCurPoint[j] = 0;
                }
            } else {
                for (int j = 0; j < this.dimS; ++j) {
                    this.cachedCurPoint[j] = DigitalSequenceBase2.this.digitalShift[j];
                }
            }
        }

        @Override
        public void setCurPointIndex(int i) {
            if (i == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            this.addShiftToCache();
            int grayCode = i ^ i >> 1;
            int pos = 0;
            while (grayCode >> pos != 0) {
                if ((grayCode >> pos & 1) != 0) {
                    this.cachedCurPoint[0] = this.cachedCurPoint[0] ^ 1 << DigitalSequenceBase2.this.outDigits - DigitalSequenceBase2.this.numCols + pos;
                    for (int j = 1; j <= DigitalSequenceBase2.this.dim; ++j) {
                        int n = j;
                        this.cachedCurPoint[n] = this.cachedCurPoint[n] ^ DigitalSequenceBase2.this.genMat[(j - 1) * DigitalSequenceBase2.this.numCols + pos];
                    }
                }
                ++pos;
            }
        }

        @Override
        public int resetToNextPoint() {
            int pos = 0;
            while ((this.curPointIndex >> pos & 1) != 0) {
                ++pos;
            }
            if (pos < DigitalSequenceBase2.this.numCols) {
                this.cachedCurPoint[0] = this.cachedCurPoint[0] ^ 1 << DigitalSequenceBase2.this.outDigits - DigitalSequenceBase2.this.numCols + pos;
                for (int j = 1; j <= DigitalSequenceBase2.this.dim; ++j) {
                    int n = j;
                    this.cachedCurPoint[n] = this.cachedCurPoint[n] ^ DigitalSequenceBase2.this.genMat[(j - 1) * DigitalSequenceBase2.this.numCols + pos];
                }
            }
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }
    }
}

