/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.DiscreteDistribution;
import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class GofStat {
    private static double EPSILOND = 1.0E-15;
    public static double EPSILONAD = 1.110223E-16f;

    private GofStat() {
    }

    public static DoubleArrayList unifTransform(DoubleArrayList data, ContinuousDistribution dist) {
        double[] v = data.elements();
        int n = data.size();
        double[] u = new double[n];
        for (int i = 0; i < n; ++i) {
            u[i] = dist.cdf(v[i]);
        }
        return new DoubleArrayList(u);
    }

    public static DoubleArrayList unifTransform(DoubleArrayList data, DiscreteDistribution dist) {
        double[] v = data.elements();
        int n = data.size();
        double[] u = new double[n];
        for (int i = 0; i < n; ++i) {
            u[i] = dist.cdf((int)v[i]);
        }
        return new DoubleArrayList(u);
    }

    public static void diff(IntArrayList sortedData, IntArrayList spacings, int n1, int n2, int a, int b) {
        if (n1 < 0 || n2 < 0 || n1 >= n2 || n2 >= sortedData.size()) {
            throw new IllegalArgumentException("n1 and n2 not valid.");
        }
        int[] u = sortedData.elements();
        int n = sortedData.size();
        if (spacings.size() <= n2 + 2) {
            spacings.setSize(n2 + 2);
        }
        int[] d = spacings.elements();
        d[n1] = u[n1] - a;
        for (int i = n1 + 1; i <= n2; ++i) {
            d[i] = u[i] - u[i - 1];
        }
        d[n2 + 1] = b - u[n2];
    }

    public static void diff(DoubleArrayList sortedData, DoubleArrayList spacings, int n1, int n2, double a, double b) {
        if (n1 < 0 || n2 < 0 || n1 >= n2 || n2 >= sortedData.size()) {
            throw new IllegalArgumentException("n1 and n2 not valid.");
        }
        double[] u = sortedData.elements();
        int n = sortedData.size();
        if (spacings.size() <= n2 + 2) {
            spacings.setSize(n2 + 2);
        }
        double[] d = spacings.elements();
        d[n1] = u[n1] - a;
        for (int i = n1 + 1; i <= n2; ++i) {
            d[i] = u[i] - u[i - 1];
        }
        d[n2 + 1] = b - u[n2];
    }

    public static void iterateSpacings(DoubleArrayList data, DoubleArrayList spacings) {
        int i;
        if (spacings.size() < data.size() + 1) {
            throw new IllegalArgumentException("Invalid array sizes.");
        }
        double[] v = data.elements();
        spacings.quickSortFromTo(0, data.size());
        double[] s = spacings.elements();
        int n = data.size();
        for (i = 0; i < n; ++i) {
            s[n - i] = (double)(i + 1) * (s[n - i] - s[n - i - 1]);
        }
        s[0] = (double)(n + 1) * s[0];
        v[0] = s[0];
        for (i = 1; i < n; ++i) {
            v[i] = v[i - 1] + s[i];
        }
    }

    public static void powerRatios(DoubleArrayList sortedData) {
        double[] u = sortedData.elements();
        int n = sortedData.size();
        for (int i = 0; i < n - 1; ++i) {
            u[i] = u[i + 1] == 0.0 || u[i + 1] == -0.0 ? 1.0 : Math.pow(u[i] / u[i + 1], (double)i + 1.0);
        }
        u[n - 1] = Math.pow(u[n - 1], n);
        sortedData.quickSortFromTo(0, sortedData.size() - 1);
    }

    public static double chi2(double[] nbExp, int[] count, int smin, int smax) {
        double khi = 0.0;
        for (int s = smin; s <= smax; ++s) {
            if (nbExp[s] <= 0.0) {
                if (count[s] == 0) continue;
                throw new IllegalArgumentException("nbExp[s] = 0 and count[s] > 0");
            }
            double diff = (double)count[s] - nbExp[s];
            khi += diff * diff / nbExp[s];
        }
        return khi;
    }

    public static double chi2(IntArrayList data, DiscreteDistributionInt dist, int smin, int smax, double minExp, int[] numCat) {
        int n = data.size();
        int i = smin;
        while (dist.prob(i) * (double)n <= DiscreteDistributionInt.EPSILON) {
            ++i;
        }
        smin = i--;
        while (smax <= smin) {
            smax = 2 * smax + 1;
        }
        double[] nbExp = new double[smax + 1];
        do {
            if (++i > smax) {
                double[] newNbExp = new double[(smax *= 2) + 1];
                System.arraycopy(nbExp, smin, newNbExp, smin, nbExp.length - smin);
                nbExp = newNbExp;
            }
            nbExp[i] = dist.prob(i) * (double)n;
        } while (nbExp[i] > DiscreteDistributionInt.EPSILON);
        smax = i - 1;
        OutcomeCategoriesChi2 cat = new OutcomeCategoriesChi2(nbExp, smin, smax);
        cat.regroupCategories(minExp);
        if (numCat != null) {
            numCat[0] = cat.nbCategories;
        }
        int[] count = new int[cat.smax + 1];
        for (i = 0; i < count.length; ++i) {
            count[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            int s = data.get(i);
            while (cat.loc[s] != s) {
                s = cat.loc[s];
            }
            int n2 = s;
            count[n2] = count[n2] + 1;
        }
        return GofStat.chi2(cat.nbExp, count, cat.smin, cat.smax);
    }

    public static double chi2Equal(double nbExp, int[] count, int smin, int smax) {
        double khi = 0.0;
        for (int s = smin; s <= smax; ++s) {
            double diff = (double)count[s] - nbExp;
            khi += diff * diff;
        }
        return khi / nbExp;
    }

    public static double chi2Equal(DoubleArrayList data, double minExp) {
        int n = data.size();
        if (n < (int)Math.ceil(minExp)) {
            throw new IllegalArgumentException("Not enough observations");
        }
        double p = minExp / (double)n;
        int m = (int)Math.ceil(1.0 / p);
        int[] count = new int[m + 1];
        for (int i = 0; i < n; ++i) {
            int j;
            int n2 = j = (int)Math.floor(data.get(i) / p);
            count[n2] = count[n2] + 1;
        }
        int n3 = m - 1;
        count[n3] = count[n3] + count[m];
        return GofStat.chi2Equal(minExp, count, 0, m - 1);
    }

    public static double chi2Equal(DoubleArrayList data) {
        return GofStat.chi2Equal(data, 10.0);
    }

    public static int scan(DoubleArrayList sortedData, double d) {
        double[] u = sortedData.elements();
        int n = sortedData.size();
        int m = 1;
        int j = 0;
        int i = -1;
        double High = 0.0;
        while (j < n - 1 && High < 1.0) {
            High = u[++i] + d;
            while (j < n && u[j] < High) {
                ++j;
            }
            if (j - i <= m) continue;
            m = j - i;
        }
        return m;
    }

    public static double cramerVonMises(DoubleArrayList sortedData) {
        double[] u = sortedData.elements();
        int n = sortedData.size();
        if (n <= 0) {
            System.err.println("cramerVonMises:  n <= 0");
            return 0.0;
        }
        double w2 = 1.0 / (double)(12 * n);
        for (int i = 0; i < n; ++i) {
            double w = u[i] - ((double)i + 0.5) / (double)n;
            w2 += w * w;
        }
        return w2;
    }

    public static double watsonG(DoubleArrayList sortedData) {
        double[] u = sortedData.elements();
        int n = sortedData.size();
        double unSurN = 1.0 / (double)n;
        if (n <= 0) {
            System.err.println("watsonG: n <= 0");
            return 0.0;
        }
        if (n == 1) {
            return 0.0;
        }
        double sumZ = 0.0;
        double dp = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = (double)(i + 1) * unSurN - u[i];
            if (d2 > dp) {
                dp = d2;
            }
            sumZ += u[i];
        }
        sumZ = sumZ * unSurN - 0.5;
        double g = Math.sqrt(n) * (dp + sumZ);
        return g;
    }

    public static double watsonU(DoubleArrayList sortedData) {
        double[] u = sortedData.elements();
        int n = sortedData.size();
        if (n <= 0) {
            System.err.println("watsonU: n <= 0");
            return 0.0;
        }
        if (n == 1) {
            return 0.08333333333333333;
        }
        double sumZ = 0.0;
        double w2 = 1.0 / (double)(12 * n);
        for (int i = 0; i < n; ++i) {
            sumZ += u[i];
            double w = u[i] - ((double)i + 0.5) / (double)n;
            w2 += w * w;
        }
        sumZ = sumZ / (double)n - 0.5;
        double u2 = w2 - sumZ * sumZ * (double)n;
        return u2;
    }

    public static double andersonDarling(DoubleArrayList sortedData) {
        double[] v = sortedData.elements();
        int n = sortedData.size();
        if (n <= 0) {
            System.err.println("andersonDarling: n <= 0");
            return 0.0;
        }
        double a2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double u = v[i];
            double u1 = 1.0 - u;
            if (u < EPSILONAD) {
                u = EPSILONAD;
            } else if (u1 < EPSILONAD) {
                u1 = EPSILONAD;
            }
            a2 += (double)(2 * i + 1) * Math.log(u) + (double)(1 + 2 * (n - i - 1)) * Math.log(u1);
        }
        a2 = (double)(-n) - a2 / (double)n;
        return a2;
    }

    public static double[] kolmogorovSmirnov(DoubleArrayList sortedData) {
        double[] ret = new double[3];
        double[] u = sortedData.elements();
        int n = sortedData.size();
        if (n <= 0) {
            ret[2] = 0.0;
            ret[1] = 0.0;
            ret[0] = 0.0;
            System.err.println("kolmogorovSmirnov:   n <= 0");
            return ret;
        }
        double[] retjo = GofStat.kolmogorovSmirnovJumpOne(sortedData, 0.0);
        ret[0] = retjo[0];
        ret[1] = retjo[1];
        ret[2] = ret[1] > ret[0] ? ret[1] : ret[0];
        return ret;
    }

    public static double[] kolmogorovSmirnovJumpOne(DoubleArrayList sortedData, double a) {
        int j;
        double[] u = sortedData.elements();
        int n = sortedData.size();
        double[] ret = new double[2];
        if (n <= 0) {
            ret[1] = 0.0;
            ret[0] = 0.0;
            System.err.println("kolmogorovSmirnovJumpOne: n <= 0");
            return ret;
        }
        ret[0] = 0.0;
        ret[1] = 0.0;
        double unSurN = 1.0 / (double)n;
        for (j = 0; j < n && u[j] <= a + EPSILOND; ++j) {
        }
        for (int i = j - 1; i < n; ++i) {
            double d2;
            double d1;
            if (i >= 0 && (d1 = (double)(i + 1) * unSurN - u[i]) > ret[0]) {
                ret[0] = d1;
            }
            if (i < j || !((d2 = u[i] - (double)i * unSurN) > ret[1])) continue;
            ret[1] = d2;
        }
        return ret;
    }

    public static double pDisc(double pL, double pR) {
        double p = pR < pL ? pR : (pL > 0.5 ? 0.5 : 1.0 - pL);
        return p;
    }

    public static class OutcomeCategoriesChi2 {
        public int nbCategories;
        public int smin;
        public int smax;
        public double[] nbExp;
        public int[] loc;

        public OutcomeCategoriesChi2(double[] nbExp) {
            this.nbExp = nbExp;
            this.smin = 0;
            this.smax = nbExp.length - 1;
            this.nbCategories = nbExp.length;
            this.loc = new int[nbExp.length];
            for (int i = 0; i < nbExp.length; ++i) {
                this.loc[i] = i;
            }
        }

        public OutcomeCategoriesChi2(double[] nbExp, int smin, int smax) {
            int i;
            this.nbExp = nbExp;
            this.smin = smin;
            this.smax = smax;
            this.nbCategories = smax - smin + 1;
            this.loc = new int[nbExp.length];
            for (i = 0; i < smin; ++i) {
                this.loc[i] = smin;
            }
            for (i = smin; i < smax; ++i) {
                this.loc[i] = i;
            }
            for (i = smax; i < nbExp.length; ++i) {
                this.loc[i] = smax;
            }
        }

        public OutcomeCategoriesChi2(double[] nbExp, int[] loc, int smin, int smax, int nbCat) {
            this.nbExp = nbExp;
            this.smin = smin;
            this.smax = smax;
            this.nbCategories = nbCat;
            this.loc = loc;
        }

        public void regroupCategories(double minExp) {
            int j;
            int s0 = 0;
            this.nbCategories = 0;
            for (int s = this.smin; s <= this.smax; ++s) {
                if (this.nbExp[s] < minExp) {
                    double somme;
                    s0 = s;
                    for (somme = this.nbExp[s]; somme < minExp && s < this.smax; somme += this.nbExp[++s]) {
                        this.nbExp[s] = 0.0;
                    }
                    this.nbExp[s] = somme;
                    for (j = s0; j <= s; ++j) {
                        this.loc[j] = s;
                    }
                } else {
                    this.loc[s] = s;
                }
                ++this.nbCategories;
            }
            this.smin = this.loc[this.smin];
            if (this.nbExp[this.smax] < minExp) {
                if (s0 > this.smin) {
                    // empty if block
                }
                int n = --s0;
                this.nbExp[n] = this.nbExp[n] + this.nbExp[this.smax];
                this.nbExp[this.smax] = 0.0;
                --this.nbCategories;
                for (j = s0 + 1; j <= this.smax; ++j) {
                    this.loc[j] = s0;
                }
                this.smax = s0;
            }
            if (this.nbCategories <= 1) {
                throw new IllegalStateException("nbCategories < 2");
            }
        }

        public String toString() {
            double EPSILON = 5.0E-16;
            StringBuffer sb = new StringBuffer();
            sb.append("-----------------------------------------------" + PrintfFormat.NEWLINE);
            if (this.nbExp[this.smin] < 5.0E-16) {
                sb.append("Only expected numbers larger than " + PrintfFormat.g(6, 1, 5.0E-16) + "  are printed" + PrintfFormat.NEWLINE);
            }
            sb.append("Number of categories: " + PrintfFormat.d(4, this.nbCategories) + PrintfFormat.NEWLINE + "Expected numbers per category:" + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE + "Category s      nbExp[s]" + PrintfFormat.NEWLINE);
            int s = this.smin;
            while (this.nbExp[s] < 5.0E-16) {
                ++s;
            }
            int s1 = s;
            s = this.smax;
            while (this.nbExp[s] < 5.0E-16) {
                --s;
            }
            int s2 = s;
            double somme = 0.0;
            for (s = s1; s <= s2; ++s) {
                if (this.loc[s] != s) continue;
                somme += this.nbExp[s];
                sb.append(PrintfFormat.d(4, s) + " " + PrintfFormat.f(18, 4, this.nbExp[s]) + PrintfFormat.NEWLINE);
            }
            sb.append(PrintfFormat.NEWLINE + "Total expected number = " + PrintfFormat.f(18, 2, somme) + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE + "The groupings:" + PrintfFormat.NEWLINE + " Category s      loc[s]" + PrintfFormat.NEWLINE);
            for (s = this.smin; s <= this.smax; ++s) {
                if (s == this.smin && s > 0) {
                    sb.append("<= ");
                } else if (s == this.smax && s < this.loc.length - 1) {
                    sb.append(">= ");
                } else {
                    sb.append("   ");
                }
                sb.append(PrintfFormat.d(4, s) + " " + PrintfFormat.d(12, this.loc[s]) + PrintfFormat.NEWLINE);
            }
            sb.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
            return sb.toString();
        }
    }
}

