/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import java.util.Arrays;
import umontreal.iro.lecuyer.functions.MathFunction;

public class PiecewiseConstantFunction
implements MathFunction {
    private double[] x;
    private double[] y;

    public PiecewiseConstantFunction(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException();
        }
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
    }

    public double[] getX() {
        return (double[])this.x.clone();
    }

    public double[] getY() {
        return (double[])this.y.clone();
    }

    @Override
    public double evaluate(double x) {
        int idx = Arrays.binarySearch(this.x, x);
        if (idx >= 0) {
            return this.y[idx];
        }
        int insertionPoint = -(idx + 1);
        return this.y[insertionPoint];
    }
}

