/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import umontreal.iro.lecuyer.charts.Axis;
import umontreal.iro.lecuyer.charts.XYLineChart;
import umontreal.iro.lecuyer.charts.XYListSeriesCollection;

public class ChartTest2 {
    private static double[][] getPoints1() {
        double[][] points = new double[2][40];
        for (int i = 0; i < points[0].length; ++i) {
            double x;
            points[0][i] = x = (double)i / 4.0;
            points[1][i] = Math.sqrt(x);
        }
        return points;
    }

    private static double[][] getPoints2() {
        double[][] points = new double[2][21];
        for (int i = 0; i < points[0].length; ++i) {
            double x;
            points[0][i] = x = -Math.PI + (double)(2 * i) * Math.PI / (double)(points[0].length - 1);
            points[1][i] = Math.cos(x);
        }
        return points;
    }

    private static double[][] getPoints3() {
        double[][] points = new double[2][11];
        for (int i = 0; i < points[0].length; ++i) {
            points[0][i] = -5 + i;
            points[1][i] = -3 + i;
        }
        return points;
    }

    public static void main(String[] args) {
        double[][] data1 = ChartTest2.getPoints1();
        double[][] data2 = ChartTest2.getPoints2();
        double[][] data3 = ChartTest2.getPoints3();
        XYLineChart chart = new XYLineChart(null, "X", "Y", data1, data2, data3);
        Axis xaxis = chart.getXAxis();
        Axis yaxis = chart.getYAxis();
        String[] labels = new String[]{"-9", "$-\\lambda$", "$-\\sqrt{2}$", "0", "$\\frac{14}{\\pi}$", "\\LaTeX"};
        double[] values = new double[]{-9.0, -5.0, -Math.sqrt(2.0), 0.0, 4.45633840657307, 9.0};
        xaxis.setLabels(values, labels);
        yaxis.setLabels(1.0);
        XYListSeriesCollection collec = chart.getSeriesCollection();
        collec.setColor(0, new Color(0, 64, 128));
        collec.setName(0, "$f(x) = \\sqrt(x)$");
        collec.setMarksType(0, "");
        collec.setDashPattern(0, "dotted");
        collec.setName(1, "$f(x) = \\cos(x)$");
        collec.setMarksType(1, "");
        collec.setColor(2, Color.ORANGE);
        collec.setPlotStyle(2, "ycomb,very thick");
        collec.setMarksType(2, "*");
        chart.toLatexFile("ChartTest2.tex", 12.0, 8.0);
    }
}

