/*
 * Decompiled with CFR 0.152.
 */
package probrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.BitSet;
import java.util.zip.CRC32;

public final class Util {
    private Util() {
    }

    public static Point centreWithin(Rectangle rec, Dimension dim) {
        Point pos = new Point();
        pos.x = rec.x + (rec.width - dim.width >> 1);
        pos.y = rec.y + (rec.height - dim.height >> 1);
        return pos;
    }

    public static Point rightWithin(Rectangle rec, Dimension dim) {
        Point pos = new Point();
        pos.x = rec.x + rec.width;
        pos.y = rec.y;
        return pos;
    }

    public static Point belowWithin(Rectangle rec, Dimension dim) {
        Point pos = new Point();
        pos.x = rec.x;
        pos.y = rec.y + rec.height;
        return pos;
    }

    public static void centreWithin(Component parent, Component child) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension win = child.getSize();
        Point p = Util.centreWithin(parent.getBounds(), win);
        int diff = screen.width - p.x - win.width;
        if (diff < 0) {
            p.x += diff;
        }
        if ((diff = screen.height - p.y - win.height) < 0) {
            p.y += diff;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        child.setLocation(p);
    }

    public static void rightWithin(Component parent, Component child) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension win = child.getSize();
        Point p = Util.rightWithin(parent.getBounds(), win);
        int diff = screen.width - p.x - win.width;
        if (diff < 0) {
            p.x += diff;
        }
        if ((diff = screen.height - p.y - win.height) < 0) {
            p.y += diff;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        child.setLocation(p);
    }

    public static void belowWithin(Component parent, Component child) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension win = child.getSize();
        Point p = Util.belowWithin(parent.getBounds(), win);
        int diff = screen.width - p.x - win.width;
        if (diff < 0) {
            p.x += diff;
        }
        if ((diff = screen.height - p.y - win.height) < 0) {
            p.y += diff;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        child.setLocation(p);
    }

    public static String fileNameOfPath(String path) {
        if (path == null) {
            return "";
        }
        File f = new File(path);
        return f.getName();
    }

    public static String pathNameOfPath(String path) {
        if (path == null) {
            return "";
        }
        File f = new File(path);
        return f.getParent();
    }

    public static String substituteText(String text, String token, String substitute) {
        int index;
        if (token == null || substitute == null || (index = text.indexOf(token)) < 0) {
            return text;
        }
        while (index > -1) {
            text = text.substring(0, index) + substitute + text.substring(index + token.length());
            index = text.indexOf(token);
        }
        return text;
    }

    public static String substituteTextS(String text, String token, String substitute) {
        int index;
        if (token == null || substitute == null || (index = text.indexOf(token)) < 0) {
            return text;
        }
        if (index > -1) {
            text = text.substring(0, index) + substitute + text.substring(index + token.length());
        }
        return text;
    }

    public static String htmlEncoded(String text) {
        int len = text.length();
        StringBuffer b = new StringBuffer(len * 3);
        block6: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    continue block6;
                }
                case '>': {
                    b.append("&gt;");
                    continue block6;
                }
                case '&': {
                    b.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    b.append("&quot;");
                    continue block6;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        if (inputFile == null | outputFile == null) {
            throw new IllegalArgumentException("null pointer");
        }
        if (inputFile.equals(outputFile)) {
            throw new IllegalArgumentException("illegal self reference");
        }
        byte[] buffer = new byte[2048];
        try {
            int len;
            File parent = inputFile.getAbsoluteFile().getParentFile();
            if (!outputFile.isAbsolute()) {
                outputFile = new File(parent, outputFile.getPath());
            }
            Util.ensureFilePath(outputFile, parent);
            in = new FileInputStream(inputFile);
            out = new FileOutputStream(outputFile);
            CRC32 crcSum = new CRC32();
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                crcSum.update(buffer, 0, len);
            }
            in.close();
            out.close();
            int writeCrc = (int)crcSum.getValue();
            in = new FileInputStream(outputFile);
            crcSum.reset();
            while ((len = in.read(buffer)) != -1) {
                crcSum.update(buffer, 0, len);
            }
            if (writeCrc != (int)crcSum.getValue()) {
                throw new StreamCorruptedException("bad copy CRC");
            }
        }
        catch (IOException e) {
            System.err.println("*** error during file copy: " + outputFile.getAbsolutePath());
            System.err.println(e);
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static boolean ensureFilePath(File file, File defaultDir) {
        File parent = file.getParentFile();
        if (parent != null) {
            return Util.ensureDirectory(parent, defaultDir);
        }
        return true;
    }

    public static boolean ensureDirectory(File dir, File defaultDir) {
        boolean success = true;
        if (dir == null) {
            throw new IllegalArgumentException("dir = null");
        }
        if (!dir.isAbsolute()) {
            dir = new File(defaultDir, dir.getPath());
        }
        if (!dir.isDirectory()) {
            boolean bl = success = !dir.isFile() && dir.mkdirs();
            if (!success) {
                System.err.println("failed while trying to create directory: " + dir.toString());
            }
        }
        return success;
    }

    public static int textVariance(char[] ca) {
        BitSet set = new BitSet();
        for (int i = 0; i < ca.length; ++i) {
            set.set(ca[i]);
        }
        return set.cardinality();
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Util.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

